/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrosoftTranslate
extends BaseTranslate {
    protected static final String URL_TOKEN = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13/";
    protected static final String URL_TRANSLATE = "http://api.microsofttranslator.com/v2/Http.svc/Translate";
    protected static final Pattern RE_RESPONSE = Pattern.compile("<string.+?>(.+)</string>");
    protected String accessToken;
    int pos;
    String str;

    @Override
    protected String getPreferenceName() {
        return "allow_microsoft_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_MICROSOFT");
    }

    /*
     * Loose catch block
     */
    @Override
    protected synchronized String translate(Language sLang, Language tLang, String text) throws Exception {
        text = text.length() > 10000 ? text.substring(0, 9997) + "..." : text;
        String langFrom = this.checkMSLang(sLang);
        String langTo = this.checkMSLang(tLang);
        try {
            block8: {
                if (this.accessToken != null) break block8;
                this.requestToken();
                return this.requestTranslate(langFrom, langTo, text);
                {
                    catch (WikiGet.ResponseError ex) {
                        return ex.getLocalizedMessage();
                    }
                }
            }
            try {
                return this.requestTranslate(langFrom, langTo, text);
            }
            catch (WikiGet.ResponseError ex) {
                if (ex.code == 400) {
                    this.requestToken();
                    return this.requestTranslate(langFrom, langTo, text);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            Log.log(ex);
            return ex.getLocalizedMessage();
        }
    }

    private String checkMSLang(Language language) {
        if (language.getLanguage().compareToIgnoreCase("zh-cn") == 0) {
            return "zh-CHS";
        }
        if (language.getLanguage().compareToIgnoreCase("zh-tw") == 0 || language.getLanguage().compareToIgnoreCase("zh-hk") == 0) {
            return "zh-CHT";
        }
        return language.getLanguageCode();
    }

    private void requestToken() throws Exception {
        TreeMap<String, String> p = new TreeMap<String, String>();
        if (System.getProperty("microsoft.api.client_id") == null || System.getProperty("microsoft.api.client_secret") == null) {
            throw new Exception(OStrings.getString("MT_ENGINE_MICROSOFT_KEY_NOTFOUND"));
        }
        p.put("client_id", System.getProperty("microsoft.api.client_id"));
        p.put("client_secret", System.getProperty("microsoft.api.client_secret"));
        p.put("scope", "http://api.microsofttranslator.com");
        p.put("grant_type", "client_credentials");
        String r = WikiGet.post(URL_TOKEN, p, null);
        Map<String, String> rmap = this.unpackJson(r);
        this.accessToken = rmap.get("access_token");
    }

    private String requestTranslate(String langFrom, String langTo, String text) throws Exception {
        TreeMap<String, String> p = new TreeMap<String, String>();
        p.put("appId", "Bearer " + this.accessToken);
        p.put("text", text);
        p.put("from", langFrom);
        p.put("to", langTo);
        p.put("contentType", "text/plain");
        String r = WikiGet.get(URL_TRANSLATE, p, null);
        Matcher m = RE_RESPONSE.matcher(r);
        if (m.matches()) {
            String translatedText = m.group(1);
            translatedText = translatedText.replace("&lt;", "<");
            translatedText = translatedText.replace("&gt;", ">");
            return translatedText;
        }
        Log.logWarningRB("MT_ENGINE_MICROSOFT_WRONG_RESPONSE", new Object[0]);
        return null;
    }

    public Map<String, String> unpackJson(String v) {
        if (!v.startsWith("{") || !v.endsWith("}")) {
            throw new RuntimeException("Wrong");
        }
        this.str = v.substring(1, v.length() - 1);
        this.pos = 0;
        TreeMap<String, String> result = new TreeMap<String, String>();
        while (true) {
            String key = this.readString();
            this.mustBe(':');
            String value = this.readString();
            result.put(key, value);
            if (this.pos == this.str.length()) break;
            this.mustBe(',');
        }
        return result;
    }

    String readString() {
        if (this.str.charAt(this.pos) != '\"') {
            throw new RuntimeException("Wrong");
        }
        int pose = this.str.indexOf(34, this.pos + 1);
        if (pose < 0) {
            throw new RuntimeException("Wrong");
        }
        String result = this.str.substring(this.pos + 1, pose);
        this.pos = pose + 1;
        return result;
    }

    void mustBe(char c) {
        if (this.str.charAt(this.pos) != c) {
            throw new RuntimeException("Wrong");
        }
        ++this.pos;
    }
}

