/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXReader2;
import org.omegat.util.TMXWriter2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTMX {
    protected static final String PROP_FILE = "file";
    protected static final String PROP_ID = "id";
    protected static final String PROP_PREV = "prev";
    protected static final String PROP_NEXT = "next";
    protected static final String PROP_PATH = "path";
    Map<String, TMXEntry> defaults;
    Map<EntryKey, TMXEntry> alternatives;
    final CheckOrphanedCallback checkOrphanedCallback;

    public ProjectTMX(Language sourceLanguage, Language targetLanguage, boolean isSentenceSegmentingEnabled, File file, CheckOrphanedCallback callback) throws Exception {
        this.checkOrphanedCallback = callback;
        this.alternatives = new HashMap<EntryKey, TMXEntry>();
        this.defaults = new HashMap<String, TMXEntry>();
        if (!file.exists()) {
            return;
        }
        new TMXReader2().readTMX(file, sourceLanguage, targetLanguage, isSentenceSegmentingEnabled, false, true, false, new Loader(sourceLanguage, targetLanguage, isSentenceSegmentingEnabled));
    }

    public ProjectTMX() {
        this.alternatives = new HashMap<EntryKey, TMXEntry>();
        this.defaults = new HashMap<String, TMXEntry>();
        this.checkOrphanedCallback = null;
    }

    public boolean isEmpty() {
        return this.defaults.isEmpty() && this.alternatives.isEmpty();
    }

    public void save(ProjectProperties props, String translationFile, boolean translationUpdatedByUser) throws Exception {
        if (!translationUpdatedByUser) {
            Log.logInfoRB("LOG_DATAENGINE_SAVE_NONEED", new Object[0]);
            return;
        }
        File newFile = new File(translationFile + ".new");
        this.exportTMX(props, newFile, false, false, true);
        File backup = new File(translationFile + ".bak");
        File orig = new File(translationFile);
        if (backup.exists() && !backup.delete()) {
            throw new IOException("Error delete backup file");
        }
        if (orig.exists() && !orig.renameTo(backup)) {
            throw new IOException("Error rename old file to backup");
        }
        if (!newFile.renameTo(orig)) {
            throw new IOException("Error rename new file to tmx");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTMX(ProjectProperties props, File outFile, boolean forceValidTMX, boolean levelTwo, boolean useOrphaned) throws Exception {
        TMXWriter2 wr = new TMXWriter2(outFile, props.getSourceLanguage(), props.getTargetLanguage(), props.isSentenceSegmentingEnabled(), levelTwo, forceValidTMX);
        try {
            TreeMap<String, TMXEntry> tempDefaults = new TreeMap<String, TMXEntry>();
            TreeMap<Object, TMXEntry> tempAlternatives = new TreeMap<Object, TMXEntry>();
            ProjectTMX projectTMX = this;
            synchronized (projectTMX) {
                if (useOrphaned) {
                    tempDefaults.putAll(this.defaults);
                    tempAlternatives.putAll(this.alternatives);
                } else {
                    for (Map.Entry<String, TMXEntry> entry : this.defaults.entrySet()) {
                        if (!this.checkOrphanedCallback.existSourceInProject(entry.getKey())) continue;
                        tempDefaults.put(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<Object, TMXEntry> entry : this.alternatives.entrySet()) {
                        if (!this.checkOrphanedCallback.existEntryInProject((EntryKey)entry.getKey())) continue;
                        tempAlternatives.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            wr.writeComment(" Default translations ");
            for (Map.Entry en : new TreeMap(tempDefaults).entrySet()) {
                wr.writeEntry((String)en.getKey(), ((TMXEntry)en.getValue()).translation, (TMXEntry)en.getValue(), null);
            }
            wr.writeComment(" Alternative translations ");
            for (Map.Entry en : new TreeMap(tempAlternatives).entrySet()) {
                EntryKey entryKey = (EntryKey)en.getKey();
                wr.writeEntry(((EntryKey)en.getKey()).sourceText, ((TMXEntry)en.getValue()).translation, (TMXEntry)en.getValue(), new String[]{PROP_FILE, entryKey.file, PROP_ID, entryKey.id, PROP_PREV, entryKey.prev, PROP_NEXT, entryKey.next, PROP_PATH, entryKey.path});
            }
        }
        finally {
            wr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMXEntry getDefaultTranslation(String source) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            return this.defaults.get(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMXEntry getMultipleTranslation(EntryKey ek) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            return this.alternatives.get(ek);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            if (te == null) {
                if (isDefault) {
                    this.defaults.remove(ste.getKey().sourceText);
                } else {
                    this.alternatives.remove(ste.getKey());
                }
            } else if (isDefault) {
                this.defaults.put(ste.getKey().sourceText, te);
            } else {
                this.alternatives.put(ste.getKey(), te);
            }
        }
    }

    private EntryKey createKeyByProps(String src, Map<String, String> props) {
        return new EntryKey(props.get(PROP_FILE), src, props.get(PROP_ID), props.get(PROP_PREV), props.get(PROP_NEXT), props.get(PROP_PATH));
    }

    public Collection<TMXEntry> getDefaults() {
        return this.defaults.values();
    }

    public Collection<TMXEntry> getAlternatives() {
        return this.alternatives.values();
    }

    private void clear() {
        this.defaults = null;
        this.alternatives = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateDeltaAndApply(ProjectTMX tmxForDelta, ProjectTMX tmxToApply) {
        ProjectTMX projectTMX = this;
        synchronized (projectTMX) {
            ProjectTMX deltaLocal = ProjectTMX.calculateDelta(tmxForDelta, this);
            tmxForDelta.clear();
            this.applyTMXandDelta(tmxToApply, deltaLocal);
        }
    }

    public static ProjectTMX calculateDelta(ProjectTMX baseTMX, ProjectTMX changedTMX) {
        TMXEntry newEntry;
        ProjectTMX delta = new ProjectTMX();
        for (Map.Entry<String, TMXEntry> entry : baseTMX.defaults.entrySet()) {
            newEntry = changedTMX.defaults.get(entry.getKey());
            if (entry.getValue().equalsTranslation(newEntry)) continue;
            delta.defaults.put(entry.getKey(), newEntry);
        }
        for (Map.Entry<Object, TMXEntry> entry : baseTMX.alternatives.entrySet()) {
            newEntry = changedTMX.alternatives.get(entry.getKey());
            if (entry.getValue().equalsTranslation(newEntry)) continue;
            delta.alternatives.put((EntryKey)entry.getKey(), newEntry);
        }
        if (changedTMX.defaults != null) {
            for (Map.Entry<Object, TMXEntry> entry : changedTMX.defaults.entrySet()) {
                if (baseTMX.defaults.containsKey(entry.getKey())) continue;
                delta.defaults.put((String)entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<Object, TMXEntry> entry : changedTMX.alternatives.entrySet()) {
            if (baseTMX.alternatives.containsKey(entry.getKey())) continue;
            delta.alternatives.put((EntryKey)entry.getKey(), entry.getValue());
        }
        return delta;
    }

    private void applyTMXandDelta(ProjectTMX newTMX, ProjectTMX delta) {
        this.defaults = newTMX.defaults;
        this.alternatives = newTMX.alternatives;
        for (Map.Entry<String, TMXEntry> entry : delta.defaults.entrySet()) {
            if (entry.getValue() != null) {
                this.defaults.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.defaults.remove(entry.getKey());
        }
        for (Map.Entry<Object, TMXEntry> entry : delta.alternatives.entrySet()) {
            if (entry.getValue() != null) {
                this.alternatives.put((EntryKey)entry.getKey(), entry.getValue());
                continue;
            }
            this.alternatives.remove(entry.getKey());
        }
    }

    public static interface CheckOrphanedCallback {
        public boolean existEntryInProject(EntryKey var1);

        public boolean existSourceInProject(String var1);
    }

    private class Loader
    implements TMXReader2.LoadCallback {
        private final Language sourceLang;
        private final Language targetLang;
        private final boolean sentenceSegmentingEnabled;

        public Loader(Language sourceLang, Language targetLang, boolean sentenceSegmentingEnabled) {
            this.sourceLang = sourceLang;
            this.targetLang = targetLang;
            this.sentenceSegmentingEnabled = sentenceSegmentingEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onEntry(TMXReader2.ParsedTu tu, TMXReader2.ParsedTuv tuvSource, TMXReader2.ParsedTuv tuvTarget, boolean isParagraphSegtype) {
            if (tuvSource == null) {
                return false;
            }
            String changer = null;
            long dt = 0L;
            String translation = null;
            if (tuvTarget != null) {
                changer = StringUtil.nvl(tuvTarget.changeid, tuvTarget.creationid, tu.changeid, tu.creationid);
                dt = StringUtil.nvlLong(tuvTarget.changedate, tuvTarget.creationdate, tu.changedate, tu.creationdate);
                translation = tuvTarget.text;
            }
            ArrayList<String> sources = new ArrayList<String>();
            ArrayList<String> targets = new ArrayList<String>();
            Segmenter.segmentEntries(this.sentenceSegmentingEnabled && isParagraphSegtype, this.sourceLang, tuvSource.text, this.targetLang, translation, sources, targets);
            Loader loader = this;
            synchronized (loader) {
                for (int i = 0; i < sources.size(); ++i) {
                    String segmentSource = (String)sources.get(i);
                    String segmentTranslation = (String)targets.get(i);
                    EntryKey key = ProjectTMX.this.createKeyByProps(segmentSource, tu.props);
                    boolean defaultTranslation = key.file == null;
                    TMXEntry te = new TMXEntry(segmentSource, segmentTranslation, changer, dt, tu.note, defaultTranslation);
                    if (defaultTranslation) {
                        ProjectTMX.this.defaults.put(segmentSource, te);
                        continue;
                    }
                    ProjectTMX.this.alternatives.put(key, te);
                }
            }
            return true;
        }
    }
}

