/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import gen.core.filters.Filters;
import java.io.File;
import org.omegat.core.data.ProjectException;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class ProjectProperties {
    private String projectName;
    private String projectRoot;
    private String sourceRoot;
    private String targetRoot;
    private String glossaryRoot;
    private String writeableGlossaryFile;
    private String tmRoot;
    private String tmAutoRoot;
    private String dictRoot;
    private String tmOtherLangRoot;
    private Language sourceLanguage;
    private Language targetLanguage;
    private boolean sentenceSegmentingOn;
    private boolean supportDefaultTranslations;
    private boolean removeTags;
    private SRX projectSRX;
    private Filters projectFilters;
    private String externalCommand;

    protected ProjectProperties() {
    }

    public ProjectProperties(File projectDir) {
        this.setProjectName(projectDir.getName());
        this.setProjectRoot(projectDir.getAbsolutePath() + File.separator);
        this.setSourceRoot(this.projectRoot + "source" + File.separator);
        this.setTargetRoot(this.projectRoot + "target" + File.separator);
        this.setGlossaryRoot(this.projectRoot + "glossary" + File.separator);
        this.setWriteableGlossary(this.projectRoot + "glossary" + File.separator + projectDir.getName() + "-glossary.txt");
        this.setTMRoot(this.projectRoot + "tm" + File.separator);
        this.setTMAutoRoot(this.tmRoot + "auto" + File.separator);
        this.setDictRoot(this.projectRoot + "dictionary" + File.separator);
        this.setTMOtherLangRoot(this.tmRoot + "tmx2source" + File.separator);
        this.setSentenceSegmentingEnabled(true);
        this.setSupportDefaultTranslations(true);
        this.setRemoveTags(false);
        String sourceLocale = Preferences.getPreference("source_lang");
        if (!StringUtil.isEmpty(sourceLocale)) {
            this.setSourceLanguage(sourceLocale);
        } else {
            this.setSourceLanguage("EN-US");
        }
        String targetLocale = Preferences.getPreference("target_lang");
        if (!StringUtil.isEmpty(targetLocale)) {
            this.setTargetLanguage(targetLocale);
        } else {
            this.setTargetLanguage("EN-GB");
        }
        this.projectSRX = SRX.loadSRX(new File(this.getProjectInternal(), "segmentation.conf"));
    }

    public String getTargetRoot() {
        return this.targetRoot;
    }

    public void setTargetRoot(String targetRoot) {
        this.targetRoot = targetRoot;
    }

    public String getGlossaryRoot() {
        return this.glossaryRoot;
    }

    public void setGlossaryRoot(String glossaryRoot) {
        this.glossaryRoot = glossaryRoot;
    }

    public String getWriteableGlossary() {
        return this.writeableGlossaryFile;
    }

    public String getWriteableGlossaryDir() {
        File fDir = new File(this.writeableGlossaryFile);
        String sDir = fDir.getParent();
        return sDir;
    }

    public void setWriteableGlossary(String writeableGlossaryFile) {
        this.writeableGlossaryFile = writeableGlossaryFile;
    }

    public String getTMRoot() {
        return this.tmRoot;
    }

    public void setTMRoot(String tmRoot) {
        this.tmRoot = tmRoot;
    }

    public void setTMOtherLangRoot(String otherLangRoot) {
        this.tmOtherLangRoot = otherLangRoot;
    }

    public String getTMOtherLangRoot() {
        return this.tmOtherLangRoot;
    }

    public String getTMAutoRoot() {
        return this.tmAutoRoot;
    }

    public void setTMAutoRoot(String tmAutoRoot) {
        this.tmAutoRoot = tmAutoRoot;
    }

    public String getDictRoot() {
        return this.dictRoot;
    }

    public void setDictRoot(String dictRoot) {
        this.dictRoot = dictRoot;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public String getProjectInternal() {
        return this.projectRoot + "omegat" + File.separator;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(Language sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = new Language(sourceLanguage);
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(Language targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public void setTargetLanguage(String targetLanguage) {
        this.targetLanguage = new Language(targetLanguage);
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingOn;
    }

    public void setSentenceSegmentingEnabled(boolean sentenceSegmentingOn) {
        this.sentenceSegmentingOn = sentenceSegmentingOn;
    }

    public boolean isSupportDefaultTranslations() {
        return this.supportDefaultTranslations;
    }

    public void setSupportDefaultTranslations(boolean supportDefaultTranslations) {
        this.supportDefaultTranslations = supportDefaultTranslations;
    }

    public boolean isRemoveTags() {
        return this.removeTags;
    }

    public void setRemoveTags(boolean removeTags) {
        this.removeTags = removeTags;
    }

    public SRX getProjectSRX() {
        return this.projectSRX;
    }

    public void setProjectSRX(SRX projectSRX) {
        this.projectSRX = projectSRX;
    }

    public Filters getProjectFilters() {
        return this.projectFilters;
    }

    public void setProjectFilters(Filters projectFilters) {
        this.projectFilters = projectFilters;
    }

    public String getExternalCommand() {
        return this.externalCommand;
    }

    public void setExternalCommand(String command) {
        this.externalCommand = command;
    }

    public boolean isProjectValid() {
        boolean returnValue;
        try {
            this.verifyProject();
            returnValue = true;
        }
        catch (ProjectException ex) {
            returnValue = false;
        }
        return returnValue;
    }

    public void verifyProject() throws ProjectException {
        String srcDir = this.getSourceRoot();
        File src = new File(srcDir);
        if (!src.exists()) {
            throw new ProjectException(StaticUtils.format(OStrings.getString("PROJECT_SOURCE_FOLDER"), srcDir));
        }
        String tgtDir = this.getTargetRoot();
        File tgt = new File(tgtDir);
        if (!tgt.exists()) {
            throw new ProjectException(StaticUtils.format(OStrings.getString("PROJECT_TARGET_FOLDER"), tgtDir));
        }
        String glsDir = this.getGlossaryRoot();
        File gls = new File(glsDir);
        if (!gls.exists()) {
            throw new ProjectException(StaticUtils.format(OStrings.getString("PROJECT_GLOSSARY_FOLDER"), glsDir));
        }
        String wGlsDir = this.getWriteableGlossaryDir();
        if (!wGlsDir.endsWith(File.separator)) {
            wGlsDir = wGlsDir + File.separator;
        }
        if (!wGlsDir.contains(this.getGlossaryRoot())) {
            throw new ProjectException(StaticUtils.format(OStrings.getString("PROJECT_W_GLOSSARY"), glsDir));
        }
        String tmxDir = this.getTMRoot();
        File tmx = new File(tmxDir);
        if (!tmx.exists()) {
            throw new ProjectException(StaticUtils.format(OStrings.getString("PROJECT_TM_FOLDER"), tmxDir));
        }
        File dict = new File(this.getDictRoot());
        if (!dict.exists() && this.getDictRoot().equals(this.projectRoot + "dictionary" + File.separator)) {
            dict.mkdirs();
        }
    }

    private static boolean verifyLangCode(String code) {
        for (int i = 0; i < code.length(); ++i) {
            if (Character.isLetter(code.charAt(i))) continue;
            return false;
        }
        return new Language(code).getDisplayName().length() > 0;
    }

    public static boolean verifySingleLangCode(String code) {
        if (code.length() == 2 || code.length() == 3) {
            return ProjectProperties.verifyLangCode(code);
        }
        if (code.length() == 5 || code.length() == 6) {
            int shift = 0;
            if (code.length() == 6) {
                shift = 1;
            }
            return ProjectProperties.verifyLangCode(code.substring(0, 2 + shift)) && (code.charAt(2 + shift) == '-' || code.charAt(2 + shift) == '_') && ProjectProperties.verifyLangCode(code.substring(3 + shift, 5 + shift));
        }
        return false;
    }
}

