/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.NotLoadedProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.team.IRemoteRepository;

public class ProjectFactory {
    public static void createNotLoadedProject() {
        Core.setProject(new NotLoadedProject());
    }

    public static void createProject(ProjectProperties newProps) {
        RealProject p = new RealProject(newProps, null);
        p.createProject();
        Core.setProject(p);
        Core.getAutoSave().enable();
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.CREATE);
    }

    public static void loadProject(ProjectProperties props, IRemoteRepository repository, boolean onlineMode) {
        Core.getAutoSave().disable();
        RealProject p = new RealProject(props, repository);
        p.loadProject(onlineMode);
        Core.setProject(p);
        Core.getAutoSave().enable();
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
    }

    public static void closeProject() {
        Core.getAutoSave().disable();
        Core.getProject().closeProject();
        Core.setProject(new NotLoadedProject());
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE);
    }
}

