/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SVNWCUtil {
    private static final String ECLIPSE_AUTH_MANAGER_CLASSNAME = "org.tmatesoft.svn.core.internal.wc.EclipseSVNAuthenticationManager";
    private static Boolean ourIsEclipse;

    public static File getDefaultConfigurationDirectory() {
        if (SVNFileUtil.isWindows && !SVNFileUtil.isOS2) {
            return new File(SVNFileUtil.getApplicationDataPath(), "Subversion");
        }
        if (SVNFileUtil.isOpenVMS) {
            return new File("/sys$login", ".subversion").getAbsoluteFile();
        }
        return new File(System.getProperty("user.home"), ".subversion");
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager() {
        return SVNWCUtil.createDefaultAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), null, null);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir) {
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, null, null, true);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(String userName, String password) {
        return SVNWCUtil.createDefaultAuthenticationManager(null, userName, password);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password) {
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(configDir, true);
        boolean store = options.isAuthStorageEnabled();
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, userName, password, store);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password, boolean storeAuth) {
        return SVNWCUtil.createDefaultAuthenticationManager(configDir, userName, password, null, null, storeAuth);
    }

    public static ISVNAuthenticationManager createDefaultAuthenticationManager(File configDir, String userName, String password, File privateKey, String passphrase, boolean storeAuth) {
        if (SVNWCUtil.isEclipse()) {
            try {
                Constructor<?> method;
                Class<?> managerClass;
                ClassLoader loader = SVNWCUtil.class.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                if ((managerClass = loader.loadClass(ECLIPSE_AUTH_MANAGER_CLASSNAME)) != null && (method = managerClass.getConstructor(File.class, Boolean.TYPE, String.class, String.class, File.class, String.class)) != null) {
                    return (ISVNAuthenticationManager)method.newInstance(configDir, storeAuth ? Boolean.TRUE : Boolean.FALSE, userName, password, privateKey, passphrase);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return new DefaultSVNAuthenticationManager(configDir, storeAuth, userName, password, privateKey, passphrase);
    }

    public static DefaultSVNOptions createDefaultOptions(File dir, boolean readonly) {
        return new DefaultSVNOptions(dir, readonly);
    }

    public static DefaultSVNOptions createDefaultOptions(boolean readonly) {
        return new DefaultSVNOptions(null, readonly);
    }

    public static boolean isVersionedDirectory(File dir) {
        return SvnOperationFactory.isVersionedDirectory(dir);
    }

    public static boolean isWorkingCopyRoot(File versionedDir) throws SVNException {
        return SvnOperationFactory.isWorkingCopyRoot(versionedDir);
    }

    public static boolean isWorkingCopyRoot(File versionedDir, boolean externalIsRoot) throws SVNException {
        if (SVNWCUtil.isWorkingCopyRoot(versionedDir)) {
            if (!externalIsRoot) {
                return true;
            }
            File root = SvnOperationFactory.getWorkingCopyRoot(versionedDir, false);
            return root.equals(versionedDir);
        }
        return false;
    }

    public static File getWorkingCopyRoot(File versionedDir, boolean stopOnExternals) throws SVNException {
        return SvnOperationFactory.getWorkingCopyRoot(versionedDir, stopOnExternals);
    }

    private static boolean isEclipse() {
        if (ourIsEclipse == null) {
            try {
                Class<?> platform;
                Method isRunning;
                Object result;
                ClassLoader loader = SVNWCUtil.class.getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                if ((result = (isRunning = (platform = loader.loadClass("org.eclipse.core.runtime.Platform")).getMethod("isRunning", new Class[0])).invoke(null, new Object[0])) != null && Boolean.TRUE.equals(result)) {
                    ourIsEclipse = Boolean.TRUE;
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ourIsEclipse = Boolean.FALSE;
        }
        return ourIsEclipse;
    }
}

