/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNURL {
    private static final Map DEFAULT_PORTS = new SVNHashMap();
    private String myURL;
    private String myProtocol;
    private String myHost;
    private String myPath;
    private String myUserName;
    private int myPort;
    private String myEncodedPath;
    private boolean myIsDefaultPort;

    public static SVNURL create(String protocol, String userInfo, String host, int port, String path, boolean uriEncoded) throws SVNException {
        if (host == null && !"file".equalsIgnoreCase(protocol) || host != null && host.indexOf(64) >= 0) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Invalid host name ''{0}''", (Object)host), SVNLogType.DEFAULT);
        }
        path = path == null ? "/" : path;
        path = !uriEncoded ? SVNEncodingUtil.uriEncode(path) : SVNEncodingUtil.autoURIEncode(path);
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        protocol = protocol == null ? "http" : protocol.toLowerCase();
        String errorMessage = null;
        if (userInfo != null && userInfo.indexOf(47) >= 0) {
            errorMessage = "Malformed URL: user info part could not include '/' symbol";
        } else if (host == null && !"file".equals(protocol)) {
            errorMessage = "Malformed URL: host could not be NULL";
        } else if (!"file".equals(protocol) && host.indexOf(47) >= 0) {
            errorMessage = "Malformed URL: host could not include '/' symbol";
        }
        if (errorMessage != null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, errorMessage);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        String url = SVNURL.composeURL(protocol, userInfo, host, port, path);
        return new SVNURL(url, true);
    }

    public static SVNURL parseURIDecoded(String url) throws SVNException {
        return new SVNURL(url, false);
    }

    public static SVNURL parseURIEncoded(String url) throws SVNException {
        return new SVNURL(url, true);
    }

    public static SVNURL fromFile(File repositoryPath) throws SVNException {
        if (repositoryPath == null) {
            return null;
        }
        String path = repositoryPath.getAbsoluteFile().getAbsolutePath();
        if (!(path = path.replace(File.separatorChar, '/')).startsWith("/")) {
            path = "/" + path;
        }
        return SVNURL.parseURIDecoded("file://" + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultPortNumber(String protocol) {
        Integer dPort;
        if (protocol == null) {
            return -1;
        }
        if ("file".equals(protocol = protocol.toLowerCase())) {
            return -1;
        }
        Map map = DEFAULT_PORTS;
        synchronized (map) {
            dPort = (Integer)DEFAULT_PORTS.get(protocol);
        }
        if (dPort != null) {
            return dPort;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProtocol(String protocolName, int defaultPort) {
        if (protocolName != null) {
            Map map = DEFAULT_PORTS;
            synchronized (map) {
                if (defaultPort >= 0) {
                    DEFAULT_PORTS.put(protocolName, new Integer(defaultPort));
                } else {
                    DEFAULT_PORTS.remove(protocolName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNURL(String url, boolean uriEncoded) throws SVNException {
        Object err;
        int index;
        if (url == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL cannot be NULL");
            SVNErrorManager.error(err2, SVNLogType.DEFAULT);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((index = url.indexOf("://")) <= 0) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL ''{0}''", (Object)url);
            SVNErrorManager.error((SVNErrorMessage)err, SVNLogType.DEFAULT);
        }
        this.myProtocol = url.substring(0, index);
        this.myProtocol = this.myProtocol.toLowerCase();
        err = DEFAULT_PORTS;
        synchronized (err) {
            if (!DEFAULT_PORTS.containsKey(this.myProtocol) && !this.myProtocol.startsWith("svn+")) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL protocol is not supported ''{0}''", (Object)url);
                SVNErrorManager.error(err3, SVNLogType.DEFAULT);
            }
        }
        if ("file".equals(this.myProtocol)) {
            String normalizedPath = SVNURL.norlmalizeURLPath(url, url.substring("file://".length()));
            int slashInd = normalizedPath.indexOf(47);
            if (slashInd == -1) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Local URL ''{0}'' contains only a hostname, no path", (Object)url);
                SVNErrorManager.error(err4, SVNLogType.DEFAULT);
            }
            this.myPath = normalizedPath.substring(slashInd);
            this.myHost = normalizedPath.equals(this.myPath) ? "" : normalizedPath.substring(0, slashInd);
            URL testURL = null;
            try {
                testURL = new URL(this.myProtocol + "://" + normalizedPath);
            }
            catch (MalformedURLException e) {
                SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL: ''{0}'': {1}", url, e.getLocalizedMessage());
                SVNErrorManager.error(err5, e, SVNLogType.DEFAULT);
                return;
            }
            if (uriEncoded) {
                this.myPath = this.myPath.replace('\\', '/');
                this.myEncodedPath = SVNEncodingUtil.autoURIEncode(this.myPath);
                SVNEncodingUtil.assertURISafe(this.myEncodedPath);
                this.myPath = SVNEncodingUtil.uriDecode(this.myEncodedPath);
                if (!this.myPath.startsWith("/")) {
                    this.myPath = "/" + this.myPath;
                }
            } else {
                this.myEncodedPath = SVNEncodingUtil.uriEncode(this.myPath);
                this.myPath = this.myPath.replace('\\', '/');
                if (!this.myPath.startsWith("/")) {
                    this.myPath = "/" + this.myPath;
                }
            }
            this.myUserName = testURL.getUserInfo();
            this.myPort = testURL.getPort();
        } else {
            URL httpURL;
            String testURL = "http" + url.substring(index);
            try {
                httpURL = new URL(testURL);
            }
            catch (MalformedURLException e) {
                SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL: ''{0}'': {1}", url, e.getLocalizedMessage());
                SVNErrorManager.error(err6, e, SVNLogType.DEFAULT);
                return;
            }
            this.myHost = httpURL.getHost();
            if ("".equals(this.myHost)) {
                SVNErrorMessage err7 = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Malformed URL: ''{0}''", (Object)url);
                SVNErrorManager.error(err7, SVNLogType.DEFAULT);
                return;
            }
            String httpPath = SVNURL.norlmalizeURLPath(url, SVNURL.getPath(httpURL));
            if (uriEncoded) {
                this.myEncodedPath = SVNEncodingUtil.autoURIEncode(httpPath);
                SVNEncodingUtil.assertURISafe(this.myEncodedPath);
                this.myPath = SVNEncodingUtil.uriDecode(this.myEncodedPath);
            } else {
                String originalPath = url.substring(index + "://".length());
                originalPath = originalPath.indexOf("/") < 0 ? "" : originalPath.substring(originalPath.indexOf("/") + 1);
                this.myPath = originalPath;
                if (!this.myPath.startsWith("/")) {
                    this.myPath = "/" + this.myPath;
                }
                this.myEncodedPath = SVNEncodingUtil.uriEncode(this.myPath);
            }
            this.myUserName = httpURL.getUserInfo();
            this.myPort = httpURL.getPort();
            boolean bl = this.myIsDefaultPort = this.myPort < 0;
            if (this.myPort < 0) {
                Integer defaultPort;
                Map map = DEFAULT_PORTS;
                synchronized (map) {
                    defaultPort = (Integer)DEFAULT_PORTS.get(this.myProtocol);
                }
                int n = this.myPort = defaultPort != null ? defaultPort : 0;
            }
        }
        if (this.myEncodedPath.equals("/")) {
            this.myEncodedPath = "";
            this.myPath = "";
        }
        if (this.myHost != null) {
            this.myHost = this.myHost.toLowerCase();
        }
    }

    public String getProtocol() {
        return this.myProtocol;
    }

    public String getHost() {
        return this.myHost;
    }

    public int getPort() {
        return this.myPort;
    }

    public boolean hasPort() {
        return !this.myIsDefaultPort;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getURIEncodedPath() {
        return this.myEncodedPath;
    }

    public String getUserInfo() {
        return this.myUserName;
    }

    public String toString() {
        if (this.myURL == null) {
            this.myURL = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), this.getURIEncodedPath());
        }
        return this.myURL;
    }

    public String toDecodedString() {
        return SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), this.getPath());
    }

    public SVNURL appendPath(String segment, boolean uriEncoded) throws SVNException {
        if (segment == null || "".equals(segment)) {
            return this;
        }
        segment = !uriEncoded ? SVNEncodingUtil.uriEncode(segment) : SVNEncodingUtil.autoURIEncode(segment);
        String path = this.getURIEncodedPath();
        path = "".equals(path) ? "/" + segment : SVNPathUtil.append(path, segment);
        String url = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), path);
        return SVNURL.parseURIEncoded(url);
    }

    public SVNURL setPath(String path, boolean uriEncoded) throws SVNException {
        if (path == null || "".equals(path)) {
            path = "/";
        }
        path = !uriEncoded ? SVNEncodingUtil.uriEncode(path) : SVNEncodingUtil.autoURIEncode(path);
        String url = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), path);
        return SVNURL.parseURIEncoded(url);
    }

    public SVNURL removePathTail() throws SVNException {
        String newPath = SVNPathUtil.removeTail(this.myPath);
        String url = SVNURL.composeURL(this.getProtocol(), this.getUserInfo(), this.getHost(), this.myIsDefaultPort ? -1 : this.getPort(), newPath);
        return SVNURL.parseURIDecoded(url);
    }

    public boolean equals(Object obj) {
        boolean eq;
        if (obj == null || obj.getClass() != SVNURL.class) {
            return false;
        }
        SVNURL url = (SVNURL)obj;
        boolean bl = eq = this.myProtocol.equals(url.myProtocol) && this.myPort == url.myPort && this.myHost.equals(url.myHost) && this.myPath.equals(url.myPath) && this.hasPort() == url.hasPort();
        eq = this.myUserName == null ? (eq &= url.myUserName == null) : (eq &= this.myUserName.equals(url.myUserName));
        return eq;
    }

    public int hashCode() {
        int code = this.myProtocol.hashCode() + this.myHost.hashCode() * 27 + this.myPath.hashCode() * 31 + this.myPort * 17;
        if (this.myUserName != null) {
            code += 37 * this.myUserName.hashCode();
        }
        return code;
    }

    private static String composeURL(String protocol, String userInfo, String host, int port, String path) {
        StringBuffer url = new StringBuffer();
        url.append(protocol);
        url.append("://");
        if (userInfo != null) {
            url.append(userInfo);
            url.append("@");
        }
        if (host != null) {
            url.append(host);
        }
        if (port >= 0) {
            url.append(":");
            url.append(port);
        }
        if (path != null && !path.startsWith("/")) {
            path = '/' + path;
        }
        if ("/".equals(path)) {
            path = "";
        }
        url.append(path);
        return url.toString();
    }

    private static String norlmalizeURLPath(String url, String path) throws SVNException {
        StringBuffer result = new StringBuffer(path.length());
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("".equals(token) || ".".equals(token)) continue;
            if ("..".equals(token)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "URL ''{0}'' contains '..' element", (Object)url);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
                continue;
            }
            result.append("/");
            result.append(token);
        }
        if (!path.startsWith("/") && result.length() > 0) {
            result = result.delete(0, 1);
        }
        return result.toString();
    }

    private static String getPath(URL url) {
        String path = url.getPath();
        String ref = url.getRef();
        if (ref != null) {
            if (path == null) {
                path = "";
            }
            path = path + '#' + ref;
        }
        return path;
    }

    static {
        DEFAULT_PORTS.put("svn", new Integer(3690));
        DEFAULT_PORTS.put("svn+ssh", new Integer(22));
        DEFAULT_PORTS.put("http", new Integer(80));
        DEFAULT_PORTS.put("https", new Integer(443));
        DEFAULT_PORTS.put("file", new Integer(0));
    }
}

