/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestLanguageServers {
    private IProject project;

    @BeforeEach
    public void setUpProject() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            activePage.hideView(ref);
            ++n2;
        }
    }

    @Test
    public void testCSSFile() throws Exception {
        IFile file = this.project.getFile("blah.css");
        file.create("ERROR".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testHTMLFile() throws Exception {
        IFile file = this.project.getFile("blah.html");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<style\n<html><");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testYAMLFile() throws Exception {
        IFile file = this.project.getFile("blah.yaml");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("hello: '");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testJSONFile() throws Exception {
        IFile file = this.project.getFile("blah.json");
        file.create("FAIL".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("ERROR");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testJSFile() throws Exception {
        IFile file = this.project.getFile("blah.js");
        file.create("ERROR".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        DisplayHelper.sleep((long)2000L);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testTSFile() throws Exception {
        IFile file = this.project.getFile("blah.ts");
        file.create("ERROR".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)15000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testJSXFile() throws Exception {
        IFile jsconfig = this.project.getFile("jsconfig.json");
        jsconfig.create("{\"compilerOptions\":{\"jsx\":\"react\"}}".getBytes(), true, false, null);
        IFile file = this.project.getFile("blah.jsx");
        file.create("ERROR".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("a<");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testTSXFile() throws Exception {
        IFile jsconfig = this.project.getFile("jsconfig.json");
        jsconfig.create("{\"compilerOptions\":{\"jsx\":\"react\"}}".getBytes(), true, false, null);
        IFile file = this.project.getFile("blah.tsx");
        file.create("ERROR".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)15000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("const x = <></>;export default x;");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)15000L, () -> {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
                int n = markers.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IMarker m = iMarkerArray[n2];
                    if (((String)m.getAttribute("message")).contains("React")) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not cleared");
    }

    @Test
    public void testResourcesPathIsntTooLong() throws Exception {
        int MAX_ALLOWED_RELATIVE_PATH = 140;
        String location = Platform.getBundle((String)"org.eclipse.wildwebdeveloper").getLocation();
        if (location.startsWith("initial@")) {
            location = location.substring("initial@".length());
        }
        if (location.startsWith("reference:")) {
            location = location.substring("reference:".length());
        }
        if (location.startsWith("file:")) {
            location = location.substring("file:".length());
        }
        System.out.println("Location (" + location.length() + "): " + location);
        final StringBuilder maxLocation = new StringBuilder();
        File file = new File(location).isAbsolute() ? new File(location) : new File(new File(Platform.getInstallLocation().getURL().toURI()), location);
        Assertions.assertTrue((boolean)file.isDirectory());
        final TreeMap tooLongPaths = new TreeMap();
        final Path pluginPath = file.toPath();
        Files.walkFileTree(pluginPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relativePathInsideBundle = pluginPath.relativize(dir).toString();
                if (relativePathInsideBundle.startsWith("target")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (maxLocation.length() < relativePathInsideBundle.length()) {
                    maxLocation.setLength(0);
                    maxLocation.append(relativePathInsideBundle);
                }
                if (relativePathInsideBundle.length() > 140) {
                    tooLongPaths.put(relativePathInsideBundle, relativePathInsideBundle.length());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relativePathInsideBundle = pluginPath.relativize(file).toString();
                if (maxLocation.length() < relativePathInsideBundle.length()) {
                    maxLocation.setLength(0);
                    maxLocation.append(relativePathInsideBundle);
                }
                if (relativePathInsideBundle.length() > 140) {
                    tooLongPaths.put(relativePathInsideBundle, relativePathInsideBundle.length());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        System.out.println("Max Location found (" + maxLocation.length() + "): " + maxLocation.toString());
        Assertions.assertEquals(Collections.emptyMap(), tooLongPaths);
    }

    @Test
    public void testSCSSFile() throws Exception {
        IFile file = this.project.getFile("blah.scss");
        file.create("ERROR".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }

    @Test
    public void testLESSFile() throws Exception {
        IFile file = this.project.getFile("blah.less");
        file.create("ERROR".getBytes(), true, false, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("FAIL");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)PlatformUI.getWorkbench().getDisplay(), (long)5000L, () -> {
            try {
                return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
            }
            catch (CoreException e) {
                return false;
            }
        }), (String)"Diagnostic not published");
    }
}

