/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestVue {
    static IProject project;
    static IFolder componentFolder;

    @BeforeAll
    public static void setUp() throws Exception {
        AllCleanRule.closeIntro();
        AllCleanRule.enableLogging();
        project = Utils.provisionTestProject("vue-app");
        ProcessBuilder builder = NodeJSManager.prepareNPMProcessBuilder((String[])new String[]{"install", "--no-bin-links", "--ignore-scripts"}).directory(project.getLocation().toFile());
        Process process = builder.start();
        System.out.println(builder.command().toString());
        String result = process.errorReader().lines().collect(Collectors.joining("\n"));
        System.out.println("Error Stream: >>>\n" + result + "\n<<<");
        result = process.inputReader().lines().collect(Collectors.joining("\n"));
        System.out.println("Output Stream: >>>\n" + result + "\n<<<");
        Assertions.assertEquals((int)0, (int)process.waitFor(), (String)"npm install didn't complete property");
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)project.exists());
        componentFolder = project.getFolder("src").getFolder("components");
        Assertions.assertTrue((boolean)componentFolder.exists());
    }

    @BeforeEach
    public void setUpTestCase() {
        AllCleanRule.enableLogging();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        new AllCleanRule().afterEach(null);
    }

    @Test
    void testVueApp() throws Exception {
        IFile appComponentFile = project.getFile("src/App.vue");
        TextEditor editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appComponentFile);
        LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)project, (LanguageServersRegistry.LanguageServerDefinition)LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.vue"));
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)editor.getSite().getShell().getDisplay(), (long)30000L, () -> {
            try {
                return Arrays.stream(appComponentFile.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0)).anyMatch(marker -> marker.getAttribute("message", "").contains("never read"));
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
        }), (String)"Diagnostic not published in standalone component file");
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)editor.getSite().getShell().getDisplay(), (long)30000L, () -> lsWrapper.isActive() && lsWrapper.isConnectedTo(LSPEclipseUtils.toUri((IDocument)document)) && lsWrapper.canOperate(project) && lsWrapper.canOperate(document)));
        LSContentAssistProcessor contentAssistProcessor = new LSContentAssistProcessor();
        ICompletionProposal[] proposals = contentAssistProcessor.computeCompletionProposals((ITextViewer)Utils.getViewer((AbstractTextEditor)editor), document.get().indexOf(" }}"));
        Optional<ICompletionProposal> proposal = Arrays.stream(proposals).filter(item -> item.getDisplayString().equals("appParameter")).findFirst();
        Assertions.assertTrue((boolean)proposal.isPresent(), (String)"Proposal not exists");
        proposal.get().apply(document);
        Assertions.assertTrue((boolean)document.get().contains("{{ this.appParameter }}"), (String)"Incorrect completion insertion");
        editor.close(false);
    }

    @Test
    void testVueTemplate() throws Exception {
        TextEditor editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)componentFolder.getFile("HelloWorld.vue"));
        LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)project, (LanguageServersRegistry.LanguageServerDefinition)LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.vue"));
        IFile appComponentHTML = componentFolder.getFile("HelloWorld.vue");
        editor = (TextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)appComponentHTML);
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String tagName = "only-start";
        String tag = "<" + tagName + ">";
        document.set(document.get().replace(tag, tag + "<"));
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)editor.getSite().getShell().getDisplay(), (long)30000L, () -> {
            try {
                IMarker[] markers = appComponentHTML.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
                return Arrays.stream(markers).anyMatch(marker -> marker.getAttribute("message", "").contains("Element is missing end tag."));
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
        }), (String)"No error found on erroneous HTML component file");
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)editor.getSite().getShell().getDisplay(), (long)30000L, () -> lsWrapper.isActive() && lsWrapper.isConnectedTo(LSPEclipseUtils.toUri((IDocument)document)) && lsWrapper.canOperate(project) && lsWrapper.canOperate(document)));
        LSContentAssistProcessor contentAssistProcessor = new LSContentAssistProcessor();
        int pos = document.get().indexOf(tag) + tag.length();
        ICompletionProposal[] proposals = contentAssistProcessor.computeCompletionProposals((ITextViewer)Utils.getViewer((AbstractTextEditor)editor), pos + 1);
        ICompletionProposal closingTagProposal = Arrays.stream(proposals).filter(p -> p.getDisplayString().equals("/" + tagName)).findFirst().orElse(null);
        Assertions.assertNotNull((Object)closingTagProposal, (String)("Closing tag proposal not found for '" + tag + "'"));
        closingTagProposal.apply(document);
        Assertions.assertEquals((Object)new String(componentFolder.getFile("HelloWorldCorrect.vue").getContents().readAllBytes()).trim(), (Object)document.get().trim(), (String)"Incorrect completion insertion");
        editor.close(false);
    }
}

