import { DebugProtocol } from 'vscode-debugprotocol';
import { VariableContext } from './chromeDebugAdapter';
import { Protocol as Crdp } from 'devtools-protocol';
import { VariablesManager } from './variablesManager';
export interface IVariableContainer {
    expand(variablesManager: VariablesManager, filter?: string, start?: number, count?: number): Promise<DebugProtocol.Variable[]>;
    setValue(variablesManager: VariablesManager, name: string, value: string): Promise<string>;
}
export declare abstract class BaseVariableContainer implements IVariableContainer {
    protected objectId: string;
    protected evaluateName: string;
    constructor(objectId: string, evaluateName?: string);
    expand(variablesManager: VariablesManager, filter?: string, start?: number, count?: number): Promise<DebugProtocol.Variable[]>;
    setValue(variablesManager: VariablesManager, name: string, value: string): Promise<string>;
}
export declare class PropertyContainer extends BaseVariableContainer {
    setValue(variablesManager: VariablesManager, name: string, value: string): Promise<string>;
}
export declare class LoggedObjects extends BaseVariableContainer {
    private args;
    constructor(args: Crdp.Runtime.RemoteObject[]);
    expand(variablesManager: VariablesManager, filter?: string, start?: number, count?: number): Promise<DebugProtocol.Variable[]>;
}
export declare class ScopeContainer extends BaseVariableContainer {
    private _thisObj;
    private _returnValue;
    private _frameId;
    private _origScopeIndex;
    constructor(frameId: string, origScopeIndex: number, objectId: string, thisObj?: Crdp.Runtime.RemoteObject, returnValue?: Crdp.Runtime.RemoteObject);
    /**
     * Call super then insert the 'this' object if needed
     */
    expand(variablesManager: VariablesManager, filter?: string, start?: number, count?: number): Promise<DebugProtocol.Variable[]>;
    setValue(variablesManager: VariablesManager, name: string, value: string): Promise<string>;
    private insertRemoteObject(variablesManager, variables, name, obj);
}
export declare class ExceptionContainer extends PropertyContainer {
    protected _exception: Crdp.Runtime.RemoteObject;
    protected constructor(objectId: string, exception: Crdp.Runtime.RemoteObject);
    /**
     * Expand the exception as if it were a Scope
     */
    static create(exception: Crdp.Runtime.RemoteObject): ExceptionContainer;
}
/**
 * For when a value is thrown instead of an object
 */
export declare class ExceptionValueContainer extends ExceptionContainer {
    constructor(exception: Crdp.Runtime.RemoteObject);
    /**
     * Make up a fake 'Exception' property to hold the thrown value, displayed under the Exception Scope
     */
    expand(variablesManager: VariablesManager, filter?: string, start?: number, count?: number): Promise<DebugProtocol.Variable[]>;
}
export declare function isIndexedPropName(name: string): boolean;
export declare function getRemoteObjectPreview(object: Crdp.Runtime.RemoteObject, stringify?: boolean, context?: string): string;
export declare function getRemoteObjectPreview_object(object: Crdp.Runtime.RemoteObject, context?: string): string;
export declare function getRemoteObjectPreview_primitive(object: Crdp.Runtime.RemoteObject, stringify?: boolean): string;
export declare function getRemoteObjectPreview_function(object: Crdp.Runtime.RemoteObject, context?: string): string;
export declare class VariableHandles {
    private _variableHandles;
    private _consoleVariableHandles;
    onPaused(): void;
    create(value: IVariableContainer, context?: VariableContext): number;
    get(handle: number): IVariableContainer;
    private getHandles(context);
}
export interface IPropCount {
    indexedVariables: number;
    namedVariables: number;
}
export declare function getCollectionNumPropsByPreview(object: Crdp.Runtime.RemoteObject): IPropCount;
export declare function getArrayNumPropsByPreview(object: Crdp.Runtime.RemoteObject): IPropCount;
export declare function createPrimitiveVariableWithValue(name: string, value: string, parentEvaluateName?: string): DebugProtocol.Variable;
export declare function createPropertyContainer(object: Crdp.Runtime.RemoteObject, evaluateName: string): IVariableContainer;
export declare function createPrimitiveVariable(name: string, object: Crdp.Runtime.RemoteObject, parentEvaluateName?: string, stringify?: boolean): DebugProtocol.Variable;
export declare function createFunctionVariable(name: string, object: Crdp.Runtime.RemoteObject, context: VariableContext, handles: VariableHandles, parentEvaluateName?: string): DebugProtocol.Variable;
