/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class MoveResourcesOperation
extends AbstractCopyOrMoveResourcesOperation {
    IResource[] originalResources;
    IPath originalDestination;
    IPath[] originalDestinationPaths;

    public MoveResourcesOperation(IResource[] resources, IPath destinationPath, String label) {
        super(resources, destinationPath, label);
        this.originalResources = this.resources;
        this.originalDestination = this.destination;
        this.originalDestinationPaths = this.destinationPaths;
    }

    public MoveResourcesOperation(IResource resource, IPath newPath, String label) {
        super(new IResource[]{resource}, new IPath[]{newPath}, label);
        this.originalResources = this.resources;
        this.originalDestination = this.destination;
        this.originalDestinationPaths = this.destinationPaths;
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.move(monitor, uiInfo);
    }

    protected void move(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.resources.length + (this.resourceDescriptions != null ? this.resourceDescriptions.length : 0)));
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_MovingResources);
        ArrayList<IResource> resourcesAtDestination = new ArrayList<IResource>();
        ArrayList<IPath> undoDestinationPaths = new ArrayList<IPath>();
        ArrayList<ResourceDescription> overwrittenResources = new ArrayList<ResourceDescription>();
        int i = 0;
        while (i < this.resources.length) {
            ResourceDescription[] overwrites = WorkspaceUndoUtil.move(new IResource[]{this.resources[i]}, this.getDestinationPath(this.resources[i], i), resourcesAtDestination, undoDestinationPaths, (IProgressMonitor)subMonitor.split(1), uiInfo, true);
            overwrittenResources.addAll(Arrays.asList(overwrites));
            ++i;
        }
        if (this.resourceDescriptions != null) {
            ResourceDescription[] resourceDescriptionArray = this.resourceDescriptions;
            int n = this.resourceDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceDescription resourceDescription = resourceDescriptionArray[n2];
                if (resourceDescription != null) {
                    resourceDescription.createResource((IProgressMonitor)subMonitor.split(1));
                }
                ++n2;
            }
        }
        this.setResourceDescriptions(overwrittenResources.toArray(new ResourceDescription[overwrittenResources.size()]));
        this.setTargetResources(resourcesAtDestination.toArray(new IResource[resourcesAtDestination.size()]));
        this.destinationPaths = undoDestinationPaths.toArray(new IPath[undoDestinationPaths.size()]);
        this.destination = null;
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.move(monitor, uiInfo);
        this.setTargetResources(this.originalResources);
        this.resourceDescriptions = new ResourceDescription[0];
        this.destination = this.originalDestination;
        this.destinationPaths = this.originalDestinationPaths;
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        int i = 0;
        while (i < this.resources.length) {
            IResource resource = this.resources[i];
            factory.move(resource, this.getDestinationPath(resource, i));
            ++i;
        }
        return true;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (status.isOK()) {
            status = this.computeMoveOrCopyStatus();
        }
        return status;
    }
}

