/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.dstore;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.client.ClientConnection;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IRemoteServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.internal.connectorservice.dstore.ConnectorServiceResources;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemBasePlugin;

public class RexecDstoreServer
implements IServerLauncher {
    private SystemMessage _errorMessage;
    private SystemSignonInformation signonInfo;
    private String cwd = null;
    private String invocation = null;
    private int rexecPort = 512;
    private String cmd = null;
    private static String ASCII_TEST_STRING = "ASCII";
    private static String PORT_LEADING_STRING = "Server Started Successfully";
    private static final String EZYRD11E = "EZYRD11E";
    private ClientConnection clientConnection;
    private IServerLauncherProperties propertyInfo;
    private boolean isModeChecked = false;
    private boolean checkPort = true;
    private boolean logInfo = false;
    private int _socketTimeoutValue = 10000;
    private static char[] ebcdictounicode;

    static {
        char[] cArray = new char[256];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[5] = 9;
        cArray[7] = 127;
        cArray[11] = 11;
        cArray[12] = 12;
        cArray[13] = 13;
        cArray[14] = 14;
        cArray[15] = 15;
        cArray[16] = 16;
        cArray[17] = 17;
        cArray[18] = 18;
        cArray[19] = 19;
        cArray[21] = 10;
        cArray[22] = 8;
        cArray[24] = 24;
        cArray[25] = 25;
        cArray[34] = 28;
        cArray[37] = 10;
        cArray[38] = 23;
        cArray[39] = 27;
        cArray[45] = 5;
        cArray[46] = 6;
        cArray[47] = 7;
        cArray[50] = 22;
        cArray[55] = 4;
        cArray[60] = 20;
        cArray[61] = 21;
        cArray[63] = 26;
        cArray[64] = 32;
        cArray[75] = 46;
        cArray[76] = 60;
        cArray[77] = 40;
        cArray[78] = 43;
        cArray[79] = 124;
        cArray[80] = 38;
        cArray[90] = 33;
        cArray[91] = 36;
        cArray[92] = 42;
        cArray[93] = 41;
        cArray[94] = 59;
        cArray[96] = 45;
        cArray[97] = 47;
        cArray[106] = 124;
        cArray[107] = 44;
        cArray[108] = 37;
        cArray[109] = 95;
        cArray[110] = 62;
        cArray[111] = 63;
        cArray[121] = 96;
        cArray[122] = 58;
        cArray[123] = 35;
        cArray[124] = 64;
        cArray[125] = 39;
        cArray[126] = 61;
        cArray[127] = 34;
        cArray[129] = 97;
        cArray[130] = 98;
        cArray[131] = 99;
        cArray[132] = 100;
        cArray[133] = 101;
        cArray[134] = 102;
        cArray[135] = 103;
        cArray[136] = 104;
        cArray[137] = 105;
        cArray[139] = 123;
        cArray[143] = 43;
        cArray[145] = 106;
        cArray[146] = 107;
        cArray[147] = 108;
        cArray[148] = 109;
        cArray[149] = 110;
        cArray[150] = 111;
        cArray[151] = 112;
        cArray[152] = 113;
        cArray[153] = 114;
        cArray[155] = 125;
        cArray[162] = 115;
        cArray[163] = 116;
        cArray[164] = 117;
        cArray[165] = 118;
        cArray[166] = 119;
        cArray[167] = 120;
        cArray[168] = 121;
        cArray[169] = 122;
        cArray[173] = 91;
        cArray[189] = 93;
        cArray[191] = 45;
        cArray[192] = 125;
        cArray[193] = 65;
        cArray[194] = 66;
        cArray[195] = 67;
        cArray[196] = 68;
        cArray[197] = 69;
        cArray[198] = 70;
        cArray[199] = 71;
        cArray[200] = 72;
        cArray[201] = 73;
        cArray[208] = 125;
        cArray[209] = 74;
        cArray[210] = 75;
        cArray[211] = 76;
        cArray[212] = 77;
        cArray[213] = 78;
        cArray[214] = 79;
        cArray[215] = 80;
        cArray[216] = 81;
        cArray[217] = 82;
        cArray[224] = 92;
        cArray[226] = 83;
        cArray[227] = 84;
        cArray[228] = 85;
        cArray[229] = 86;
        cArray[230] = 87;
        cArray[231] = 88;
        cArray[232] = 89;
        cArray[233] = 90;
        cArray[240] = 48;
        cArray[241] = 49;
        cArray[242] = 50;
        cArray[243] = 51;
        cArray[244] = 52;
        cArray[245] = 53;
        cArray[246] = 54;
        cArray[247] = 55;
        cArray[248] = 56;
        cArray[249] = 57;
        ebcdictounicode = cArray;
    }

    public void setClientConnection(ClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public void setSignonInformation(SystemSignonInformation info) {
        this.signonInfo = info;
    }

    public SystemSignonInformation getSignonInformation() {
        return this.signonInfo;
    }

    public void setServerLauncherProperties(IServerLauncherProperties propertyInfo) {
        char separatorChar;
        this.propertyInfo = propertyInfo;
        this.cwd = ((IRemoteServerLauncher)propertyInfo).getServerPath();
        char c = separatorChar = this.signonInfo.getSystemType().isWindows() ? (char)'\\' : '/';
        if (this.cwd.length() > 0 && this.cwd.charAt(this.cwd.length() - 1) != separatorChar) {
            this.cwd = String.valueOf(this.cwd) + separatorChar;
        }
        this.invocation = ((IRemoteServerLauncher)propertyInfo).getServerScript();
        this.rexecPort = ((IRemoteServerLauncher)propertyInfo).getRexecPort();
    }

    public IServerLauncherProperties getServerLauncherProperties() {
        return this.propertyInfo;
    }

    public boolean isLaunched() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object launch(IProgressMonitor monitor) throws Exception {
        int index;
        boolean isEBCDICTest = false;
        this.isModeChecked = false;
        this.checkPort = true;
        this._errorMessage = null;
        String port = new String("0");
        String originalHostResponse = "";
        String convertedHostResponse = "";
        String debugOptions = System.getProperty("REXEC_DEBUG");
        if (debugOptions != null) {
            if (debugOptions.toUpperCase().indexOf("LOG") > -1) {
                this.logInfo = true;
            }
            if (debugOptions.toUpperCase().indexOf("EBCDIC") > -1) {
                isEBCDICTest = true;
            }
        }
        boolean isEBCDIC = false;
        try {
            Socket rexecCall = new Socket(this.signonInfo.getHostname(), this.rexecPort);
            rexecCall.setSoTimeout(this._socketTimeoutValue);
            DataOutputStream rxOut = new DataOutputStream(rexecCall.getOutputStream());
            DataInputStream rxIn = new DataInputStream(rexecCall.getInputStream());
            rxOut.writeByte(0);
            rxOut.flush();
            rxOut.writeBytes(this.signonInfo.getUserId());
            rxOut.writeByte(0);
            rxOut.writeBytes(this.signonInfo.getPassword());
            rxOut.writeByte(0);
            rxOut.flush();
            this.cmd = new String("echo " + ASCII_TEST_STRING + ";cd " + this.cwd + ";" + this.invocation);
            this.logMessage("The command is " + this.cmd);
            SystemBasePlugin.logInfo((String)"RexecDstoreServer :");
            rxOut.writeBytes(this.cmd);
            rxOut.writeByte(0);
            rxOut.flush();
            int inBytes = rxIn.available();
            int timeout = this._socketTimeoutValue / 100;
            while (true) {
                if (inBytes != 0 || timeout <= 0) {
                    if (timeout != 0) break;
                    String msgTxt = NLS.bind((String)ConnectorServiceResources.MSG_COMM_INVALID_LOGIN, (Object)this.signonInfo.getHostname());
                    String msgDetails = NLS.bind((String)ConnectorServiceResources.MSG_COMM_INVALID_LOGIN_DETAILS, (Object)"");
                    SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.dstore", "RSEC2302", 4, msgTxt, msgDetails);
                    this._errorMessage = msg;
                    return port;
                }
                if (monitor.isCanceled()) {
                    return "0";
                }
                Thread.sleep(100L);
                inBytes = rxIn.available();
                --timeout;
            }
            String maybePort = null;
            while (true) {
                if (monitor.isCanceled()) {
                    return "0";
                }
                byte aByte = rxIn.readByte();
                if (isEBCDICTest) {
                    aByte = this.convertFromASCIIToEBCDIC(aByte);
                }
                if (aByte == 0) continue;
                originalHostResponse = String.valueOf(originalHostResponse) + (char)aByte;
                this.logMessage("Host response is " + originalHostResponse);
                if (!this.isModeChecked) {
                    convertedHostResponse = String.valueOf(convertedHostResponse) + this.convertFromEBCDICToASCII(aByte);
                    this.logMessage("Host response is converted to " + convertedHostResponse);
                    if (originalHostResponse.indexOf(ASCII_TEST_STRING) > -1) {
                        this.isModeChecked = true;
                        this.logMessage("This is the ASCII mode. ");
                        continue;
                    }
                    if (convertedHostResponse.indexOf(ASCII_TEST_STRING) <= -1) continue;
                    this.logMessage("This is the EBCDIC mode. ");
                    this.isModeChecked = true;
                    isEBCDIC = true;
                    continue;
                }
                if (isEBCDIC) {
                    convertedHostResponse = String.valueOf(convertedHostResponse) + this.convertFromEBCDICToASCII(aByte);
                    this.logMessage("Host response is converted to " + convertedHostResponse);
                    if (this.checkPort) {
                        maybePort = this.extractPortNumber(convertedHostResponse);
                    }
                } else if (this.checkPort) {
                    maybePort = this.extractPortNumber(originalHostResponse);
                }
                if (maybePort != null) break;
            }
            port = maybePort;
            rxIn.close();
            rxOut.close();
            rexecCall.close();
            this.logMessage("Going to return port " + port);
            return port;
        }
        catch (EOFException rexecCall) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String hostMessage = originalHostResponse;
        if (isEBCDIC) {
            hostMessage = convertedHostResponse;
        }
        if ((index = hostMessage.indexOf(ASCII_TEST_STRING)) > -1) {
            hostMessage = String.valueOf(hostMessage.substring(0, index)) + hostMessage.substring(index + 1 + ASCII_TEST_STRING.length());
        }
        if (hostMessage.indexOf(EZYRD11E) > 0) {
            String msgTxt = NLS.bind((String)ConnectorServiceResources.MSG_COMM_INVALID_LOGIN, (Object)this.signonInfo.getHostname());
            String msgDetails = NLS.bind((String)ConnectorServiceResources.MSG_COMM_INVALID_LOGIN_DETAILS, (Object)hostMessage);
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.dstore", "RSEC2302", 4, msgTxt, msgDetails);
            this._errorMessage = msg;
            return port;
        }
        String msgTxt = NLS.bind((String)ConnectorServiceResources.MSG_COMM_REXEC_NOTSTARTED, (Object)("" + this.rexecPort), (Object)this.signonInfo.getHostname());
        String msgDetails = NLS.bind((String)ConnectorServiceResources.MSG_COMM_REXEC_NOTSTARTED_DETAILS, (Object)hostMessage);
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.dstore", "RSEC2305", 4, msgTxt, msgDetails);
        this._errorMessage = msg;
        return port;
    }

    public boolean isConnected() {
        if (this.clientConnection != null) {
            return this.clientConnection.isConnected();
        }
        return false;
    }

    public Object connect(int connectPort, IProgressMonitor monitor) throws Exception {
        this.clientConnection.setPort(Integer.toString(connectPort));
        if (monitor != null) {
            String cmsg = NLS.bind((String)ConnectorServiceResources.MSG_CONNECTING_TO_SERVER, (Object)this.clientConnection.getPort());
            monitor.subTask(cmsg);
        }
        ConnectionStatus connectStatus = this.clientConnection.connect(null);
        return connectStatus;
    }

    public void disconnect() throws Exception {
        if (this.clientConnection != null) {
            this.clientConnection.disconnect();
            this.clientConnection = null;
        }
    }

    public SystemMessage getErrorMessage() {
        return this._errorMessage;
    }

    private String extractPortNumber(String hostResponse) {
        String port = "0";
        this.logMessage("Going to find port number. ");
        int index = hostResponse.indexOf(PORT_LEADING_STRING);
        if (index < 0) {
            return null;
        }
        this.logMessage("Found the leading string. ");
        String portString = hostResponse.substring(index + PORT_LEADING_STRING.length());
        this.logMessage("Removed the leading string as " + portString);
        if (portString != null && portString.startsWith("\n")) {
            portString = portString.substring(1);
        }
        if (portString == null) {
            return null;
        }
        StringBuffer portBuffer = new StringBuffer();
        int i = 0;
        while (i < portString.length()) {
            char c = portString.charAt(i);
            if (Character.isDigit(c)) {
                portBuffer.append(c);
            }
            ++i;
        }
        if (portString.length() != portBuffer.length()) {
            port = portBuffer.toString();
            this.logMessage("Got the port " + port);
            try {
                Integer.parseInt(port);
                this.logMessage("Going to return port " + port);
                return port;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                this.logMessage("Got the wrong port " + port);
                this.checkPort = false;
                return null;
            }
        }
        return null;
    }

    private char convertFromEBCDICToASCII(byte eByte) {
        int index = eByte;
        if (index < 0) {
            index += 256;
        }
        return ebcdictounicode[index];
    }

    private byte convertFromASCIIToEBCDIC(byte eByte) {
        byte index = eByte;
        int i = 0;
        while (i < ebcdictounicode.length) {
            if (index == ebcdictounicode[i]) {
                if (i > 128) {
                    return (byte)(i - 256);
                }
                return (byte)i;
            }
            ++i;
        }
        return 0;
    }

    private void logMessage(String message) {
        if (this.logInfo) {
            SystemBasePlugin.logError((String)("RexecDstoreServer :" + message));
        }
    }

    public void setSocketTimeoutValue(int value) {
        this._socketTimeoutValue = value;
    }
}

