/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.references.LSSearchQuery;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSFindReferences
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof ITextEditor var3_4) {
            IDocument document = LSPEclipseUtils.getDocument((ITextEditor)editor);
            if (document == null) {
                return null;
            }
            ISelection sel = editor.getSelectionProvider().getSelection();
            if (sel instanceof ITextSelection var7_8) {
                int offset = ((ITextSelection)sel).getOffset();
                LanguageServiceAccessor.getLanguageServers(document, capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getReferencesProvider())).thenAcceptAsync(languageServers -> {
                    if (languageServers.isEmpty()) {
                        return;
                    }
                    try {
                        LSSearchQuery query = new LSSearchQuery(document, offset, (List<LanguageServer>)languageServers);
                        HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay().asyncExec(() -> NewSearchUI.runQueryInBackground((ISearchQuery)query));
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e);
                    }
                });
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = UI.getActivePage();
        if (page == null) {
            return false;
        }
        IEditorPart part = page.getActiveEditor();
        if (part instanceof ITextEditor var3_4) {
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (selection.isEmpty() || !(selection instanceof ITextSelection)) {
                return false;
            }
            try {
                return !LanguageServiceAccessor.getLanguageServers(LSPEclipseUtils.getDocument((ITextEditor)editor), capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getReferencesProvider())).get(50L, TimeUnit.MILLISECONDS).isEmpty();
            }
            catch (java.util.concurrent.ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not get language server due to timeout after 50 miliseconds", e);
            }
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }
}

