/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.InfoForm;

public class StatusTextEditor
extends AbstractTextEditor {
    private Composite fParent;
    private StackLayout fStackLayout;
    private Composite fDefaultComposite;
    private Control fStatusControl;
    private boolean setFocusIsRunning;
    private static final boolean DEBUG = false;

    @Override
    public void createPartControl(Composite parent) {
        this.fParent = new Composite(parent, 0);
        this.fStackLayout = new StackLayout();
        this.fParent.setLayout((Layout)this.fStackLayout);
        this.fDefaultComposite = new Composite(this.fParent, 0);
        this.fDefaultComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(this.fDefaultComposite);
        this.updatePartControl(this.getEditorInput());
    }

    public void updatePartControl(IEditorInput input) {
        if (this.setFocusIsRunning) {
            StatusTextEditor.trace("updatePartControl", "ERROR: trying to call update while processing focus", this.fStatusControl);
        } else {
            StatusTextEditor.trace("updatePartControl", "START", this.fStatusControl);
        }
        boolean restoreFocus = false;
        if (this.fStatusControl != null) {
            if (!this.fStatusControl.isDisposed()) {
                restoreFocus = this.containsFocus(this.fStatusControl);
            }
            this.fStatusControl.dispose();
            StatusTextEditor.trace("updatePartControl", "status control disposed", this.fStatusControl);
            this.fStatusControl = null;
        }
        Composite front = null;
        if (this.fParent != null && input != null && this.getDocumentProvider() instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)this.getDocumentProvider());
            IStatus status = extension.getStatus(input);
            if (!this.isErrorStatus(status)) {
                front = this.fDefaultComposite;
            } else {
                this.fStatusControl = this.createStatusControl(this.fParent, status);
                StatusTextEditor.trace("updatePartControl", "status control created", this.fStatusControl);
                front = this.fStatusControl;
            }
        }
        if (this.fStackLayout.topControl != front) {
            this.fStackLayout.topControl = front;
            if (front != null) {
                front.requestLayout();
            }
            this.updateStatusFields();
        }
        if (restoreFocus && this.fStatusControl != null && !this.containsFocus(this.fStatusControl)) {
            this.fParent.setFocus();
        }
        StatusTextEditor.trace("updatePartControl", "END", this.fStatusControl);
    }

    private boolean containsFocus(Control control) {
        Control focusControl = control.getDisplay().getFocusControl();
        if (focusControl != null) {
            focusControl = focusControl.getParent();
            while (focusControl != this.fParent && focusControl != null && !(focusControl instanceof Shell)) {
                focusControl = focusControl.getParent();
            }
        }
        return focusControl == this.fParent;
    }

    @Override
    public void setFocus() {
        if (this.setFocusIsRunning) {
            StatusTextEditor.trace("setFocus", "ERROR: trying to call setFocus while processing focus", this.fStatusControl);
        } else {
            StatusTextEditor.trace("setFocus", "START", this.fStatusControl);
        }
        this.setFocusIsRunning = true;
        if (this.fStatusControl != null && !this.fStatusControl.isDisposed()) {
            this.fStatusControl.setFocus();
        } else {
            super.setFocus();
        }
        this.setFocusIsRunning = false;
        StatusTextEditor.trace("setFocus", "END", this.fStatusControl);
    }

    @Override
    public boolean validateEditorInputState() {
        if (!super.validateEditorInputState()) {
            return false;
        }
        if (this.getDocumentProvider() instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)((Object)this.getDocumentProvider());
            IStatus status = extension.getStatus(this.getEditorInput());
            return !this.isErrorStatus(status) && status.getSeverity() != 8;
        }
        return true;
    }

    protected boolean isErrorStatus(IStatus status) {
        return status != null && status.getSeverity() == 4;
    }

    protected Control createStatusControl(Composite parent, IStatus status) {
        return this.createInfoForm(parent, status);
    }

    @Deprecated
    private Control createInfoForm(Composite parent, IStatus status) {
        InfoForm infoForm = new InfoForm(parent);
        infoForm.setHeaderText(this.getStatusHeader(status));
        infoForm.setBannerText(this.getStatusBanner(status));
        infoForm.setInfo(this.getStatusMessage(status));
        return infoForm.getControl();
    }

    protected String getStatusHeader(IStatus status) {
        return "";
    }

    protected String getStatusBanner(IStatus status) {
        return "";
    }

    protected String getStatusMessage(IStatus status) {
        return status.getMessage();
    }

    @Override
    protected void updateStatusField(String category) {
        IStatusField field;
        IDocumentProviderExtension extension;
        IStatus status;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension && this.isErrorStatus(status = (extension = (IDocumentProviderExtension)((Object)provider)).getStatus(this.getEditorInput())) && (field = this.getStatusField(category)) != null) {
            field.setText(this.fErrorLabel);
            return;
        }
        super.updateStatusField(category);
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.updatePartControl();
    }

    @Override
    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.updatePartControl();
    }

    @Override
    protected void sanityCheckState(IEditorInput input) {
        super.sanityCheckState(input);
        if (!this.setFocusIsRunning) {
            this.updatePartControl();
        } else {
            StatusTextEditor.trace("sanityCheck", "delaying update", this.fStatusControl);
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                StatusTextEditor.trace("sanityCheck", "incoming update", this.fStatusControl);
                this.updatePartControl();
            });
        }
    }

    @Override
    protected void handleEditorInputChanged() {
        super.handleEditorInputChanged();
        this.updatePartControl();
    }

    @Override
    protected void handleElementContentReplaced() {
        super.handleElementContentReplaced();
        this.updatePartControl();
    }

    private void updatePartControl() {
        if (this.fParent != null && !this.fParent.isDisposed()) {
            this.updatePartControl(this.getEditorInput());
        }
    }

    private static void trace(String where, String what, Control o) {
    }
}

