/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class CloseResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.CloseResourceAction";
    private final String defaultText;
    private final String defaultToolTip;
    private final String pluralText;
    private final String pluralTooltip;
    private String[] modelProviderIds;

    @Deprecated
    public CloseResourceAction(Shell shell) {
        this(() -> shell);
    }

    @Deprecated
    protected CloseResourceAction(Shell shell, String text) {
        this(() -> shell, text);
    }

    public CloseResourceAction(IShellProvider provider) {
        this(provider, IDEWorkbenchMessages.CloseResourceAction_text);
        this.initAction();
    }

    protected CloseResourceAction(IShellProvider provider, String text) {
        this(provider, text, IDEWorkbenchMessages.CloseResourceAction_toolTip, IDEWorkbenchMessages.CloseResourceAction_text_plural, IDEWorkbenchMessages.CloseResourceAction_toolTip_plural);
    }

    protected CloseResourceAction(IShellProvider provider, String text, String tooltip, String textPlural, String tooltipPlural) {
        super(provider, text);
        this.defaultText = text;
        this.defaultToolTip = tooltip;
        this.pluralText = textPlural;
        this.pluralTooltip = tooltipPlural;
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_resource_action_context");
    }

    @Override
    protected String getOperationMessage() {
        if (this.getActionResources().size() > 1) {
            return IDEWorkbenchMessages.CloseResourceAction_operationMessage_plural;
        }
        return IDEWorkbenchMessages.CloseResourceAction_operationMessage;
    }

    @Override
    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_problemMessage;
    }

    @Override
    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CloseResourceAction_title;
    }

    @Override
    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).close(monitor);
    }

    @Override
    public void run() {
        List<? extends IResource> projects = this.getSelectedResources();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        IResource[] projectArray = projects.toArray(new IResource[projects.size()]);
        if (!IDE.saveAllEditors(projectArray, true)) {
            return;
        }
        if (!this.validateClose()) {
            return;
        }
        try {
            this.getShell().setLayoutDeferred(true);
            CloseResourceAction.closeMatchingEditors(projects, false);
        }
        finally {
            this.getShell().setLayoutDeferred(false);
        }
        ISchedulingRule rule = null;
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        IResource[] iResourceArray = projectArray;
        int n = projectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            IProject project = (IProject)element;
            rule = MultiRule.combine(rule, (ISchedulingRule)factory.modifyRule((IResource)project));
            ++n2;
        }
        this.runInBackground(rule);
    }

    @Override
    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    @Override
    protected boolean updateSelection(IStructuredSelection s) {
        this.setText(this.defaultText);
        this.setToolTipText(this.defaultToolTip);
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        boolean hasOpenProjects = false;
        for (IProject iProject : this.getSelectedResources()) {
            if (!iProject.isOpen()) continue;
            if (hasOpenProjects) {
                this.setText(this.pluralText);
                this.setToolTipText(this.pluralTooltip);
                break;
            }
            hasOpenProjects = true;
        }
        return hasOpenProjects;
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List<? extends IResource> sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas;
            IResourceDelta[] iResourceDeltaArray = projDeltas = delta.getAffectedChildren(4);
            int n = projDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projDelta = iResourceDeltaArray[n2];
                if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n2;
            }
        }
    }

    @Override
    protected synchronized List<? extends IResource> getSelectedResources() {
        return super.getSelectedResources();
    }

    @Override
    protected synchronized List<?> getSelectedNonResources() {
        return super.getSelectedNonResources();
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateClose() {
        void var3_7;
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        List<? extends IResource> resources = this.getActionResources();
        for (IResource iResource : resources) {
            if (!(iResource instanceof IProject)) continue;
            IProject project = (IProject)iResource;
            factory.close(project);
        }
        if (resources.size() == 1) {
            String string = NLS.bind((String)IDEWorkbenchMessages.CloseResourceAction_warningForOne, (Object)resources.get(0).getName());
        } else {
            String string = IDEWorkbenchMessages.CloseResourceAction_warningForMultiple;
        }
        return IDE.promptToConfirm(this.getShell(), IDEWorkbenchMessages.CloseResourceAction_confirm, (String)var3_7, factory.getDelta(), this.getModelProviderIds(), false);
    }

    static void closeMatchingEditors(final List<? extends IResource> resourceRoots, final boolean deletedOnly) {
        if (resourceRoots.isEmpty()) {
            return;
        }
        Runnable runnable = () -> SafeRunner.run((ISafeRunnable)new SafeRunnable(IDEWorkbenchMessages.ErrorOnCloseEditors){

            public void run() {
                IWorkbenchWindow w = CloseResourceAction.getActiveWindow();
                if (w != null) {
                    List<IEditorReference> toClose = CloseResourceAction.getMatchingEditors(resourceRoots, w, deletedOnly);
                    if (toClose.isEmpty()) {
                        return;
                    }
                    CloseResourceAction.closeEditors(toClose, w);
                }
            }
        });
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)runnable);
    }

    private static IWorkbenchWindow getActiveWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            w = windows[0];
        }
        return w;
    }

    private static List<IEditorReference> getMatchingEditors(List<? extends IResource> resourceRoots, IWorkbenchWindow w, boolean deletedOnly) {
        IEditorReference[] editors;
        ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editors = CloseResourceAction.getEditors(w);
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IResource resource = CloseResourceAction.getAdapter(ref);
            if (!(resource == null || !CloseResourceAction.belongsTo(resourceRoots, resource) || deletedOnly && resource.exists())) {
                toClose.add(ref);
            }
            ++n2;
        }
        return toClose;
    }

    private static IEditorReference[] getEditors(IWorkbenchWindow w) {
        IWorkbenchPage page;
        if (w != null && (page = w.getActivePage()) != null) {
            return page.getEditorReferences();
        }
        return new IEditorReference[0];
    }

    private static IResource getAdapter(IEditorReference ref) {
        IEditorInput input;
        try {
            input = ref.getEditorInput();
        }
        catch (PartInitException partInitException) {
            return null;
        }
        IFile adapter = (IFile)Adapters.adapt((Object)input, IFile.class);
        if (adapter != null) {
            return adapter;
        }
        return (IResource)Adapters.adapt((Object)input, IResource.class);
    }

    private static boolean belongsTo(List<? extends IResource> roots, IResource leaf) {
        for (IResource iResource : roots) {
            if (!iResource.contains((ISchedulingRule)leaf)) continue;
            return true;
        }
        return false;
    }

    private static void closeEditors(List<IEditorReference> toClose, IWorkbenchWindow w) {
        IWorkbenchPage page = w.getActivePage();
        if (page == null) {
            return;
        }
        page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), false);
    }
}

