/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api.provider;

import java.io.OutputStream;
import java.util.Optional;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public abstract class TerminalConnectorImpl {
    protected ITerminalControl fControl;

    public void initialize() throws Exception {
    }

    public void connect(ITerminalControl control) {
        Logger.log("entered.");
        this.fControl = control;
    }

    public final void disconnect() {
        Logger.log("entered.");
        this.doDisconnect();
        this.fControl.setState(TerminalState.CLOSED);
    }

    protected void doDisconnect() {
    }

    public abstract OutputStream getTerminalToRemoteStream();

    public abstract String getSettingsSummary();

    public boolean isLocalEcho() {
        return false;
    }

    public void setDefaultSettings() {
    }

    public void load(ISettingsStore store) {
    }

    public void save(ISettingsStore store) {
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }

    public Optional<String> getWorkingDirectory() {
        return Optional.empty();
    }
}

