/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.ColorMap;
import org.eclipse.tm4e.core.internal.theme.IRawTheme;
import org.eclipse.tm4e.core.internal.theme.IRawThemeSetting;
import org.eclipse.tm4e.core.internal.theme.IThemeSetting;
import org.eclipse.tm4e.core.internal.theme.ParsedThemeRule;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElement;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;
import org.eclipse.tm4e.core.internal.utils.CompareUtils;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;

public class Theme {
    private static final Splitter BY_COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter BY_SPACE_SPLITTER = Splitter.on((char)' ');
    private static final Pattern RRGGBB = Pattern.compile("^#[0-9a-f]{6}", 2);
    private static final Pattern RRGGBBAA = Pattern.compile("^#[0-9a-f]{8}", 2);
    private static final Pattern RGB = Pattern.compile("^#[0-9a-f]{3}", 2);
    private static final Pattern RGBA = Pattern.compile("^#[0-9a-f]{4}", 2);
    private final ColorMap colorMap;
    private final ThemeTrieElement root;
    private final ThemeTrieElementRule defaults;
    private final Map<String, List<ThemeTrieElementRule>> cache = new HashMap<String, List<ThemeTrieElementRule>>();

    public static Theme createFromRawTheme(@Nullable IRawTheme source, @Nullable List<String> colorMap) {
        return Theme.createFromParsedTheme(Theme.parseTheme(source), colorMap);
    }

    public static Theme createFromParsedTheme(List<ParsedThemeRule> source, @Nullable List<String> colorMap) {
        return Theme.resolveParsedThemeRules(source, colorMap);
    }

    public Theme(ColorMap colorMap, ThemeTrieElementRule defaults, ThemeTrieElement root) {
        this.colorMap = colorMap;
        this.root = root;
        this.defaults = defaults;
    }

    public Set<String> getColorMap() {
        return this.colorMap.getColorMap();
    }

    public ThemeTrieElementRule getDefaults() {
        return this.defaults;
    }

    public List<ThemeTrieElementRule> match(String scopeName) {
        if (!this.cache.containsKey(scopeName)) {
            this.cache.put(scopeName, this.root.match(scopeName));
        }
        return this.cache.get(scopeName);
    }

    public static List<ParsedThemeRule> parseTheme(@Nullable IRawTheme source) {
        if (source == null) {
            return Collections.emptyList();
        }
        Collection<IRawThemeSetting> settings = source.getSettings();
        if (settings == null) {
            return Collections.emptyList();
        }
        ArrayList<ParsedThemeRule> result = new ArrayList<ParsedThemeRule>();
        int i = -1;
        for (IRawThemeSetting entry : settings) {
            int fontStyle;
            List scopes;
            IThemeSetting entrySetting;
            block26: {
                entrySetting = entry.getSetting();
                if (entrySetting == null) continue;
                ++i;
                Object settingScope = entry.getScope();
                if (settingScope instanceof String) {
                    String scope = (String)settingScope;
                    scope = scope.replaceAll("^[,]+", "");
                    scope = scope.replaceAll("[,]+$", "");
                    scopes = BY_COMMA_SPLITTER.splitToList((CharSequence)scope);
                } else {
                    List settingScopes;
                    scopes = settingScope instanceof List ? (settingScopes = (List)settingScope) : Arrays.asList("");
                }
                fontStyle = -1;
                Object settingsFontStyle = entrySetting.getFontStyle();
                if (!(settingsFontStyle instanceof String)) break block26;
                fontStyle = 0;
                Iterable segments = BY_SPACE_SPLITTER.split((CharSequence)((String)settingsFontStyle));
                Iterator iterator = segments.iterator();
                while (iterator.hasNext()) {
                    String segment;
                    switch (segment = (String)iterator.next()) {
                        case "italic": {
                            fontStyle |= 1;
                            break;
                        }
                        case "bold": {
                            fontStyle |= 2;
                            break;
                        }
                        case "underline": {
                            fontStyle |= 4;
                            break;
                        }
                        case "strikethrough": {
                            fontStyle |= 8;
                        }
                    }
                }
            }
            String foreground = null;
            String settingsForeground = entrySetting.getForeground();
            if (settingsForeground instanceof String && Theme.isValidHexColor(settingsForeground)) {
                foreground = settingsForeground;
            }
            String background = null;
            String settingsBackground = entrySetting.getBackground();
            if (settingsBackground instanceof String && Theme.isValidHexColor(settingsBackground)) {
                background = settingsBackground;
            }
            int j = 0;
            int lenJ = scopes.size();
            while (j < lenJ) {
                String _scope = ((String)scopes.get(j)).trim();
                List segments = BY_SPACE_SPLITTER.splitToList((CharSequence)_scope);
                String scope = (String)MoreCollections.getLastElement(segments);
                List parentScopes = null;
                if (segments.size() > 1) {
                    parentScopes = segments.subList(0, segments.size() - 1);
                    parentScopes = Lists.reverse(parentScopes);
                }
                result.add(new ParsedThemeRule(scope, parentScopes, i, fontStyle, foreground, background));
                ++j;
            }
        }
        return result;
    }

    public static Theme resolveParsedThemeRules(List<ParsedThemeRule> _parsedThemeRules, @Nullable List<String> _colorMap) {
        ArrayList<ParsedThemeRule> parsedThemeRules = new ArrayList<ParsedThemeRule>(_parsedThemeRules);
        parsedThemeRules.sort((a, b) -> {
            int r = CompareUtils.strcmp(a.scope, b.scope);
            if (r != 0) {
                return r;
            }
            r = CompareUtils.strArrCmp(a.parentScopes, b.parentScopes);
            if (r != 0) {
                return r;
            }
            return a.index - b.index;
        });
        int defaultFontStyle = 0;
        String defaultForeground = "#000000";
        String defaultBackground = "#ffffff";
        while (!parsedThemeRules.isEmpty() && parsedThemeRules.get((int)0).scope.isEmpty()) {
            ParsedThemeRule incomingDefaults = parsedThemeRules.remove(0);
            if (incomingDefaults.fontStyle != -1) {
                defaultFontStyle = incomingDefaults.fontStyle;
            }
            if (incomingDefaults.foreground != null) {
                defaultForeground = incomingDefaults.foreground;
            }
            if (incomingDefaults.background == null) continue;
            defaultBackground = incomingDefaults.background;
        }
        ColorMap colorMap = new ColorMap(_colorMap);
        ThemeTrieElementRule defaults = new ThemeTrieElementRule(0, null, defaultFontStyle, colorMap.getId(defaultForeground), colorMap.getId(defaultBackground));
        ThemeTrieElement root = new ThemeTrieElement(new ThemeTrieElementRule(0, null, -1, 0, 0), Collections.emptyList());
        for (ParsedThemeRule rule : parsedThemeRules) {
            root.insert(0, rule.scope, rule.parentScopes, rule.fontStyle, colorMap.getId(rule.foreground), colorMap.getId(rule.background));
        }
        return new Theme(colorMap, defaults, root);
    }

    private static boolean isValidHexColor(String hex) {
        if (hex.isEmpty()) {
            return false;
        }
        if (RRGGBB.matcher(hex).matches()) {
            return true;
        }
        if (RRGGBBAA.matcher(hex).matches()) {
            return true;
        }
        if (RGB.matcher(hex).matches()) {
            return true;
        }
        return RGBA.matcher(hex).matches();
    }

    public @Nullable String getColor(int id) {
        return this.colorMap.getColor(id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cache.hashCode();
        result = 31 * result + this.colorMap.hashCode();
        result = 31 * result + this.defaults.hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Theme other = (Theme)obj;
        return Objects.equals(this.cache, other.cache) && Objects.equals(this.colorMap, other.colorMap) && Objects.equals(this.defaults, other.defaults) && Objects.equals(this.root, other.root);
    }
}

