/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SystemSearchUtil {
    private static SystemSearchUtil instance;
    public static String FILE_NAMES_SEP_STRING;

    static {
        FILE_NAMES_SEP_STRING = ",";
    }

    private SystemSearchUtil() {
    }

    public static SystemSearchUtil getInstance() {
        if (instance == null) {
            instance = new SystemSearchUtil();
        }
        return instance;
    }

    public boolean isValidRegex(String regexString) {
        try {
            Pattern.compile(regexString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Set typesStringToSet(String fileNamesString) {
        if (fileNamesString == null) {
            throw new NullPointerException();
        }
        if (fileNamesString.equals("")) {
            return new HashSet();
        }
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(fileNamesString, FILE_NAMES_SEP_STRING);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            result.add(currentExtension);
        }
        return result;
    }

    public List typesStringToList(String fileNamesString) {
        if (fileNamesString == null) {
            throw new NullPointerException();
        }
        if (fileNamesString.equals("")) {
            return new ArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(fileNamesString, FILE_NAMES_SEP_STRING);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            result.add(currentExtension);
        }
        return result;
    }

    public String typesListToString(List types) {
        Iterator iter = types.iterator();
        return this.typesIterToString(iter);
    }

    public String typesSetToString(Set types) {
        Iterator iter = types.iterator();
        return this.typesIterToString(iter);
    }

    public String typesIterToString(Iterator iter) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                result.append(FILE_NAMES_SEP_STRING);
                result.append(" ");
            } else {
                first = false;
            }
            result.append(iter.next());
        }
        return result.toString();
    }
}

