/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.SWTFactory;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.BreakpointHelper;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.AbstractJavaScriptBreakpointEditor;
import org.eclipse.wst.jsdt.debug.internal.ui.display.JavaScriptDebugViewerConfiguration;
import org.eclipse.wst.jsdt.debug.internal.ui.source.JavaScriptSourceViewer;
import org.eclipse.wst.jsdt.debug.internal.ui.source.contentassist.JavaScriptContentAssistProcessor;
import org.eclipse.wst.jsdt.debug.internal.ui.source.contentassist.ScriptContext;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class JavaScriptBreakpointConditionEditor
extends AbstractJavaScriptBreakpointEditor {
    private Button fConditional;
    private Button fWhenTrue;
    private Button fWhenChange;
    private JavaScriptSourceViewer fViewer;
    private IContentAssistProcessor fCompletionProcessor;
    private IJavaScriptLineBreakpoint fBreakpoint;
    private IHandlerService fHandlerService;
    private IHandler fHandler;
    private IHandlerActivation fActivation;
    private IDocumentListener fDocumentListener;
    public static final int PROP_CONDITION = 4097;
    public static final int PROP_CONDITION_ENABLED = 4098;
    public static final int PROP_CONDITION_SUSPEND_POLICY = 4099;
    static /* synthetic */ Class class$0;

    public void setInput(Object input) throws CoreException {
        if (input instanceof IJavaScriptLineBreakpoint) {
            this.setBreakpoint((IJavaScriptLineBreakpoint)input);
        } else {
            this.setBreakpoint(null);
        }
    }

    private void setBreakpoint(IJavaScriptLineBreakpoint breakpoint) throws CoreException {
        String source;
        this.fBreakpoint = breakpoint;
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
        this.fViewer.unconfigure();
        Document document = new Document();
        JavaScriptPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fViewer.setInput(document);
        String condition = null;
        boolean controlsEnabled = false;
        boolean conditionEnabled = false;
        boolean whenTrue = true;
        ITypeRoot root = null;
        if (breakpoint != null) {
            controlsEnabled = true;
            condition = breakpoint.getCondition();
            conditionEnabled = breakpoint.isConditionEnabled();
            whenTrue = breakpoint.isConditionSuspendOnTrue();
            root = BreakpointHelper.getTypeRoot((IJavaScriptBreakpoint)breakpoint);
        }
        ScriptContext context = null;
        int offset = -1;
        if (root != null && (source = root.getSource()) != null) {
            int lineNumber = breakpoint.getMarker().getAttribute("lineNumber", -1);
            if (source != null && lineNumber != -1) {
                try {
                    offset = new Document(source).getLineOffset(lineNumber - 1);
                }
                catch (BadLocationException e) {
                    JavaScriptDebugUIPlugin.log(e);
                }
            }
        }
        context = new ScriptContext(root, offset);
        this.fCompletionProcessor = new JavaScriptContentAssistProcessor(context);
        this.fViewer.configure((SourceViewerConfiguration)new JavaScriptDebugViewerConfiguration(){

            public IContentAssistProcessor getProcessor() {
                return JavaScriptBreakpointConditionEditor.this.fCompletionProcessor;
            }
        });
        document.set(condition == null ? "" : condition);
        this.fViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(10));
        this.fViewer.getUndoManager().connect((ITextViewer)this.fViewer);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                JavaScriptBreakpointConditionEditor.this.setDirty(4097);
            }
        };
        this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
        this.fConditional.setEnabled(controlsEnabled);
        this.fConditional.setSelection(conditionEnabled);
        this.fWhenTrue.setSelection(whenTrue);
        this.fWhenChange.setSelection(!whenTrue);
        this.setEnabled(conditionEnabled && breakpoint != null, false);
        this.setDirty(false);
    }

    public Control createControl(Composite parent) {
        Composite controls = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 768, 0, 0);
        this.fConditional = SWTFactory.createCheckButton(controls, this.processMnemonics(Messages.conditional), null, false, 1);
        this.fConditional.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fConditional.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = JavaScriptBreakpointConditionEditor.this.fConditional.getSelection();
                JavaScriptBreakpointConditionEditor.this.setEnabled(checked, true);
                JavaScriptBreakpointConditionEditor.this.setDirty(4098);
            }
        });
        Composite radios = SWTFactory.createComposite(controls, controls.getFont(), 2, 1, 768, 0, 0);
        this.fWhenTrue = SWTFactory.createRadioButton(radios, this.processMnemonics(Messages.suspend_when_true));
        this.fWhenTrue.setLayoutData((Object)new GridData());
        this.fWhenChange = SWTFactory.createRadioButton(radios, this.processMnemonics(Messages.suspend_when_changed));
        this.fWhenChange.setLayoutData((Object)new GridData());
        this.fWhenTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptBreakpointConditionEditor.this.setDirty(4099);
            }
        });
        this.fWhenChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptBreakpointConditionEditor.this.setDirty(4099);
            }
        });
        this.fViewer = new JavaScriptSourceViewer(parent, null, 0x2000B00);
        this.fViewer.setEditable(false);
        ControlDecoration decoration = new ControlDecoration(this.fViewer.getControl(), 16512);
        decoration.setShowOnlyOnFocus(true);
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(dec.getImage());
        decoration.setDescriptionText(dec.getDescription());
        GridData gd = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)this.fViewer.getTextWidget());
        gc.setFont(this.fViewer.getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)40);
        gc.dispose();
        this.fViewer.getControl().setLayoutData((Object)gd);
        this.fHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                JavaScriptBreakpointConditionEditor.this.fViewer.doOperation(13);
                return null;
            }
        };
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fHandlerService = (IHandlerService)iWorkbench.getAdapter((Class)clazz);
        this.fViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JavaScriptBreakpointConditionEditor.this.activateContentAssist();
            }

            public void focusLost(FocusEvent e) {
                JavaScriptBreakpointConditionEditor.this.deactivateContentAssist();
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JavaScriptBreakpointConditionEditor.this.dispose();
            }
        });
        return parent;
    }

    protected void dispose() {
        super.dispose();
        this.deactivateContentAssist();
        if (this.fDocumentListener != null) {
            this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        this.fViewer.dispose();
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void doSave() throws CoreException {
        if (this.fBreakpoint != null && this.isDirty()) {
            this.fBreakpoint.setCondition(this.fViewer.getDocument().get().trim());
            this.fBreakpoint.setConditionEnabled(this.fConditional.getSelection());
            this.fBreakpoint.setConditionSuspendOnTrue(this.fWhenTrue.getSelection());
            this.setDirty(false);
        }
    }

    public IStatus getStatus() {
        if (this.fBreakpoint != null && this.fConditional.getSelection() && this.fViewer.getDocument().get().trim().length() == 0) {
            return new Status(4, "org.eclipse.wst.jsdt.debug.ui", Messages.enter_condition);
        }
        return Status.OK_STATUS;
    }

    private void activateContentAssist() {
        this.fActivation = this.fHandlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", this.fHandler);
    }

    private void deactivateContentAssist() {
        if (this.fActivation != null) {
            this.fHandlerService.deactivateHandler(this.fActivation);
            this.fActivation = null;
        }
    }

    private void setEnabled(boolean enabled, boolean focus) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        this.fWhenChange.setEnabled(enabled);
        this.fWhenTrue.setEnabled(enabled);
        if (enabled) {
            this.fViewer.updateViewerColors();
            if (focus) {
                this.setFocus();
            }
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
        }
    }

    public Object getInput() {
        return this.fBreakpoint;
    }
}

