/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;

public class BreakpointHelper {
    public static IMember getMember(IJavaScriptLineBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof IJavaScriptFunctionBreakpoint) {
            return BreakpointHelper.getMethod((IJavaScriptFunctionBreakpoint)breakpoint);
        }
        int start = breakpoint.getCharStart();
        int end = breakpoint.getCharEnd();
        IType type = BreakpointHelper.getType((IJavaScriptBreakpoint)breakpoint);
        if (start == -1 && end == -1) {
            start = breakpoint.getCharStart();
            end = breakpoint.getCharEnd();
        }
        IType member = null;
        if (type != null && type.exists() && end >= start && start >= 0) {
            member = BreakpointHelper.binSearch(type, start, end);
        }
        if (member == null) {
            member = type;
        }
        return member;
    }

    public static IFunction getMethod(IJavaScriptFunctionBreakpoint breakpoint) {
        IJavaScriptElement jse;
        String handle = breakpoint.getModelIdentifier();
        if (handle != null && (jse = JavaScriptCore.create((String)handle)) != null && jse instanceof IFunction) {
            return (IFunction)jse;
        }
        return null;
    }

    public static IType getType(IJavaScriptBreakpoint breakpoint) {
        IJavaScriptElement jse;
        String handle = breakpoint.getModelIdentifier();
        if (handle != null && (jse = JavaScriptCore.create((String)handle)) != null) {
            if (jse instanceof IType) {
                return (IType)jse;
            }
            if (jse instanceof IMember) {
                return ((IMember)jse).getDeclaringType();
            }
        }
        return null;
    }

    public static ITypeRoot getTypeRoot(IJavaScriptBreakpoint breakpoint) {
        try {
            IJavaScriptElement jse;
            String handle = breakpoint.getJavaScriptElementHandle();
            if (handle != null && (jse = JavaScriptCore.create((String)handle)) != null && jse.exists()) {
                if (jse instanceof IType) {
                    return ((IType)jse).getTypeRoot();
                }
                if (jse instanceof IMember) {
                    return ((IMember)jse).getTypeRoot();
                }
            }
        }
        catch (CoreException ce) {
            JavaScriptDebugUIPlugin.log(ce);
        }
        return null;
    }

    static IMember binSearch(IType type, int start, int end) throws JavaScriptModelException {
        IJavaScriptElement je = BreakpointHelper.getElementAt(type, start);
        if (je != null && !je.equals(type)) {
            return BreakpointHelper.asMember(je);
        }
        if (end > start) {
            je = BreakpointHelper.getElementAt(type, end);
            if (je != null && !je.equals(type)) {
                return BreakpointHelper.asMember(je);
            }
            int mid = (end - start) / 2 + start;
            if (mid > start) {
                je = BreakpointHelper.binSearch(type, start + 1, mid);
                if (je == null) {
                    je = BreakpointHelper.binSearch(type, mid + 1, end - 1);
                }
                return BreakpointHelper.asMember(je);
            }
        }
        return null;
    }

    static IMember asMember(IJavaScriptElement element) {
        if (element instanceof IMember) {
            return (IMember)element;
        }
        return null;
    }

    static IJavaScriptElement getElementAt(IType type, int pos) throws JavaScriptModelException {
        if (type.isBinary()) {
            return type.getClassFile().getElementAt(pos);
        }
        return type.getJavaScriptUnit().getElementAt(pos);
    }
}

