/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorSite;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorActionFactory;
import org.eclipse.wst.server.ui.internal.provisional.ServerEditorActionFactoryDelegate;

public class ServerEditorActionFactory
implements IServerEditorActionFactory {
    private IConfigurationElement element;
    private ServerEditorActionFactoryDelegate delegate;

    public ServerEditorActionFactory(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public int getOrder() {
        try {
            String o = this.element.getAttribute("order");
            return Integer.parseInt(o);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String[] getTypeIds() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.element.getAttribute("typeIds"), ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str == null || str.length() <= 0) continue;
                list.add(str);
            }
            String[] s = new String[list.size()];
            list.toArray(s);
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsServerElementType(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        String[] s = this.getTypeIds();
        if (s == null) {
            return false;
        }
        int size = s.length;
        int i = 0;
        while (i < size) {
            if (s[i].endsWith("*") ? id.length() >= s[i].length() && id.startsWith(s[i].substring(0, s[i].length() - 1)) : id.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ServerEditorActionFactoryDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (ServerEditorActionFactoryDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "Could not create server action factory delegate", t);
            }
        }
        return this.delegate;
    }

    public boolean shouldDisplay(IServerWorkingCopy server) {
        try {
            return this.getDelegate().shouldDisplay(server);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error calling delegate", e);
            return false;
        }
    }

    public IAction createAction(IEditorSite site, IServerEditorPartInput input) {
        try {
            return this.getDelegate().createAction(site, input);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error calling delegate", e);
            return null;
        }
    }
}

