/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.core.model.IScript;
import org.eclipse.wst.jsdt.debug.core.model.IScriptGroup;
import org.eclipse.wst.jsdt.debug.internal.core.TextUtils;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptImageDescriptor;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptImageRegistry;
import org.eclipse.wst.jsdt.debug.internal.ui.Messages;

public class JavaScriptModelPresentation
extends LabelProvider
implements IDebugModelPresentationExtension {
    static final String DISPLAY_QUALIFIED_NAMES = "DISPLAY_QUALIFIED_NAMES";
    HashMap attributes = null;

    public boolean requiresUIThread(Object element) {
        return false;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof IJavaScriptValue) {
            listener.detailComputed(value, ((IJavaScriptValue)value).getDetailString());
        }
    }

    public void setAttribute(String attribute, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attribute, value);
    }

    public void dispose() {
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        super.dispose();
    }

    boolean showQualifiedNames() {
        Boolean show;
        if (this.attributes != null && (show = (Boolean)this.attributes.get(DISPLAY_QUALIFIED_NAMES)) != null) {
            return show;
        }
        return true;
    }

    public String getText(Object element) {
        try {
            if (element instanceof IDebugTarget) {
                return ((IDebugTarget)element).getName();
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).getName();
            }
            if (element instanceof IThread) {
                return ((IThread)element).getName();
            }
            if (element instanceof IVariable) {
                return ((IVariable)element).getName();
            }
            if (element instanceof IValue) {
                return ((IValue)element).getValueString();
            }
            if (element instanceof IJavaScriptFunctionBreakpoint) {
                return this.getFunctionBreakpointText((IJavaScriptFunctionBreakpoint)element);
            }
            if (element instanceof IJavaScriptLoadBreakpoint) {
                return this.getScriptLoadBreakpointText((IJavaScriptLoadBreakpoint)element);
            }
            if (element instanceof IJavaScriptLineBreakpoint) {
                return this.getLineBreakpointText((IJavaScriptLineBreakpoint)element);
            }
            if (element instanceof IScriptGroup) {
                return Messages.scripts;
            }
            if (element instanceof IScript) {
                return this.getScriptText((IScript)element);
            }
        }
        catch (CoreException ce) {
            JavaScriptDebugUIPlugin.log(ce);
        }
        return element.toString();
    }

    String getScriptText(IScript script) {
        String uri = script.sourceURI().toString();
        return TextUtils.shortenText((String)uri, (int)100);
    }

    String getLineBreakpointText(IJavaScriptLineBreakpoint breakpoint) throws CoreException {
        String path = this.getElementPath(breakpoint.getScriptPath());
        StringBuffer buffer = new StringBuffer();
        buffer.append(path).append(NLS.bind((String)Messages.bp_line_number, (Object[])new String[]{Integer.toString(breakpoint.getLineNumber())}));
        int hitcount = breakpoint.getHitCount();
        if (hitcount > 0) {
            buffer.append(NLS.bind((String)Messages.bp_hit_count, (Object[])new String[]{Integer.toString(hitcount)}));
        }
        if (breakpoint.isConditionEnabled()) {
            buffer.append(Messages.bp_conditonal);
        }
        if (breakpoint.getSuspendPolicy() == 2) {
            buffer.append(Messages.bp_suspend_vm);
        }
        return buffer.toString();
    }

    String getFunctionBreakpointText(IJavaScriptFunctionBreakpoint breakpoint) throws CoreException {
        String path = this.getElementPath(breakpoint.getScriptPath());
        StringBuffer buffer = new StringBuffer();
        buffer.append(path);
        if (breakpoint.isEntry()) {
            if (breakpoint.isExit()) {
                buffer.append(Messages.bp_entry_and_exit);
            } else {
                buffer.append(Messages.bp_entry_only);
            }
        } else if (breakpoint.isExit()) {
            buffer.append(Messages.bp_exit_only);
        }
        int hitcount = breakpoint.getHitCount();
        if (hitcount > 0) {
            buffer.append(NLS.bind((String)Messages.bp_hit_count, (Object[])new String[]{Integer.toString(hitcount)}));
        }
        if (breakpoint.isConditionEnabled()) {
            buffer.append(Messages.bp_conditional);
        }
        if (breakpoint.getSuspendPolicy() == 2) {
            buffer.append(Messages.bp_suspend_vm);
        }
        String method = Signature.toString((String)breakpoint.getSignature(), (String)breakpoint.getFunctionName(), null, (boolean)false, (boolean)false);
        buffer.append(" - ").append(method);
        return buffer.toString();
    }

    String getScriptLoadBreakpointText(IJavaScriptLoadBreakpoint breakpoint) throws CoreException {
        String path = this.getElementPath(breakpoint.getScriptPath());
        StringBuffer buffer = new StringBuffer();
        buffer.append(path);
        int hitcount = breakpoint.getHitCount();
        if (hitcount > 0) {
            buffer.append(NLS.bind((String)Messages.bp_hit_count, (Object[])new String[]{Integer.toString(hitcount)}));
        }
        if (breakpoint.getSuspendPolicy() == 2) {
            buffer.append(Messages.bp_suspend_vm);
        }
        return buffer.toString();
    }

    String getElementPath(String path) {
        if (!this.showQualifiedNames()) {
            try {
                return URIUtil.lastSegment((URI)URIUtil.fromString((String)path));
            }
            catch (URISyntaxException urise) {
                JavaScriptDebugUIPlugin.log(urise);
            }
        }
        return path;
    }

    public Image getImage(Object element) {
        try {
            if (element instanceof IVariable) {
                IVariable var = (IVariable)element;
                return this.getImageFromType(var);
            }
            if (element instanceof IJavaScriptLineBreakpoint || element instanceof IJavaScriptFunctionBreakpoint) {
                IJavaScriptBreakpoint breakpoint = (IJavaScriptBreakpoint)element;
                int flags = this.computeBreakpointAdornmentFlags(breakpoint);
                if (breakpoint.isEnabled()) {
                    return JavaScriptImageRegistry.getImage((ImageDescriptor)new JavaScriptImageDescriptor(JavaScriptImageRegistry.getSharedImage("IMG_BRKP"), flags));
                }
                return JavaScriptImageRegistry.getImage((ImageDescriptor)new JavaScriptImageDescriptor(JavaScriptImageRegistry.getSharedImage("IMG_BRKP_DISABLED"), flags));
            }
            if (element instanceof IScript) {
                return JavaScriptImageRegistry.getImage((ImageDescriptor)new JavaScriptImageDescriptor(JavaScriptImageRegistry.getSharedImage("IMG_SCRIPT"), 0));
            }
            if (element instanceof IScriptGroup) {
                return JavaScriptImageRegistry.getImage((ImageDescriptor)new JavaScriptImageDescriptor(JavaScriptImageRegistry.getSharedImage("IMG_SCRIPT_GRP"), 0));
            }
        }
        catch (DebugException de) {
            JavaScriptDebugUIPlugin.log(de);
        }
        catch (CoreException ce) {
            JavaScriptDebugUIPlugin.log(ce);
        }
        return null;
    }

    int computeBreakpointAdornmentFlags(IJavaScriptBreakpoint breakpoint) {
        int flags = 0;
        try {
            if (breakpoint.isEnabled()) {
                flags |= 8;
            }
            if (breakpoint.isInstalled()) {
                flags |= 1;
            }
            if (breakpoint instanceof IJavaScriptLineBreakpoint && ((IJavaScriptLineBreakpoint)breakpoint).isConditionEnabled()) {
                flags |= 0x10;
            }
            if (breakpoint instanceof IJavaScriptFunctionBreakpoint) {
                IJavaScriptFunctionBreakpoint mBreakpoint = (IJavaScriptFunctionBreakpoint)breakpoint;
                if (mBreakpoint.isEntry()) {
                    flags |= 2;
                }
                if (mBreakpoint.isExit()) {
                    flags |= 4;
                }
            }
        }
        catch (CoreException coreException) {}
        return flags;
    }

    Image getImageFromType(IVariable variable) throws DebugException {
        String name = variable.getName();
        if ("this".equals(name)) {
            return JavaScriptImageRegistry.getImage((ImageDescriptor)new JavaScriptImageDescriptor(JavaScriptImageRegistry.getSharedImage("IMG_THIS_VAR"), 0));
        }
        if ("[proto]".equals(name)) {
            return JavaScriptImageRegistry.getImage((ImageDescriptor)new JavaScriptImageDescriptor(JavaScriptImageRegistry.getSharedImage("IMG_PROTO_VAR"), 0));
        }
        return JavaScriptImageRegistry.getSharedImage("IMG_LOCAL_VAR");
    }

    public String getEditorId(IEditorInput input, Object element) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource;
        if (element instanceof File) {
            return new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile((File)element));
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IJavaScriptLoadBreakpoint) {
            try {
                IJavaScriptLoadBreakpoint bp = (IJavaScriptLoadBreakpoint)element;
                IResource resource2 = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(bp.getScriptPath()));
                if (resource2.getType() == 1) {
                    return new FileEditorInput((IFile)resource2);
                }
            }
            catch (CoreException ce) {
                JavaScriptDebugUIPlugin.log(ce);
            }
        }
        if (element instanceof IJavaScriptBreakpoint && (resource = ((IJavaScriptBreakpoint)element).getMarker().getResource()).getType() == 1) {
            return new FileEditorInput((IFile)resource);
        }
        return null;
    }
}

