/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.style.java;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.wst.jsdt.web.core.javascript.JsDataTypes;
import org.eclipse.wst.jsdt.web.ui.internal.style.java.JavaWordDetector;

class JSDTCodeScanner
extends RuleBasedScanner {
    private static String[] fgConstants = JsDataTypes.CONSTANTS;
    private static String[] fgKeywords = JsDataTypes.KEYWORDS;
    private static String[] fgTypes = JsDataTypes.TYPES;
    private IToken fDefaultToken;
    private IToken fKeywordToken;
    private IToken fSingleLineCommentToken;
    private IToken fMultiLineCommentToken;
    private IToken fStringToken;
    private IToken fTypeToken;
    private IToken fHTMLCommentBorderToken;

    public void initializeRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("/*", "*/", this.fMultiLineCommentToken));
        rules.add((Object)new NoneInclusiveEndSequenceSingleLineRule("//", "-->", this.fSingleLineCommentToken));
        rules.add(new SingleLineRule("\"", "\"", this.fStringToken, '\\'));
        rules.add(new SingleLineRule("'", "'", this.fStringToken, '\\'));
        WordRule wordRule = new WordRule((IWordDetector)new JavaWordDetector(), this.fDefaultToken);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], this.fKeywordToken);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], this.fTypeToken);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], this.fTypeToken);
            ++i;
        }
        rules.add(wordRule);
        rules.add(new WordRule((IWordDetector)new HTMLCommentDetector(), this.fHTMLCommentBorderToken));
        rules.add((Object)new NoneInclusiveStartSequenceEndOfLineRule("<!--", this.fSingleLineCommentToken));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setTokenData(String tokenKey, Object data) {
        if (tokenKey == "keyword") {
            this.fKeywordToken = new Token(data);
            this.fTypeToken = new Token(data);
        } else if (tokenKey == "string") {
            this.fStringToken = new Token(data);
        } else if (tokenKey == "single_line_comment") {
            this.fSingleLineCommentToken = new Token(data);
        } else if (tokenKey == "multi_line_comment") {
            this.fMultiLineCommentToken = new Token(data);
        } else if (tokenKey == "default") {
            this.fDefaultToken = new Token(data);
        } else if (tokenKey == "commentBorder") {
            this.fHTMLCommentBorderToken = new Token(data);
        }
    }

    private static class HTMLCommentDetector
    implements IWordDetector {
        private HTMLCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '<' || c == '-';
        }

        public boolean isWordPart(char c) {
            return c == '-' || c == '!' || c == '>';
        }
    }

    private static class NoneInclusiveEndSequenceSingleLineRule
    extends SingleLineRule {
        public NoneInclusiveEndSequenceSingleLineRule(String startSequence, String endSequence, IToken token) {
            super(startSequence, endSequence, token);
        }

        protected boolean endSequenceDetected(ICharacterScanner scanner) {
            boolean success = super.endSequenceDetected(scanner);
            if (success) {
                int length = this.fEndSequence.length - 1;
                while (length > 0) {
                    scanner.unread();
                    --length;
                }
                if (this.sequenceDetected(scanner, this.fEndSequence, false)) {
                    length = this.fEndSequence.length;
                    while (length > 0) {
                        scanner.unread();
                        --length;
                    }
                }
            }
            return success;
        }
    }

    private static class NoneInclusiveStartSequenceEndOfLineRule
    extends EndOfLineRule {
        public NoneInclusiveStartSequenceEndOfLineRule(String startSequence, IToken token) {
            super(startSequence, token);
        }

        protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
            if (resume) {
                if (this.endSequenceDetected(scanner)) {
                    return this.fToken;
                }
            } else {
                int i = 0;
                while (i < this.fStartSequence.length && scanner.getColumn() >= 0) {
                    scanner.unread();
                    ++i;
                }
                int c = scanner.read();
                if (c == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
                    return this.fToken;
                }
                int i2 = 0;
                while (i2 < this.fStartSequence.length && scanner.getColumn() >= 0) {
                    scanner.read();
                    ++i2;
                }
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

