/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: OrmTableImpl.java,v 1.13 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.MetadataElement;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.OrmTable;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Orm Table</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#getCatalog <em>Catalog</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#getSchema <em>Schema</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#getColumnList <em>Column List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#getParentElement <em>Parent Element</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#getComment <em>Comment</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#getPrimaryKeyList <em>Primary Key List</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.OrmTableImpl#isVirtual <em>Virtual</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OrmTableImpl extends MetadataElementImpl implements OrmTable {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCatalog() <em>Catalog</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCatalog()
	 * @generated
	 * @ordered
	 */
	protected static final String CATALOG_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCatalog() <em>Catalog</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCatalog()
	 * @generated
	 * @ordered
	 */
	protected String catalog = CATALOG_EDEFAULT;

	/**
	 * The default value of the '{@link #getSchema() <em>Schema</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSchema()
	 * @generated
	 * @ordered
	 */
	protected static final String SCHEMA_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSchema() <em>Schema</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSchema()
	 * @generated
	 * @ordered
	 */
	protected String schema = SCHEMA_EDEFAULT;

	/**
	 * The cached value of the '{@link #getColumnList() <em>Column List</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumnList()
	 * @generated
	 * @ordered
	 */
	protected EList columnList = null;

	/**
	 * The cached value of the '{@link #getParentElement() <em>Parent Element</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParentElement()
	 * @generated
	 * @ordered
	 */
	protected MetadataElement parentElement = null;

	/**
	 * The default value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
    protected static final String COMMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
    protected String comment = COMMENT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPrimaryKeyList() <em>Primary Key List</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrimaryKeyList()
	 * @generated
	 * @ordered
	 */
	protected EList primaryKeyList = null;

	/**
	 * The default value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VIRTUAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected boolean virtual = VIRTUAL_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrmTableImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getOrmTable();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_TABLE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCatalog() {
		return catalog;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCatalog(String newCatalog) {
		String oldCatalog = catalog;
		catalog = newCatalog;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_TABLE__CATALOG, oldCatalog, catalog));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSchema() {
		return schema;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSchema(String newSchema) {
		String oldSchema = schema;
		schema = newSchema;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_TABLE__SCHEMA, oldSchema, schema));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getColumnList() {
		if (columnList == null) {
			columnList = new EObjectWithInverseResolvingEList(OrmColumn.class, this, MetadataPackage.ORM_TABLE__COLUMN_LIST, MetadataPackage.ORM_COLUMN__TABLE);
		}
		return columnList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetadataElement getParentElement() {
		if (parentElement != null && parentElement.eIsProxy()) {
			MetadataElement oldParentElement = parentElement;
			parentElement = (MetadataElement)eResolveProxy((InternalEObject)parentElement);
			if (parentElement != oldParentElement) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.ORM_TABLE__PARENT_ELEMENT, oldParentElement, parentElement));
			}
		}
		return parentElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetadataElement basicGetParentElement() {
		return parentElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentElement(MetadataElement newParentElement) {
		MetadataElement oldParentElement = parentElement;
		parentElement = newParentElement;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_TABLE__PARENT_ELEMENT, oldParentElement, parentElement));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public String getComment() {
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public void setComment(String newComment) {
		String oldComment = comment;
		comment = newComment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_TABLE__COMMENT, oldComment, comment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPrimaryKeyList() {
		if (primaryKeyList == null) {
			primaryKeyList = new EObjectResolvingEList(OrmColumn.class, this, MetadataPackage.ORM_TABLE__PRIMARY_KEY_LIST);
		}
		return primaryKeyList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isVirtual() {
		return virtual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVirtual(boolean newVirtual) {
		boolean oldVirtual = virtual;
		virtual = newVirtual;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.ORM_TABLE__VIRTUAL, oldVirtual, virtual));
	}

	public OrmColumn findColumn(String name) {
		if (columnList == null) {
			return null;
		}
		for (int i = columnList.size() - 1; i >= 0; i--) {
			OrmColumn c = (OrmColumn)columnList.get(i);
			if (name.equals(c.getName())) {
				return c;
			}
		}
		return null;
	}

	public boolean sortColumns() {
		if (columnList != null) {
			sort(columnList, COLUMN_POSITION_COMPARATOR);
			if (primaryKeyList != null) {
				sort(primaryKeyList, COLUMN_POSITION_COMPARATOR);
			}
		}
		return true;
	}
	
	/**
	 * Sort the list like Collections.sort but but use remove and add instead 
	 * of set to reorder it. This avoids tripping the unique constraint on
	 * EMF inverse lists.
	 */
	public static void sort(List list, Comparator comp) {
		int n = list.size();
		if (n < 2) {
			return;
		}
		Object[] a = list.toArray();
		Arrays.sort(a, comp);
		for (int i = 0; i < n; i++) {
			Object old = list.get(i);
			Object nw = a[i];
			if (nw != old) {
				list.remove(nw);
				list.add(i, nw);
			}
		}
	}
	
	/**
	 * Sorts OrmColumn's by {@link OrmColumn#getRelativePositionInTable()}.
	 */
	public static final Comparator COLUMN_POSITION_COMPARATOR = new Comparator() {
		public int compare(Object o1, Object o2) {
			return ((OrmColumn)o1).getRelativePositionInTable()
				- ((OrmColumn)o2).getRelativePositionInTable();
		}
	};

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ORM_TABLE__COLUMN_LIST:
					return ((InternalEList)getColumnList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.ORM_TABLE__COLUMN_LIST:
					return ((InternalEList)getColumnList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_TABLE__NAME:
				return getName();
			case MetadataPackage.ORM_TABLE__CATALOG:
				return getCatalog();
			case MetadataPackage.ORM_TABLE__SCHEMA:
				return getSchema();
			case MetadataPackage.ORM_TABLE__COLUMN_LIST:
				return getColumnList();
			case MetadataPackage.ORM_TABLE__PARENT_ELEMENT:
				if (resolve) return getParentElement();
				return basicGetParentElement();
			case MetadataPackage.ORM_TABLE__COMMENT:
				return getComment();
			case MetadataPackage.ORM_TABLE__PRIMARY_KEY_LIST:
				return getPrimaryKeyList();
			case MetadataPackage.ORM_TABLE__VIRTUAL:
				return isVirtual() ? Boolean.TRUE : Boolean.FALSE;
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_TABLE__NAME:
				setName((String)newValue);
				return;
			case MetadataPackage.ORM_TABLE__CATALOG:
				setCatalog((String)newValue);
				return;
			case MetadataPackage.ORM_TABLE__SCHEMA:
				setSchema((String)newValue);
				return;
			case MetadataPackage.ORM_TABLE__COLUMN_LIST:
				getColumnList().clear();
				getColumnList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ORM_TABLE__PARENT_ELEMENT:
				setParentElement((MetadataElement)newValue);
				return;
			case MetadataPackage.ORM_TABLE__COMMENT:
				setComment((String)newValue);
				return;
			case MetadataPackage.ORM_TABLE__PRIMARY_KEY_LIST:
				getPrimaryKeyList().clear();
				getPrimaryKeyList().addAll((Collection)newValue);
				return;
			case MetadataPackage.ORM_TABLE__VIRTUAL:
				setVirtual(((Boolean)newValue).booleanValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_TABLE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case MetadataPackage.ORM_TABLE__CATALOG:
				setCatalog(CATALOG_EDEFAULT);
				return;
			case MetadataPackage.ORM_TABLE__SCHEMA:
				setSchema(SCHEMA_EDEFAULT);
				return;
			case MetadataPackage.ORM_TABLE__COLUMN_LIST:
				getColumnList().clear();
				return;
			case MetadataPackage.ORM_TABLE__PARENT_ELEMENT:
				setParentElement((MetadataElement)null);
				return;
			case MetadataPackage.ORM_TABLE__COMMENT:
				setComment(COMMENT_EDEFAULT);
				return;
			case MetadataPackage.ORM_TABLE__PRIMARY_KEY_LIST:
				getPrimaryKeyList().clear();
				return;
			case MetadataPackage.ORM_TABLE__VIRTUAL:
				setVirtual(VIRTUAL_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.ORM_TABLE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case MetadataPackage.ORM_TABLE__CATALOG:
				return CATALOG_EDEFAULT == null ? catalog != null : !CATALOG_EDEFAULT.equals(catalog);
			case MetadataPackage.ORM_TABLE__SCHEMA:
				return SCHEMA_EDEFAULT == null ? schema != null : !SCHEMA_EDEFAULT.equals(schema);
			case MetadataPackage.ORM_TABLE__COLUMN_LIST:
				return columnList != null && !columnList.isEmpty();
			case MetadataPackage.ORM_TABLE__PARENT_ELEMENT:
				return parentElement != null;
			case MetadataPackage.ORM_TABLE__COMMENT:
				return COMMENT_EDEFAULT == null ? comment != null : !COMMENT_EDEFAULT.equals(comment);
			case MetadataPackage.ORM_TABLE__PRIMARY_KEY_LIST:
				return primaryKeyList != null && !primaryKeyList.isEmpty();
			case MetadataPackage.ORM_TABLE__VIRTUAL:
				return virtual != VIRTUAL_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", catalog: ");
		result.append(catalog);
		result.append(", schema: ");
		result.append(schema);
		result.append(", comment: ");
		result.append(comment);
		result.append(", virtual: ");
		result.append(virtual);
		result.append(')');
		return result.toString();
	}

	public void delete() {
		if (columnList != null) {
			for (int i = columnList.size() - 1; i >= 0; i--) {
				// this will remove it from the primaryKeyList
				((OrmColumn)columnList.get(i)).delete();
			}
		}
		super.delete();
	}

} //OrmTableImpl
