/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: CollectionAttributeImpl.java,v 1.15 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.Join;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Collection Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl#getElementType <em>Element Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl#isOneToMany <em>One To Many</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl#getJoinTable <em>Join Table</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl#getSrcJoin <em>Src Join</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl#getDestJoin <em>Dest Join</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl#getCascadeType <em>Cascade Type</em>}</li>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.CollectionAttributeImpl#getOrderBy <em>Order By</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CollectionAttributeImpl extends AttributeMetaDataImpl implements
		CollectionAttribute {
	/**
	 * The cached value of the '{@link #getElementType() <em>Element Type</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getElementType()
	 * @generated
	 * @ordered
	 */
	protected TypeMetaData elementType = null;

	/**
	 * The default value of the '{@link #isOneToMany() <em>One To Many</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOneToMany()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ONE_TO_MANY_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isOneToMany() <em>One To Many</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOneToMany()
	 * @generated
	 * @ordered
	 */
	protected boolean oneToMany = ONE_TO_MANY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getJoinTable() <em>Join Table</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJoinTable()
	 * @generated
	 * @ordered
	 */
	protected OrmTable joinTable = null;

	/**
	 * The cached value of the '{@link #getSrcJoin() <em>Src Join</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSrcJoin()
	 * @generated
	 * @ordered
	 */
	protected Join srcJoin = null;

	/**
	 * The cached value of the '{@link #getDestJoin() <em>Dest Join</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDestJoin()
	 * @generated
	 * @ordered
	 */
	protected Join destJoin = null;

	/**
	 * The default value of the '{@link #getCascadeType() <em>Cascade Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCascadeType()
	 * @generated
	 * @ordered
	 */
	protected static final int CASCADE_TYPE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCascadeType() <em>Cascade Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCascadeType()
	 * @generated
	 * @ordered
	 */
	protected int cascadeType = CASCADE_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getOrderBy() <em>Order By</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOrderBy()
	 * @generated
	 * @ordered
	 */
	protected static final String ORDER_BY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOrderBy() <em>Order By</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOrderBy()
	 * @generated
	 * @ordered
	 */
	protected String orderBy = ORDER_BY_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionAttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getCollectionAttribute();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData getElementType() {
		if (elementType != null && elementType.eIsProxy()) {
			TypeMetaData oldElementType = elementType;
			elementType = (TypeMetaData)eResolveProxy((InternalEObject)elementType);
			if (elementType != oldElementType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.COLLECTION_ATTRIBUTE__ELEMENT_TYPE, oldElementType, elementType));
			}
		}
		return elementType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public TypeMetaData basicGetElementType() {
		return elementType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setElementType(TypeMetaData newElementType) {
		TypeMetaData oldElementType = elementType;
		elementType = newElementType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.COLLECTION_ATTRIBUTE__ELEMENT_TYPE, oldElementType, elementType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmTable getJoinTable() {
		if (joinTable != null && joinTable.eIsProxy()) {
			OrmTable oldJoinTable = joinTable;
			joinTable = (OrmTable)eResolveProxy((InternalEObject)joinTable);
			if (joinTable != oldJoinTable) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.COLLECTION_ATTRIBUTE__JOIN_TABLE, oldJoinTable, joinTable));
			}
		}
		return joinTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmTable basicGetJoinTable() {
		return joinTable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setJoinTable(OrmTable newJoinTable) {
		OrmTable oldJoinTable = joinTable;
		joinTable = newJoinTable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.COLLECTION_ATTRIBUTE__JOIN_TABLE, oldJoinTable, joinTable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join getSrcJoin() {
		if (srcJoin != null && srcJoin.eIsProxy()) {
			Join oldSrcJoin = srcJoin;
			srcJoin = (Join)eResolveProxy((InternalEObject)srcJoin);
			if (srcJoin != oldSrcJoin) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.COLLECTION_ATTRIBUTE__SRC_JOIN, oldSrcJoin, srcJoin));
			}
		}
		return srcJoin;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join basicGetSrcJoin() {
		return srcJoin;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSrcJoin(Join newSrcJoin) {
		Join oldSrcJoin = srcJoin;
		srcJoin = newSrcJoin;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.COLLECTION_ATTRIBUTE__SRC_JOIN, oldSrcJoin, srcJoin));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join getDestJoin() {
		if (destJoin != null && destJoin.eIsProxy()) {
			Join oldDestJoin = destJoin;
			destJoin = (Join)eResolveProxy((InternalEObject)destJoin);
			if (destJoin != oldDestJoin) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.COLLECTION_ATTRIBUTE__DEST_JOIN, oldDestJoin, destJoin));
			}
		}
		return destJoin;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Join basicGetDestJoin() {
		return destJoin;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDestJoin(Join newDestJoin) {
		Join oldDestJoin = destJoin;
		destJoin = newDestJoin;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.COLLECTION_ATTRIBUTE__DEST_JOIN, oldDestJoin, destJoin));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCascadeType() {
		return cascadeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCascadeType(int newCascadeType) {
		int oldCascadeType = cascadeType;
		cascadeType = newCascadeType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.COLLECTION_ATTRIBUTE__CASCADE_TYPE, oldCascadeType, cascadeType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOrderBy() {
		return orderBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOrderBy(String newOrderBy) {
		String oldOrderBy = orderBy;
		orderBy = newOrderBy;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.COLLECTION_ATTRIBUTE__ORDER_BY, oldOrderBy, orderBy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isOneToMany() {
		return oneToMany;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOneToMany(boolean newOneToMany) {
		boolean oldOneToMany = oneToMany;
		oneToMany = newOneToMany;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.COLLECTION_ATTRIBUTE__ONE_TO_MANY, oldOneToMany, oneToMany));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.COLLECTION_ATTRIBUTE__ENTITY_META_DATA:
					if (entityMetaData != null)
						msgs = ((InternalEObject)entityMetaData).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST, EntityMetaData.class, msgs);
					return basicSetEntityMetaData((EntityMetaData)otherEnd, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__EMBEDDED_IN:
					if (embeddedIn != null)
						msgs = ((InternalEObject)embeddedIn).eInverseRemove(this, MetadataPackage.EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST, EmbeddedAttribute.class, msgs);
					return basicSetEmbeddedIn((EmbeddedAttribute)otherEnd, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__MAPPED_BY:
					if (mappedBy != null)
						msgs = ((InternalEObject)mappedBy).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST, AttributeMetaData.class, msgs);
					return basicSetMappedBy((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicAdd(otherEnd, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_OF:
					if (overrideOf != null)
						msgs = ((InternalEObject)overrideOf).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST, AttributeMetaData.class, msgs);
					return basicSetOverrideOf((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.COLLECTION_ATTRIBUTE__ENTITY_META_DATA:
					return basicSetEntityMetaData(null, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__EMBEDDED_IN:
					return basicSetEmbeddedIn(null, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__MAPPED_BY:
					return basicSetMappedBy(null, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicRemove(otherEnd, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_OF:
					return basicSetOverrideOf(null, msgs);
				case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_ATTRIBUTE__ENTITY_META_DATA:
				if (resolve) return getEntityMetaData();
				return basicGetEntityMetaData();
			case MetadataPackage.COLLECTION_ATTRIBUTE__EMBEDDED_IN:
				if (resolve) return getEmbeddedIn();
				return basicGetEmbeddedIn();
			case MetadataPackage.COLLECTION_ATTRIBUTE__NAME:
				return getName();
			case MetadataPackage.COLLECTION_ATTRIBUTE__JAVA_TYPE:
				if (resolve) return getJavaType();
				return basicGetJavaType();
			case MetadataPackage.COLLECTION_ATTRIBUTE__FETCH_TYPE:
				return new Integer(getFetchType());
			case MetadataPackage.COLLECTION_ATTRIBUTE__OPTIONAL:
				return isOptional() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.COLLECTION_ATTRIBUTE__GETTER_METHOD_NAME:
				return getGetterMethodName();
			case MetadataPackage.COLLECTION_ATTRIBUTE__SETTER_METHOD_NAME:
				return getSetterMethodName();
			case MetadataPackage.COLLECTION_ATTRIBUTE__MAPPED_BY:
				if (resolve) return getMappedBy();
				return basicGetMappedBy();
			case MetadataPackage.COLLECTION_ATTRIBUTE__INVERSE_LIST:
				return getInverseList();
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_OF:
				if (resolve) return getOverrideOf();
				return basicGetOverrideOf();
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_LIST:
				return getOverrideList();
			case MetadataPackage.COLLECTION_ATTRIBUTE__ELEMENT_TYPE:
				if (resolve) return getElementType();
				return basicGetElementType();
			case MetadataPackage.COLLECTION_ATTRIBUTE__ONE_TO_MANY:
				return isOneToMany() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.COLLECTION_ATTRIBUTE__JOIN_TABLE:
				if (resolve) return getJoinTable();
				return basicGetJoinTable();
			case MetadataPackage.COLLECTION_ATTRIBUTE__SRC_JOIN:
				if (resolve) return getSrcJoin();
				return basicGetSrcJoin();
			case MetadataPackage.COLLECTION_ATTRIBUTE__DEST_JOIN:
				if (resolve) return getDestJoin();
				return basicGetDestJoin();
			case MetadataPackage.COLLECTION_ATTRIBUTE__CASCADE_TYPE:
				return new Integer(getCascadeType());
			case MetadataPackage.COLLECTION_ATTRIBUTE__ORDER_BY:
				return getOrderBy();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_ATTRIBUTE__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__NAME:
				setName((String)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__JAVA_TYPE:
				setJavaType((TypeMetaData)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__FETCH_TYPE:
				setFetchType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OPTIONAL:
				setOptional(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__GETTER_METHOD_NAME:
				setGetterMethodName((String)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__SETTER_METHOD_NAME:
				setSetterMethodName((String)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__MAPPED_BY:
				setMappedBy((AttributeMetaData)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__INVERSE_LIST:
				getInverseList().clear();
				getInverseList().addAll((Collection)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_LIST:
				getOverrideList().clear();
				getOverrideList().addAll((Collection)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ELEMENT_TYPE:
				setElementType((TypeMetaData)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ONE_TO_MANY:
				setOneToMany(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__JOIN_TABLE:
				setJoinTable((OrmTable)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__SRC_JOIN:
				setSrcJoin((Join)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__DEST_JOIN:
				setDestJoin((Join)newValue);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__CASCADE_TYPE:
				setCascadeType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ORDER_BY:
				setOrderBy((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_ATTRIBUTE__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__JAVA_TYPE:
				setJavaType((TypeMetaData)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__FETCH_TYPE:
				setFetchType(FETCH_TYPE_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OPTIONAL:
				setOptional(OPTIONAL_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__GETTER_METHOD_NAME:
				setGetterMethodName(GETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__SETTER_METHOD_NAME:
				setSetterMethodName(SETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__MAPPED_BY:
				setMappedBy((AttributeMetaData)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__INVERSE_LIST:
				getInverseList().clear();
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_LIST:
				getOverrideList().clear();
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ELEMENT_TYPE:
				setElementType((TypeMetaData)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ONE_TO_MANY:
				setOneToMany(ONE_TO_MANY_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__JOIN_TABLE:
				setJoinTable((OrmTable)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__SRC_JOIN:
				setSrcJoin((Join)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__DEST_JOIN:
				setDestJoin((Join)null);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__CASCADE_TYPE:
				setCascadeType(CASCADE_TYPE_EDEFAULT);
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ORDER_BY:
				setOrderBy(ORDER_BY_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.COLLECTION_ATTRIBUTE__ENTITY_META_DATA:
				return entityMetaData != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__EMBEDDED_IN:
				return embeddedIn != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case MetadataPackage.COLLECTION_ATTRIBUTE__JAVA_TYPE:
				return javaType != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__FETCH_TYPE:
				return fetchType != FETCH_TYPE_EDEFAULT;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OPTIONAL:
				return optional != OPTIONAL_EDEFAULT;
			case MetadataPackage.COLLECTION_ATTRIBUTE__GETTER_METHOD_NAME:
				return GETTER_METHOD_NAME_EDEFAULT == null ? getterMethodName != null : !GETTER_METHOD_NAME_EDEFAULT.equals(getterMethodName);
			case MetadataPackage.COLLECTION_ATTRIBUTE__SETTER_METHOD_NAME:
				return SETTER_METHOD_NAME_EDEFAULT == null ? setterMethodName != null : !SETTER_METHOD_NAME_EDEFAULT.equals(setterMethodName);
			case MetadataPackage.COLLECTION_ATTRIBUTE__MAPPED_BY:
				return mappedBy != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__INVERSE_LIST:
				return inverseList != null && !inverseList.isEmpty();
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_OF:
				return overrideOf != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__OVERRIDE_LIST:
				return overrideList != null && !overrideList.isEmpty();
			case MetadataPackage.COLLECTION_ATTRIBUTE__ELEMENT_TYPE:
				return elementType != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ONE_TO_MANY:
				return oneToMany != ONE_TO_MANY_EDEFAULT;
			case MetadataPackage.COLLECTION_ATTRIBUTE__JOIN_TABLE:
				return joinTable != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__SRC_JOIN:
				return srcJoin != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__DEST_JOIN:
				return destJoin != null;
			case MetadataPackage.COLLECTION_ATTRIBUTE__CASCADE_TYPE:
				return cascadeType != CASCADE_TYPE_EDEFAULT;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ORDER_BY:
				return ORDER_BY_EDEFAULT == null ? orderBy != null : !ORDER_BY_EDEFAULT.equals(orderBy);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (oneToMany: ");
		result.append(oneToMany);
		result.append(", cascadeType: ");
		result.append(cascadeType);
		result.append(", orderBy: ");
		result.append(orderBy);
		result.append(')');
		return result.toString();
	}

    public void getTopLevelSqlObjects(HashSet sqlObjects) {
        if(joinTable != null){
            sqlObjects.add(joinTable);
        }
    }

    public List getColumns() {
    	if (mappedBy != null) {
    		return super.getColumns();
    	} 
    	if (joinTable == null) {
    		return Collections.EMPTY_LIST;
    	}
    	ArrayList a = new ArrayList();
    	if (srcJoin != null) {
    		a.addAll(srcJoin.getDestColumns());
    	} else {
    		EntityMetaData emd = getEntityMetaData();
    		if (emd != null) {
    			OrmTable srcTable = emd.getTable();
        		if (srcTable != null) {
        			a.addAll(srcTable.getPrimaryKeyList());
        		}
    		}
    	}
    	a.addAll(joinTable.getColumnList());
    	if (destJoin != null) {
    		a.addAll(destJoin.getDestColumns());
    	} else if (elementType instanceof EntityMetaData){
    		OrmTable destTable = ((EntityMetaData)elementType).getTable();
    		if (destTable != null) {
    			a.addAll(destTable.getPrimaryKeyList());
    		}
    	}
    	return a;
    }

	public void setMappedBy(AttributeMetaData newMappedBy) {
		super.setMappedBy(newMappedBy);
		// get rid of our joinTable if we are now using mappedBy
		if (getMappedBy() != null && joinTable != null) {
			joinTable.delete();
			setJoinTable(null);
		}
	}

} // CollectionAttributeImpl
