/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.metadata;

/**
 * JDO specific extensions for a persistent class.
 * 
 * @model
 * @generated
 */
public interface JdoEntity extends EntityMetaData {

	/**
	 * Implementation manages identity and generates primary keys.
	 */
	public static final int IDENTITY_TYPE_DATASTORE = 1;

	/**
	 * Application manages identity in fields of the class.
	 */
	public static final int IDENTITY_TYPE_APPLICATION = 2;

	/**
	 * Never been all that sure what this is.
	 */
	public static final int IDENTITY_TYPE_NON_DURABLE = 3;

	/**
	 * Type of identity being used by the entity (see
	 * {@link #IDENTITY_TYPE_APPLICATION} etc.).
	 * 
	 * @model
	 * @generated
	 */
	int getIdentityType();

	/**
	 * @generated
	 */
	void setIdentityType(int value);

} // JdoEntity
