/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */
package org.eclipse.jsr220orm.metadata;

import org.eclipse.emf.common.util.EList;

/**
 * An embedded attribute (Embedded mapping). This is a complex type (e.g. 
 * Entity) mapped with all its columns inside the table of another entity.
 * 
 * @model
 * @generated
 */
public interface EmbeddedAttribute extends AttributeMetaData {
	
	/**
	 * Our copies of the attributes of the embedded type. Each of these has
	 * {@link AttributeMetaData#getOverrideOf()} set to the original 
	 * attribute of the embedded type and 
	 * {@link AttributeMetaData#getEmbeddedIn()} pointing back to us.
	 * 
	 * @model type="org.eclipse.jsr220orm.metadata.AttributeMetaData" opposite="embeddedIn"
	 * @generated
	 */
	EList getAttributeList();

} // EmbeddedAttribute
