/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.internal.ui.config;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

public class GenericProductActivationPage extends WizardPage {

    private IProject project;
    private PersistenceProperties properties;
    private GenericPropertyComposite propertyPage;
    
    public GenericProductActivationPage(String pageName) {
        super(pageName);
        setTitle(pageName);
    }

    public void setIProject(IProject project) {
        this.project = project;
    }

    public void setPersistenceProperties(PersistenceProperties properties) {
        this.properties = properties;
    }

    public void createControl(Composite parent) {
        propertyPage = new GenericPropertyComposite(parent, SWT.NONE);
        propertyPage.setIProject(project);
        setControl(propertyPage);
    }

    public boolean performFinish() {
        return propertyPage.saveChanges();
    }

}
