/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.generic.internal.ui.config;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jsr220orm.generic.GenericPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSelectionDialog extends ElementTreeSelectionDialog implements
        ISelectionStatusValidator {

    private String[] extentions;
    private boolean acceptFolders;
    private static final IStatus ERROR_STATUS = new Status(IStatus.ERROR,
            GenericPlugin.getPluginId(), IStatus.ERROR, "", null);
    private static final IStatus OK_STATUS = new Status(IStatus.OK,
            GenericPlugin.getPluginId(), IStatus.OK, "", null);

    /**
     * Constructor for JARFileSelectionDialog.
     */
    public FileSelectionDialog(Shell parent) {
        super(parent, new WorkbenchLabelProvider(),
                new WorkbenchContentProvider());
        addFilter(new ViewerFilter() {
            @Override
            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return isValid(element);
            }
        });
        setValidator(this);
    }

    private boolean isValid(Object obj){
        if (obj instanceof IContainer) {
            try {
                IResource[] resources= ((IContainer)obj).members();
                for (int i= 0; i < resources.length; i++) {
                    // recursive! Only show containers that contain an archive
                    if (isValid(resources[i])) {
                        return true;
                    }
                }
            } catch (CoreException e) {
                GenericPlugin.log(e.getStatus());
            }               
        } else if (obj instanceof IFile) {
            IFile file = (IFile) obj;
            String fileName = file.getName();
            int detIndex = fileName.lastIndexOf('.');
            String ext = fileName.substring(detIndex + 1);
            for (int x = 0; x < extentions.length; x++) {
                if (extentions[x].equalsIgnoreCase(ext)) {
                    return true;
                }
            }
        }
        return false;
    }
    
    public void setValidExtentions(String... extentions){
        this.extentions = extentions;
    }

    private boolean isValid(IFile file) {
        String name = file.getName();
        int detIndex = name.lastIndexOf('.');
        String ext = name.substring(detIndex + 1);
        for (int x = 0; x < extentions.length; x++) {
            if (extentions[x].equalsIgnoreCase(ext)) {
                return true;
            }
        }
        return false;
    }

    public IStatus validate(Object[] selection) {
        int nSelected = selection.length;
//        if (nSelected == 0 || (nSelected > 1 && !isAllowMultiple())) {
//            return ERROR_STATUS;
//        }
        for (int i = 0; i < selection.length; i++) {
            Object curr = selection[i];
            if (curr instanceof IContainer) {
                IContainer container = (IContainer) curr;
                if (!acceptFolders) {
                    return ERROR_STATUS;
                }
            } else if (curr instanceof IFile) {
                IFile file = (IFile) curr;
                String fileName = file.getName();
                int detIndex = fileName.lastIndexOf('.');
                String ext = fileName.substring(detIndex + 1);
                for (int x = 0; x < extentions.length; x++) {
                    if (extentions[x].equalsIgnoreCase(ext)) {
                        return OK_STATUS;
                    }
                }
                return ERROR_STATUS;
            }
        }
        return OK_STATUS;
    }
}
