/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: CollectionAttributeItemProvider.java,v 1.15 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.CollectionAttribute;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmTable;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * This is the item provider adapter for a {@link org.eclipse.jsr220orm.metadata.CollectionAttribute} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CollectionAttributeItemProvider
  extends AttributeMetaDataItemProvider
  implements	
    IEditingDomainItemProvider,	
    IStructuredItemContentProvider,	
    ITreeItemContentProvider,	
    IItemLabelProvider,	
    IItemPropertySource		
{
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public CollectionAttributeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addElementTypePropertyDescriptor(object);
			addOneToManyPropertyDescriptor(object);
			addJoinTablePropertyDescriptor(object);
			addSrcJoinPropertyDescriptor(object);
			addDestJoinPropertyDescriptor(object);
			addCascadeTypePropertyDescriptor(object);
			addOrderByPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Element Type feature.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void addElementTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CollectionAttribute_elementType_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CollectionAttribute_elementType_feature", "_UI_CollectionAttribute_type"),
				 MetadataPackage.eINSTANCE.getCollectionAttribute_ElementType(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Join Table feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addJoinTablePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CollectionAttribute_joinTable_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CollectionAttribute_joinTable_feature", "_UI_CollectionAttribute_type"),
				 MetadataPackage.eINSTANCE.getCollectionAttribute_JoinTable(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Src Join feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSrcJoinPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CollectionAttribute_srcJoin_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CollectionAttribute_srcJoin_feature", "_UI_CollectionAttribute_type"),
				 MetadataPackage.eINSTANCE.getCollectionAttribute_SrcJoin(),
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Dest Join feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDestJoinPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CollectionAttribute_destJoin_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CollectionAttribute_destJoin_feature", "_UI_CollectionAttribute_type"),
				 MetadataPackage.eINSTANCE.getCollectionAttribute_DestJoin(),
				 true,
				 null,
				 null,
				 null));
	}

    /**
     * This adds a property descriptor for the Cascade Type feature.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     */
	protected void addCascadeTypePropertyDescriptor(Object object) {
        itemPropertyDescriptors.add
            (new IntOptionDescriptor
                (((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
                 getResourceLocator(),
                 getString("_UI_CollectionAttribute_cascadeType_feature"),
                 getString("_UI_PropertyDescriptor_description", "_UI_CollectionAttribute_cascadeType_feature", "_UI_CollectionAttribute_type"),
                 MetadataPackage.eINSTANCE.getCollectionAttribute_CascadeType(),
                 true,
                 ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE,
                 null,
                 null));
    }

	/**
	 * This adds a property descriptor for the Order By feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addOrderByPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CollectionAttribute_orderBy_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CollectionAttribute_orderBy_feature", "_UI_CollectionAttribute_type"),
				 MetadataPackage.eINSTANCE.getCollectionAttribute_OrderBy(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(MetadataPackage.eINSTANCE.getCollectionAttribute_ElementType());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getCollectionAttribute_JoinTable());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getCollectionAttribute_SrcJoin());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getCollectionAttribute_DestJoin());
			childrenFeatures.add(MetadataPackage.eINSTANCE.getCollectionAttribute_OrderBy());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This adds a property descriptor for the One To Many feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addOneToManyPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_CollectionAttribute_oneToMany_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_CollectionAttribute_oneToMany_feature", "_UI_CollectionAttribute_type"),
				 MetadataPackage.eINSTANCE.getCollectionAttribute_OneToMany(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				 null,
				 null));
	}

	public Object getImage(Object object) {
		CollectionAttribute amd = (CollectionAttribute)object;
		String s;
		if (amd.isNonPersistent()) {
			s = "NotPersistent16";
		} else {
			AttributeMetaData mb = amd.getMappedBy();
			if (mb != null) {
				if (mb instanceof CollectionAttribute) {
					s = "ManyToMany16";
				} else {
					s = "OneToMany16";
				}
			} else {
				if (amd.isOneToMany()) {
					s = "JoinTable16";
				} else {
					s = "ManyToMany16";
				}
			} 
		}
        return getResourceLocator().getImage("full/obj16/" + s);
    }

    /**
     * This returns the label text for the adapted class.
     */
	public String getText(Object object) {
    	StringBuffer s = new StringBuffer();
    	s.append(super.getText(object));
    	CollectionAttribute amd = (CollectionAttribute)object;
    	s.append('<');
    	TypeMetaData et = amd.getElementType();
    	if (et == null) {
    		s.append('?');
    	} else {
    		s.append(et.getShortName());
    	}
    	s.append('>');
    	AttributeMetaData mb = amd.getMappedBy();
    	if (mb != null) {
    		s.append(" : mapped by ");
    		s.append(mb.getName());
    	} else {
    		OrmTable table = amd.getJoinTable();
    		if (table != null) {
    			s.append(" : ");
    			s.append(table.getName());
    		}
    	}
    	return s.toString();
    }

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(CollectionAttribute.class)) {
			case MetadataPackage.COLLECTION_ATTRIBUTE__ONE_TO_MANY:
			case MetadataPackage.COLLECTION_ATTRIBUTE__CASCADE_TYPE:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case MetadataPackage.COLLECTION_ATTRIBUTE__ELEMENT_TYPE:
			case MetadataPackage.COLLECTION_ATTRIBUTE__JOIN_TABLE:
			case MetadataPackage.COLLECTION_ATTRIBUTE__SRC_JOIN:
			case MetadataPackage.COLLECTION_ATTRIBUTE__DEST_JOIN:
			case MetadataPackage.COLLECTION_ATTRIBUTE__ORDER_BY:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
	 * @generated
	 */
  public ResourceLocator getResourceLocator() {
		return MetadataEditPlugin.INSTANCE;
	}

}
