/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddPersistenceWizard extends Wizard implements INewWizard {

    private IProject project;
    private AddPersistencePage addPersistencePage = new AddPersistencePage();

    public AddPersistenceWizard() {
        this(null);
    }
    
    public AddPersistenceWizard(IProject project) {
        super();
        this.project = project;
        setForcePreviousAndNextButtons(true);
    }

    /**
     * Creates the wizard's pages lazily.
     */
    public void addPages() {
        addPersistencePage.setIProject(project);
        addPage(addPersistencePage);
    }

    public boolean performFinish() {
        return addPersistencePage.performFinish();
    }

    public boolean canFinish() {
        return addPersistencePage.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if(project != null){
            return;
        }
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object selectedElement= selection.getFirstElement();
        
        String projPath= null;
        
        if (selectedElement instanceof IResource) {
            project = ((IResource)selectedElement).getProject();
        } else if (selectedElement instanceof IJavaElement) {
            IJavaProject jproject= ((IJavaElement)selectedElement).getJavaProject();
            if (jproject != null) {
                project = jproject.getProject();
            }
        }   
    }
}
