/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping.composite;

import java.util.List;

import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.options.IIntOption;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.ui.internal.mapping.AttributeBook;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AttributeMappingGroup implements SelectionListener {

	private Composite group;
	private AttributeMetaData attributeMetaData;
    private FormToolkit toolkit;
    private AttributeBook attributeBook;

	public AttributeMappingGroup(AttributeBook book) {
        this.attributeBook = book;
    }
     
    public void createControl(final Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
		group = toolkit.createComposite(parent);
        RowLayout mappingGroupLayout = new RowLayout(SWT.HORIZONTAL);
        mappingGroupLayout.wrap = true;
		group.setLayout(mappingGroupLayout);
        group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	}
    
	public Composite getComposite() {
		return group;
	}

	public void setMetaDataElement(AttributeMetaData attributeMetaData) {
		this.attributeMetaData = attributeMetaData;
		if (attributeMetaData == null) {
            Control[] children = group.getChildren();
            for (int x = children.length; x <= 0; x++) {
                children[x].dispose();
            }
			return;
		}
		List mappings = null;
        IIntOption currentMapping = null;
		IEntityModelManager manager = (IEntityModelManager) 
        attributeMetaData.adapt(IEntityModelManager.class);
		if (manager != null) {
			mappings = manager
					.getPossibleAttributeMappings(attributeMetaData);
			currentMapping = manager.getAttributeMapping(attributeMetaData);
		}
    	if (mappings == null) {
    		mappings = ECollections.EMPTY_ELIST;
    	}
    	Control[] children = group.getChildren();
    	for (int x = children.length; x < mappings.size(); x++) {
    		Button button = toolkit.createButton(group, "", SWT.RADIO);
    	}
    	for (int x = mappings.size(); x < children.length; x++) {
    		children[x].dispose();
    	}
    	children = group.getChildren();
    	for (int x = 0; x < children.length; x++) {
    		Button button = (Button) children[x];
            IIntOption mapping = (IIntOption) mappings.get(x);
    		button.removeSelectionListener(this);
    		button.setData(mapping);
    		boolean isSelected = mapping.equals(currentMapping);
            button.setSelection(isSelected);
    
    		String text = mapping.getText();
    		Image image = ExtendedImageRegistry.INSTANCE.getImage(mapping.getImage());
    		button.setImage((Image) image);
            button.setText(text);
    		button.addSelectionListener(this);
    	}
        group.layout();
	}

	public void widgetSelected(SelectionEvent e) {
        Button button = (Button) e.getSource();
        IIntOption mapping = (IIntOption) button.getData();
        IEntityModelManager manager = (IEntityModelManager) 
        attributeMetaData.adapt(IEntityModelManager.class);
        if (manager != null && mapping != null) {
            manager.setAttributeMapping(attributeMetaData, mapping);
        }
        attributeBook.setAttributeMetaData(attributeMetaData);
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

}
