/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.binding;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EmfWidgetBinding implements IEmfWidgetBinding {
    
    IEmfWidgetBinding binding;
    
    public void bind(AdapterFactory adapterFactory, Widget widget, int featureId) {
        if(widget instanceof CCombo){
            binding = new EmfComboBinding();
        }else if(widget instanceof Text){
            binding = new EmfTextBinding();
        }else if(widget instanceof Button){
            binding = new EmfCheckButtonBinding();
        }
        binding.bind(adapterFactory, widget, featureId);
    }

    public void setEObject(EObject notifier) {
        binding.setEObject(notifier);
    }
}
