/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.adapters;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jsr220orm.ui.internal.selection.ITextEditorSelectionProvider;
import org.eclipse.jsr220orm.ui.internal.selection.PersistenceSelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class PersistenceSelectionAdapterFactory implements IAdapterFactory {

    private ITextEditorSelectionProvider provider = new ITextEditorSelectionProvider();
    private ITextEditor lastEditor;
    
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ITextEditor editor = (ITextEditor) adaptableObject;
        if(editor == lastEditor){
            return provider;
        }
        ICompilationUnit unit = isJavaEditor(editor);
        if(unit != null){
            lastEditor = editor;
            provider.uninstallITextEditor();
            provider.installITextEditor(editor, unit);
            return provider;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[] { PersistenceSelectionProvider.class };
    }

    private ICompilationUnit isJavaEditor(ITextEditor editor) {
        IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
        IEditorInput editorInput = editor.getEditorInput();
        ICompilationUnit unit = manager.getWorkingCopy(editorInput);
//        if (unit == null) {
//            try {
//                manager.connect(editorInput);
//                unit = manager.getWorkingCopy(editorInput);
//                return unit;
//            } catch (CoreException e1) {
//                return null;
//            } finally {
//                manager.disconnect(editorInput);
//            }
//        } else {
            return unit;
//        }
    }
}
