/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.internal.product;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/**
 * Singleton maintaining a registry of all installed ORM product plugins.
 */
public class OrmProductRegistry {

	public static final OrmProductRegistry INSTANCE = new OrmProductRegistry();

	private Map ormProductMap = new TreeMap(); // product id -> OrmProduct

	private OrmProductRegistry() {
		IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(
				"org.eclipse.jsr220orm", "product");
		if (extensionPoint != null) {
			IExtension[] extensions = extensionPoint.getExtensions();
			for (int i = 0; i < extensions.length; ++i) {
				IExtension extension = extensions[i];
				IConfigurationElement[] configElements = extension
						.getConfigurationElements();
				for (int j = 0; j < configElements.length; ++j) {
					IConfigurationElement configurationElement = configElements[j];
					if (configurationElement.getName().equals("product")) {
						String id = configurationElement.getAttribute("id");
						String name = configurationElement.getAttribute("name");
						String version = configurationElement
								.getAttribute("version");
						String vendor = configurationElement
								.getAttribute("vendor");
						String emmName = configurationElement
								.getAttribute("entityModelManager");
						String icon = configurationElement.getAttribute("icon");

						OrmProduct ormProduct = new OrmProduct(id, name,
								version, vendor, emmName, icon, extension
										.getNamespace());
						ormProductMap.put(id, ormProduct);
                        IConfigurationElement[] params = configurationElement.getChildren();
                        for(int p = 0; p < params.length; p++){
                            IConfigurationElement param = params[p];
                            String key = param.getAttribute("key");
                            String value = param.getAttribute("value");
                            ormProduct.getProperties().put(key, value);
                        }
					}
				}
			}
		}
	}

	/**
	 * Get an OrmProduct instance for each ORM plugin.
	 */
	public Collection getOrmProducts() {
		return ormProductMap.values();
	}

	/**
	 * Get the OrmProduct for the productId or null if none found.
	 */
	public OrmProduct getOrmProductById(String productId) {
		return (OrmProduct) ormProductMap.get(productId);
	}

	public boolean containtsProductKey(String prodKey) {
		return ormProductMap.containsKey(prodKey);
	}
}
