/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.views.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.nature.OrmNatureEvent;
import org.eclipse.jsr220orm.core.nature.OrmNatureListener;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.metadata.provider.MetadataItemProviderAdapterFactory;
import org.eclipse.jsr220orm.metadata.util.MetadataAdapterFactory;
import org.eclipse.jsr220orm.ui.internal.views.provider.EStructuralFeatureTreeItem;
import org.eclipse.swt.widgets.Display;

public class ModelContentProvider
implements ITreeContentProvider,
INotifyChangedListener,
OrmNatureListener,
IResourceChangeListener {
    private AdapterFactoryContentProvider contentProvider;
    private MetadataAdapterFactory factory = new MetadataItemProviderAdapterFactory();
    private Viewer viewer;
    static /* synthetic */ Class class$0;

    public ModelContentProvider(ComposedAdapterFactory adapterFactory) {
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)inputElement;
            workspaceRoot.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            return workspaceRoot.getProjects();
        }
        if (inputElement instanceof IProject) {
            IProject project = (IProject)inputElement;
            OrmNature nature = null;
            try {
                nature = (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
            }
            catch (CoreException coreException) {
                return null;
            }
            if (nature == null) {
                return null;
            }
            nature.addOrmNatureListener((OrmNatureListener)this);
            OrmProject ormProject = nature.getActiveOrmProject();
            return this.contentProvider.getElements((Object)ormProject.getModel());
        }
        if (inputElement instanceof OrmProject) {
            OrmProject ormProject = (OrmProject)inputElement;
            return this.contentProvider.getElements((Object)ormProject.getModel());
        }
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        if (inputElement instanceof EStructuralFeatureTreeItem) {
            EStructuralFeatureTreeItem ref = (EStructuralFeatureTreeItem)inputElement;
            Collection children = ref.getChildren();
            if (children != null) {
                return children.toArray();
            }
            return null;
        }
        if (inputElement instanceof Notifier) {
            Notifier notifier = (Notifier)inputElement;
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.factory.createAdapter(notifier);
            try {
                Method method = adapter.getClass().getMethod("getChildrenFeatures", Object.class);
                Object ret = method.invoke((Object)adapter, notifier);
                Collection children = (Collection)ret;
                ArrayList<EStructuralFeatureTreeItem> newList = new ArrayList<EStructuralFeatureTreeItem>(children.size());
                for (EStructuralFeature ref : children) {
                    EStructuralFeatureTreeItem structuralFeatureTreeItem = new EStructuralFeatureTreeItem((EObject)notifier, ref);
                    newList.add(structuralFeatureTreeItem);
                }
                return newList.toArray();
            }
            catch (Exception exception) {
                return this.contentProvider.getElements(inputElement);
            }
        }
        return this.contentProvider.getElements(inputElement);
    }

    public void dispose() {
        this.viewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.contentProvider.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof OrmProject) {
            OrmProject ormProject = (OrmProject)element;
            return ormProject.getIProject();
        }
        Object parent = this.contentProvider.getParent(element);
        if (parent instanceof EntityModel) {
            return null;
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void notifyChanged(Notification notification) {
        this.contentProvider.notifyChanged(notification);
    }

    public void projectActivated(OrmNatureEvent e) {
        this.refreshElement(e.getNature().getProject(), true, true);
    }

    public void projectDeactivated(OrmNatureEvent e) {
        this.refreshElement(e.getNature().getProject(), true, true);
    }

    public void ormNatureRemoved(OrmNatureEvent e) {
        this.refreshElement(e.getNature().getProject(), false, true);
    }

    public void refreshElement(Object element, boolean updateLabels, boolean refreshContent) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            RefreshRunner viewerRefresh = new RefreshRunner(this.viewer, element, updateLabels, refreshContent);
            Display d = this.viewer.getControl().getDisplay();
            if (d != Display.getCurrent()) {
                d.asyncExec((Runnable)viewerRefresh);
            } else {
                viewerRefresh.run();
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        System.out.println("OutlineContentProvider.resourceChanged(): " + event);
    }

    class RefreshRunner
    implements Runnable {
        Viewer viewer;
        Object element;
        boolean updateLabels;
        boolean refreshContent;

        public RefreshRunner(Viewer viewer, Object element, boolean updateLabels, boolean refreshContent) {
            this.viewer = viewer;
            this.element = element;
            this.updateLabels = updateLabels;
            this.refreshContent = refreshContent;
        }

        public void run() {
            if (this.viewer instanceof StructuredViewer) {
                StructuredViewer structuredViewer = (StructuredViewer)this.viewer;
                if (this.element != null) {
                    if (this.refreshContent) {
                        structuredViewer.refresh(this.element, this.updateLabels);
                    } else if (this.updateLabels) {
                        structuredViewer.update(this.element, null);
                    }
                } else {
                    structuredViewer.refresh(this.updateLabels);
                }
            } else {
                this.viewer.refresh();
            }
        }
    }
}

