/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.properties;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jsr220orm.core.internal.product.OrmProduct;
import org.eclipse.jsr220orm.core.internal.product.OrmProductRegistry;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.nature.OrmNatureUtils;
import org.eclipse.jsr220orm.core.nature.PersistenceProperties;
import org.eclipse.jsr220orm.core.util.RdbUtils;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AddConnectionAction;

public class SelectProductComposite
extends Composite {
    private static final String NONE = "<NONE>";
    private IProject project;
    private CLabel lPersistenceProduct = null;
    private CCombo tPersistenceProduct = null;
    private Composite cOrmOptions = null;
    private Link lConnection = null;
    private CCombo tConnection = null;
    private CLabel lSchema = null;
    private CCombo tSchema = null;
    private CLabel lDataBase = null;
    private CCombo tDataBase = null;
    private CLabel lVersion = null;
    private CCombo tVersion = null;
    private boolean productChoice;

    public SelectProductComposite(Composite parent, boolean productChoice) {
        super(parent, 0);
        this.initialize(productChoice);
    }

    private void initialize(boolean productChoice) {
        this.productChoice = productChoice;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.lPersistenceProduct = new CLabel((Composite)this, 0);
        this.lPersistenceProduct.setText("Persistence Product");
        this.tPersistenceProduct = new CCombo((Composite)this, 2056);
        this.tPersistenceProduct.setLayoutData((Object)gridData);
        this.tPersistenceProduct.setEnabled(productChoice);
        this.createCOrmOptions();
        this.setSize(new Point(507, 268));
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) throws CoreException, IOException {
        OrmProduct ormProduct;
        this.project = project;
        boolean hasProject = project != null;
        this.tPersistenceProduct.setEnabled(hasProject && this.productChoice);
        this.lConnection.setEnabled(hasProject);
        this.tConnection.setEnabled(hasProject);
        this.tSchema.setEnabled(hasProject);
        this.tDataBase.setEnabled(hasProject);
        this.tVersion.setEnabled(hasProject);
        if (!hasProject) {
            return;
        }
        PersistenceProperties properties = new PersistenceProperties(project);
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        Iterator products = ddr.getProducts();
        this.tDataBase.removeAll();
        while (products.hasNext()) {
            String prodName = (String)products.next();
            this.tDataBase.add(prodName);
        }
        this.tDataBase.setText(properties.getDatabaseName());
        this.loadVersions();
        this.tVersion.setText(properties.getDatabaseVersion());
        this.tDataBase.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProductComposite.this.loadVersions();
            }
        });
        this.tPersistenceProduct.removeAll();
        String activeProductId = properties.getPersistenceProduct();
        this.tPersistenceProduct.setText(NONE);
        if (activeProductId != null && (ormProduct = OrmProductRegistry.INSTANCE.getOrmProductById(activeProductId)) != null) {
            this.tPersistenceProduct.setText(ormProduct.getName());
        }
        this.tPersistenceProduct.add(NONE);
        ArrayList ormProducts = new ArrayList(OrmProductRegistry.INSTANCE.getOrmProducts());
        for (OrmProduct product : ormProducts) {
            String name = product.getName();
            this.tPersistenceProduct.add(name);
            this.tPersistenceProduct.setData(name, (Object)product);
        }
        this.loadSchemas(properties.getConnectionName());
        String schemaName = properties.getSchemaName();
        if (schemaName != null) {
            this.tSchema.setText(schemaName);
        } else {
            this.tSchema.setText(NONE);
        }
        this.tConnection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProductComposite.this.loadSchemas();
                ConnectionInfo activeConnection = (ConnectionInfo)SelectProductComposite.this.tConnection.getData(SelectProductComposite.this.tConnection.getText());
                if (activeConnection != null) {
                    DatabaseDefinition dd = activeConnection.getDatabaseDefinition();
                    SelectProductComposite.this.tDataBase.setText(dd.getProduct());
                    SelectProductComposite.this.tVersion.setText(dd.getVersion());
                }
            }
        });
    }

    private void loadVersions() {
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        this.tVersion.removeAll();
        Iterator versions = ddr.getVersions(this.tDataBase.getText());
        while (versions.hasNext()) {
            String version = (String)versions.next();
            this.tVersion.add(version);
            this.tVersion.setText(version);
        }
    }

    private void loadSchemas(String connectionName) {
        this.tConnection.removeAll();
        if (connectionName != null) {
            this.tConnection.setText(connectionName);
        } else {
            this.tConnection.setText(NONE);
        }
        this.tConnection.add(NONE);
        ConnectionInfo[] connections = RdbUtils.getRdbConnections();
        if (connections != null) {
            int x = 0;
            while (x < connections.length) {
                ConnectionInfo connection = connections[x];
                String name = connection.getName();
                this.tConnection.add(name);
                this.tConnection.setData(name, (Object)connection);
                ++x;
            }
        }
        this.loadSchemas();
    }

    private void loadSchemas() {
        ConnectionInfo activeConnection = (ConnectionInfo)this.tConnection.getData(this.tConnection.getText());
        this.tSchema.removeAll();
        this.tSchema.setText(NONE);
        if (activeConnection == null) {
            this.tSchema.setEnabled(false);
        } else {
            List schemas;
            this.tSchema.setEnabled(true);
            this.tSchema.add(NONE);
            try {
                Database database;
                Schema activeSchema;
                OrmNature nature;
                if (this.project.hasNature("org.eclipse.jsr220orm.core.nature") && (nature = (OrmNature)this.project.getNature("org.eclipse.jsr220orm.core.nature")) != null && (activeSchema = nature.getActiveSchema()) != null && (database = activeSchema.getDatabase()) != null && database.equals(activeConnection.getCachedDatabase())) {
                    this.tSchema.setText(activeSchema.getName());
                }
            }
            catch (CoreException e) {
                OrmUiPlugin.logException(e, "Error loading schema.", this.getShell());
            }
            if ((schemas = OrmNature.getSchemas(null, (ConnectionInfo)activeConnection, null, null)) != null) {
                for (Schema schema : schemas) {
                    String name = schema.getName();
                    this.tSchema.add(name);
                    this.tSchema.setData(name, (Object)schema);
                }
            }
        }
    }

    private void createCOrmOptions() {
        GridData gridData6 = new GridData();
        gridData6.widthHint = 200;
        GridData gridData5 = new GridData();
        gridData5.widthHint = 50;
        GridData gridData4 = new GridData();
        gridData4.widthHint = 150;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 200;
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 2;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalSpan = 2;
        gridData1.grabExcessHorizontalSpace = true;
        this.cOrmOptions = new Composite((Composite)this, 0);
        this.cOrmOptions.setLayoutData((Object)gridData1);
        this.cOrmOptions.setLayout((Layout)gridLayout1);
        this.lDataBase = new CLabel(this.cOrmOptions, 0);
        this.lDataBase.setText("Database");
        this.tDataBase = new CCombo(this.cOrmOptions, 2056);
        this.tDataBase.setLayoutData((Object)gridData6);
        this.lVersion = new CLabel(this.cOrmOptions, 0);
        this.lVersion.setText("Version");
        this.tVersion = new CCombo(this.cOrmOptions, 2056);
        this.tVersion.setLayoutData((Object)gridData5);
        this.lConnection = new Link(this.cOrmOptions, 0);
        this.lConnection.setText("<a>Connection</a>");
        this.lConnection.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AddConnectionAction action = new AddConnectionAction();
                action.run(null);
                SelectProductComposite.this.loadSchemas(null);
            }
        });
        this.tConnection = new CCombo(this.cOrmOptions, 2056);
        this.tConnection.setEditable(false);
        this.tConnection.setLayoutData((Object)gridData2);
        this.lSchema = new CLabel(this.cOrmOptions, 0);
        this.lSchema.setText("Schema");
        this.tSchema = new CCombo(this.cOrmOptions, 2056);
        this.tSchema.setLayoutData((Object)gridData4);
    }

    public boolean hasProducts() {
        return this.tPersistenceProduct.getItemCount() > 1;
    }

    public void clearSelection() {
        this.tPersistenceProduct.setText(NONE);
        this.tConnection.setText(NONE);
    }

    public String getSelectedProductId() {
        OrmProduct product = this.getSelectedProduct();
        if (product != null) {
            return product.getId();
        }
        return null;
    }

    public OrmProduct getSelectedProduct() {
        return (OrmProduct)this.tPersistenceProduct.getData(this.tPersistenceProduct.getText());
    }

    public ConnectionInfo getSelectedConnection() {
        return (ConnectionInfo)this.tConnection.getData(this.tConnection.getText());
    }

    public String getSelectedSchema() {
        Schema schema = (Schema)this.tSchema.getData(this.tSchema.getText());
        if (schema != null) {
            return schema.getName();
        }
        return null;
    }

    public boolean setProductOnProject() {
        try {
            ConnectionInfo selectedConnection;
            OrmProduct selectedProduct = this.getSelectedProduct();
            PersistenceProperties properties = new PersistenceProperties(this.project);
            if (selectedProduct != null) {
                properties.getProperties().putAll((Map<?, ?>)selectedProduct.getProperties());
                properties.setPersistenceProduct(selectedProduct.getId());
            }
            if ((selectedConnection = this.getSelectedConnection()) != null) {
                properties.setConnectionName(selectedConnection.getName());
                properties.setConnectionUserName(selectedConnection.getUserName());
                properties.setConnectionPassword(selectedConnection.getPassword());
            }
            properties.setSchemaName(this.getSelectedSchema());
            properties.setDatabaseName(this.tDataBase.getText());
            properties.setDatabaseVersion(this.tVersion.getText());
            properties.save();
            if (selectedProduct != null) {
                OrmNatureUtils.setActiveProduct((IProject)this.project, (String)selectedProduct.getId());
            }
            return true;
        }
        catch (Exception e) {
            OrmUiPlugin.logException(e, "Could not set Persistence Product", this.getShell());
            return false;
        }
    }

    public void flushProps() {
        try {
            ConnectionInfo selectedConnection;
            OrmProduct selectedProduct = this.getSelectedProduct();
            PersistenceProperties properties = new PersistenceProperties(this.project);
            if (selectedProduct != null) {
                properties.getProperties().putAll((Map<?, ?>)selectedProduct.getProperties());
                properties.setPersistenceProduct(selectedProduct.getId());
            }
            if ((selectedConnection = this.getSelectedConnection()) != null) {
                properties.setConnectionName(selectedConnection.getName());
                properties.setConnectionUserName(selectedConnection.getUserName());
                properties.setConnectionPassword(selectedConnection.getPassword());
            }
            properties.setSchemaName(this.getSelectedSchema());
            properties.setDatabaseName(this.tDataBase.getText());
            properties.setDatabaseVersion(this.tVersion.getText());
        }
        catch (Exception exception) {}
    }
}

