/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.figure.TableFigure;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ColumnEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.ColumnListEditPart;
import org.eclipse.jsr220orm.ui.internal.diagram.er.part.TableEditPart;

public class DirectedGraphLayoutVisitor {
    private Map partToNodesMap;
    private CompoundDirectedGraph graph;
    private CompoundDirectedGraphLayout directedGraphLayout = new CompoundDirectedGraphLayout();

    public void layoutDiagram(ColumnListEditPart diagram) {
        try {
            this.partToNodesMap = new HashMap();
            this.graph = new CompoundDirectedGraph();
            this.graph.setDefaultPadding(new Insets(0));
            this.addNodes(diagram);
            if (this.graph.nodes.size() > 0) {
                this.addEdges(diagram);
                this.directedGraphLayout.visit((DirectedGraph)this.graph);
                this.applyResults(diagram);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addNodes(ColumnListEditPart diagram) {
        diagram.getFigure();
        int i = 0;
        while (i < diagram.getChildren().size()) {
            TableEditPart tp = (TableEditPart)((Object)diagram.getChildren().get(i));
            this.addNodes(tp);
            ++i;
        }
    }

    protected void addNodes(TableEditPart tablePart) {
        Subgraph n = new Subgraph((Object)tablePart);
        Dimension preferredSize = tablePart.getFigure().getPreferredSize();
        n.width = preferredSize.width;
        n.height = preferredSize.height;
        n.setPadding(new Insets(20));
        this.partToNodesMap.put(tablePart, n);
        this.graph.nodes.add((Object)n);
        List cols = tablePart.getChildren();
        int i = 0;
        while (i < cols.size()) {
            Object object = cols.get(i);
            if (object instanceof ColumnEditPart) {
                ColumnEditPart col = (ColumnEditPart)((Object)object);
                this.addNodes(n, col);
            }
            ++i;
        }
    }

    protected void addNodes(Subgraph table, ColumnEditPart column) {
        Node n = new Node((Object)column);
        n.setParent(table);
        column.getFigure().getBounds();
        n.width = 0;
        n.height = 0;
        n.setPadding(new Insets(0));
        table.addMember(n);
        this.partToNodesMap.put(column, n);
        Edge e = new Edge(null, (Node)table, n);
        this.graph.edges.add((Object)e);
        this.graph.nodes.add((Object)n);
    }

    protected void addEdges(ColumnListEditPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            TableEditPart tablePart = (TableEditPart)((Object)diagram.getChildren().get(i));
            this.addEdges(tablePart);
            ++i;
        }
    }

    protected void addEdges(TableEditPart tablePart) {
        List cols = tablePart.getChildren();
        int i = 0;
        while (i < cols.size()) {
            Object object = cols.get(i);
            if (object instanceof ColumnEditPart) {
                ColumnEditPart col = (ColumnEditPart)((Object)object);
                List outgoing = col.getSourceConnections();
                int x = 0;
                while (x < outgoing.size()) {
                    ConnectionEditPart joinPair = (ConnectionEditPart)col.getSourceConnections().get(x);
                    this.addEdges(joinPair);
                    ++x;
                }
            }
            ++i;
        }
    }

    protected void addEdges(ConnectionEditPart joinPair) {
        Node source = (Node)this.partToNodesMap.get(joinPair.getSource());
        Node target = (Node)this.partToNodesMap.get(joinPair.getTarget());
        if (source == null || target == null) {
            return;
        }
        Edge e = new Edge((Object)joinPair, source, target);
        e.weight = 2;
        this.graph.edges.add((Object)e);
        this.partToNodesMap.put(joinPair, e);
    }

    protected void applyResults(ColumnListEditPart diagram) {
        this.applyChildrenResults(diagram);
    }

    protected void applyChildrenResults(ColumnListEditPart diagram) {
        int i = 0;
        while (i < diagram.getChildren().size()) {
            TableEditPart tablePart = (TableEditPart)((Object)diagram.getChildren().get(i));
            this.applyResults(tablePart);
            ++i;
        }
    }

    protected void applyOwnResults(ColumnListEditPart diagram) {
    }

    public void applyResults(TableEditPart tablePart) {
        Subgraph n = (Subgraph)this.partToNodesMap.get((Object)tablePart);
        TableFigure tableFigure = (TableFigure)tablePart.getFigure();
        Insets insets = tableFigure.getParent().getInsets();
        tableFigure.setLocation(new Point(n.x + insets.left, n.y + insets.top));
        Dimension preferredSize = tableFigure.getPreferredSize();
        tableFigure.setSize(preferredSize);
        List cols = tablePart.getChildren();
        int i = 0;
        while (i < cols.size()) {
            Object object = cols.get(i);
            if (object instanceof ColumnEditPart) {
                ColumnEditPart col = (ColumnEditPart)((Object)object);
                List outgoing = col.getSourceConnections();
                int x = 0;
                while (x < outgoing.size()) {
                    AbstractConnectionEditPart joinPair = (AbstractConnectionEditPart)outgoing.get(x);
                    this.applyResults(joinPair);
                    ++x;
                }
            }
            ++i;
        }
    }

    protected void applyResults(AbstractConnectionEditPart relationshipPart) {
        Edge e = (Edge)this.partToNodesMap.get(relationshipPart);
        if (e == null) {
            return;
        }
        NodeList nodes = e.vNodes;
        PolylineConnection conn = (PolylineConnection)relationshipPart.getConnectionFigure();
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                if (e.isFeedback) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                } else {
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                }
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }
}

