/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.figure;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jsr220orm.ui.internal.diagram.EditableLabel;
import org.eclipse.jsr220orm.ui.internal.diagram.er.figure.DropShadowBorder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;

public class TableFigure
extends Figure {
    public static Color classColor = new Color(null, 255, 255, 255);
    public static final Color TOP_COLOR = new Color(null, 250, 250, 230);
    private EditableLabel nameLabel = new EditableLabel();
    private IFigure contentPane;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;

    public TableFigure() {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(1);
        layout.setStretchMinorAxis(true);
        layout.setSpacing(2);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new DropShadowBorder());
        this.nameLabel.setBorder((Border)new BottomLineBorder());
        this.setBackgroundColor(TOP_COLOR);
        this.setOpaque(false);
        this.add((IFigure)this.nameLabel);
        this.nameLabel.setOpaque(true);
        this.nameLabel.setBackgroundColor(TOP_COLOR);
        this.contentPane = new Figure(){

            protected void paintFigure(Graphics graphics) {
                graphics.pushState();
                graphics.setForegroundColor(TOP_COLOR);
                graphics.setBackgroundColor(ColorConstants.white);
                Rectangle bounds2 = new Rectangle(this.getBounds());
                graphics.fillGradient(bounds2, true);
                graphics.popState();
            }
        };
        new ToolbarLayout(false);
        layout.setMinorAlignment(1);
        layout.setStretchMinorAxis(true);
        layout.setSpacing(0);
        this.contentPane.setLayoutManager((LayoutManager)layout);
        this.add(this.contentPane);
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    public void setName(String name) {
        this.nameLabel.setText(name);
    }

    public void setToolTipText(String toolTipText) {
        if (toolTipText == null || toolTipText.trim().length() == 0) {
            this.setToolTip(null);
        } else {
            Label label = new Label(toolTipText);
            label.setBackgroundColor(ColorConstants.tooltipBackground);
            label.setForegroundColor(ColorConstants.tooltipForeground);
            this.setToolTip((IFigure)label);
        }
    }

    public void setNameVisible(boolean visible) {
        this.nameLabel.setVisible(visible);
    }

    public EditableLabel getNameLabel() {
        return this.nameLabel;
    }

    public void setSelected(boolean selected) {
        this.nameLabel.setSelected(selected);
        this.repaint();
    }

    protected void paintFigured(Graphics graphics) {
        graphics.pushState();
        graphics.setForegroundColor(ColorConstants.lightBlue);
        graphics.setBackgroundColor(ColorConstants.white);
        Rectangle bounds2 = new Rectangle(this.getBounds());
        graphics.fillGradient(bounds2.crop(this.getBorder().getInsets((IFigure)this)), true);
        bounds2.height = this.nameLabel.getBounds().height;
        graphics.setForegroundColor(ColorConstants.white);
        graphics.setBackgroundColor(ColorConstants.lightBlue);
        graphics.fillGradient(bounds2.crop(this.getBorder().getInsets((IFigure)this)), true);
        graphics.popState();
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        int i;
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error((int)5);
            }
            if (PlatformUI.getWorkbench().getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
            i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    SWT.error((int)5);
                }
                if (i > 0 && percents[i] < percents[i - 1]) {
                    SWT.error((int)5);
                }
                ++i;
            }
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colors.length];
            i = 0;
            while (i < colors.length) {
                this.gradientColors[i] = colors[i] != null ? colors[i] : this.getBackgroundColor();
                ++i;
            }
            this.gradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.gradientPercents[i] = percents[i];
                ++i;
            }
            this.gradientVertical = vertical;
        }
    }

    protected void paintFigures(Graphics graphics) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        if (this.gradientColors != null) {
            Color oldBackground = graphics.getBackgroundColor();
            if (this.gradientColors.length == 1) {
                if (this.gradientColors[0] != null) {
                    graphics.setBackgroundColor(this.gradientColors[0]);
                }
                graphics.fillRectangle(0, 0, rect.width, rect.height);
            } else {
                Color oldForeground = graphics.getForegroundColor();
                Color lastColor = this.gradientColors[0];
                if (lastColor == null) {
                    lastColor = oldBackground;
                }
                int pos = 0;
                int i = 0;
                while (i < this.gradientPercents.length) {
                    graphics.setForegroundColor(lastColor);
                    lastColor = this.gradientColors[i + 1];
                    if (lastColor == null) {
                        lastColor = oldBackground;
                    }
                    graphics.setBackgroundColor(lastColor);
                    if (this.gradientVertical) {
                        int gradientHeight = this.gradientPercents[i] * rect.height / 100 - pos;
                        graphics.fillGradient(0, pos, rect.width, gradientHeight, true);
                        pos += gradientHeight;
                    } else {
                        int gradientWidth = this.gradientPercents[i] * rect.width / 100 - pos;
                        graphics.fillGradient(pos, 0, gradientWidth, rect.height, false);
                        pos += gradientWidth;
                    }
                    ++i;
                }
                if (this.gradientVertical && pos < rect.height) {
                    graphics.setBackgroundColor(this.getBackgroundColor());
                    graphics.fillRectangle(0, pos, rect.width, rect.height - pos);
                }
                if (!this.gradientVertical && pos < rect.width) {
                    graphics.setBackgroundColor(this.getBackgroundColor());
                    graphics.fillRectangle(pos, 0, rect.width - pos, rect.height);
                }
                graphics.setForegroundColor(oldForeground);
            }
            graphics.setBackgroundColor(oldBackground);
        } else {
            Rectangle bounds2 = new Rectangle(this.getBounds());
            graphics.fillRectangle(bounds2.crop(this.getBorder().getInsets((IFigure)this)));
        }
    }

    public class BottomLineBorder
    extends AbstractBorder {
        Insets insets = new Insets(0, 0, 1, 0);

        public Insets getInsets(IFigure figure) {
            return this.insets;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setForegroundColor(ColorConstants.black);
            tempRect.setBounds(BottomLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            int y = BottomLineBorder.tempRect.y + BottomLineBorder.tempRect.height - 1;
            graphics.drawLine(BottomLineBorder.tempRect.x, y, BottomLineBorder.tempRect.x + BottomLineBorder.tempRect.width, y);
        }
    }
}

