/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.diagram.er.figure;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.diagram.EditableLabel;
import org.eclipse.jsr220orm.ui.internal.diagram.er.figure.EmptyBorder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ColumnFigure
extends Figure {
    private static final Image pkImage = OrmUiPlugin.getImageDescriptor("icons/ER_PrimaryKey.png").createImage();
    private static final Image emptyImage = OrmUiPlugin.getImageDescriptor("icons/empty16.png").createImage();
    private EditableLabel nameLabel = new EditableLabel();
    private Label typeFigure = new Label();
    private Map rdbCols = new HashMap();
    private Map ormCols = new HashMap();
    private boolean selected;
    private boolean connected;

    public ColumnFigure(Map ormCols, Map rdbCols, boolean connected) {
        this.ormCols = ormCols;
        this.rdbCols = rdbCols;
        this.connected = connected;
        this.nameLabel.setIconTextGap(1);
        BorderLayout layout = new BorderLayout();
        layout.setHorizontalSpacing(8);
        this.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)this.nameLabel, BorderLayout.LEFT);
        this.add((IFigure)this.typeFigure, BorderLayout.RIGHT);
        this.setBackgroundColor(ColorConstants.menuBackgroundSelected);
        this.setOpaque(false);
        this.setBorder(EmptyBorder.INSTANCE);
        this.nameLabel.setIcon(emptyImage);
    }

    public void setPrimaryKey(boolean pk) {
        this.nameLabel.setIcon(pk ? pkImage : emptyImage);
    }

    public void setName(String name) {
        this.nameLabel.setText(name);
        this.typeFigure.setForegroundColor(this.getForegroundColor());
    }

    public void setType(String type) {
        this.typeFigure.setText(type);
        this.typeFigure.setForegroundColor(this.getForegroundColor());
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setOpaque(selected);
        this.typeFigure.setForegroundColor(this.getForegroundColor());
    }

    public void setToolTipText(String toolTipText) {
        if (toolTipText == null || toolTipText.trim().length() == 0) {
            this.setToolTip(null);
        } else {
            Label label = new Label(toolTipText);
            label.setBackgroundColor(ColorConstants.tooltipBackground);
            label.setForegroundColor(ColorConstants.tooltipForeground);
            this.setToolTip((IFigure)label);
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.selected) {
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
        }
        graphics.setForegroundColor(this.getForegroundColor());
        super.paintFigure(graphics);
    }

    protected void paintChildren(Graphics graphics) {
        graphics.setForegroundColor(this.getForegroundColor());
        super.paintChildren(graphics);
    }

    public Color getForegroundColor() {
        if (this.selected) {
            return ColorConstants.menuForegroundSelected;
        }
        if (!this.connected) {
            return ColorConstants.black;
        }
        String name = this.nameLabel.getText().toLowerCase();
        boolean orm = this.ormCols.containsKey(name);
        boolean rdb = this.rdbCols.containsKey(name);
        if (orm) {
            if (rdb) {
                return ColorConstants.black;
            }
            return ColorConstants.red;
        }
        if (rdb) {
            return ColorConstants.black;
        }
        return ColorConstants.gray;
    }
}

