/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.persistence.connection;

import java.util.Map;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.connection.MongoDBConnection;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.persistence.connection.EclipseLinkNoSqlConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkMongoDBConnection
extends EclipseLinkNoSqlConnection
implements MongoDBConnection {
    private String databaseName;
    private String host;
    private String options;
    private String port;
    private String readPreference;
    private String writeConcern;

    public EclipseLinkMongoDBConnection(PersistenceUnit parent) {
        super(parent);
    }

    @Override
    protected void addDatabaseConnectionPropertyNames(Map<String, String> propertyNames) {
        super.addDatabaseConnectionPropertyNames(propertyNames);
        propertyNames.put("eclipselink.nosql.property.mongo.db", "databaseName");
        propertyNames.put("eclipselink.nosql.property.mongo.host", "host");
        propertyNames.put("eclipselink.nosql.property.mongo.port", "port");
        propertyNames.put("eclipselink.nosql.property.mongo.read-preference", "read-preference");
        propertyNames.put("eclipselink.nosql.property.mongo.write-concern", "write-preference");
        propertyNames.put("eclipselink.nosql.property.mongo.options", "options");
    }

    private void databaseNameChanged(String databaseName) {
        String oldDatabaseName = this.databaseName;
        this.databaseName = databaseName;
        this.firePropertyChanged("databaseName", oldDatabaseName, databaseName);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getDefaultConnectionSpec() {
        return "org.eclipse.persistence.nosql.adapters.mongo.MongoConnectionSpec";
    }

    @Override
    public String getDefaultDatabaseName() {
        return "";
    }

    @Override
    public String getDefaultHost() {
        return "";
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultPort() {
        return "27017";
    }

    @Override
    public String getDefaultReadPreference() {
        return "PRIMARY";
    }

    @Override
    public String getDefaultWriteConcern() {
        return "NONE";
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getOptions() {
        return this.options;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getReadPreference() {
        return this.readPreference;
    }

    @Override
    public String getWriteConcern() {
        return this.writeConcern;
    }

    private void hostChanged(String host) {
        String oldHost = this.host;
        this.host = host;
        this.firePropertyChanged("host", oldHost, host);
    }

    @Override
    protected void initializeDatabaseConnectionProperties() {
        super.initializeDatabaseConnectionProperties();
        this.databaseName = this.getStringValue("eclipselink.nosql.property.mongo.db");
        this.host = this.getStringValue("eclipselink.nosql.property.mongo.host");
        this.port = this.getStringValue("eclipselink.nosql.property.mongo.port");
        this.readPreference = this.getStringValue("eclipselink.nosql.property.mongo.read-preference");
        this.writeConcern = this.getStringValue("eclipselink.nosql.property.mongo.write-concern");
        this.options = this.getStringValue("eclipselink.nosql.property.mongo.options");
    }

    private void optionsChanged(String options) {
        String oldOptions = this.options;
        this.options = options;
        this.firePropertyChanged("options", oldOptions, options);
    }

    private void portChanged(String port) {
        String oldPort = this.port;
        this.port = port;
        this.firePropertyChanged("port", oldPort, port);
    }

    @Override
    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.nosql.property.mongo.db")) {
            this.databaseNameChanged(null);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.host")) {
            this.hostChanged(null);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.port")) {
            this.portChanged(null);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.read-preference")) {
            this.readPreferenceChanged(null);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.write-concern")) {
            this.writeConcernChanged(null);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.options")) {
            this.optionsChanged(null);
        } else {
            super.propertyRemoved(propertyName);
        }
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.nosql.property.mongo.db")) {
            this.databaseNameChanged(newValue);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.host")) {
            this.hostChanged(newValue);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.port")) {
            this.portChanged(newValue);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.read-preference")) {
            this.readPreferenceChanged(newValue);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.write-concern")) {
            this.writeConcernChanged(newValue);
        } else if (propertyName.equals("eclipselink.nosql.property.mongo.options")) {
            this.optionsChanged(newValue);
        } else {
            super.propertyValueChanged(propertyName, newValue);
        }
    }

    private void readPreferenceChanged(String readPreference) {
        String oldReadPreference = this.readPreference;
        this.readPreference = readPreference;
        this.firePropertyChanged("read-preference", oldReadPreference, readPreference);
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.preSetProperty();
        String oldDatabaseName = this.databaseName;
        this.databaseName = databaseName;
        this.putProperty("databaseName", databaseName);
        this.firePropertyChanged("databaseName", oldDatabaseName, databaseName);
    }

    @Override
    public void setHost(String host) {
        this.preSetProperty();
        String oldHost = this.host;
        this.host = host;
        this.putProperty("host", host);
        this.firePropertyChanged("host", oldHost, host);
    }

    @Override
    public void setOptions(String options) {
        this.preSetProperty();
        String oldOptions = this.options;
        this.options = options;
        this.putProperty("options", options);
        this.firePropertyChanged("options", oldOptions, options);
    }

    @Override
    public void setPort(String port) {
        this.preSetProperty();
        String oldPort = this.port;
        this.port = port;
        this.putProperty("port", port);
        this.firePropertyChanged("port", oldPort, port);
    }

    @Override
    public void setReadPreference(String readPreference) {
        this.preSetProperty();
        String oldReadPreference = this.readPreference;
        this.readPreference = readPreference;
        this.putProperty("read-preference", readPreference);
        this.firePropertyChanged("read-preference", oldReadPreference, readPreference);
    }

    @Override
    public void setWriteConcern(String writeConcern) {
        this.preSetProperty();
        String oldWriteConcern = this.writeConcern;
        this.writeConcern = writeConcern;
        this.putProperty("write-preference", writeConcern);
        this.firePropertyChanged("write-preference", oldWriteConcern, writeConcern);
    }

    private void writeConcernChanged(String writeConcern) {
        String oldWriteConcern = this.writeConcern;
        this.writeConcern = writeConcern;
        this.firePropertyChanged("write-preference", oldWriteConcern, writeConcern);
    }
}

