/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.options;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.FileChooserComboPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.Logging;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.LoggingLevel;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.persistence.options.LoggerClassChooser;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLoggingComposite<T extends Logging>
extends Pane<T> {
    public EclipseLinkLoggingComposite(Pane<?> parent, PropertyValueModel<T> subjectModel, Composite parentComposite) {
        super(parent, subjectModel, parentComposite);
    }

    protected Composite addComposite(Composite container) {
        return this.addSubPane(container, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlLoggingTab_loggingLevelLabel);
        this.addLoggingLevelCombo(container);
        this.logPropertiesComposite(container);
        this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlLoggingTab_loggingFileLabel);
        this.addLogFileLocationComposite(container);
        Hyperlink loggerHyperlink = this.addHyperlink(container, EclipseLinkUiMessages.PersistenceXmlLoggingTab_loggerLabel);
        new LoggerClassChooser(this, container, loggerHyperlink);
    }

    protected void logPropertiesComposite(Composite parent) {
        TriStateCheckBox timestampCheckBox = this.addTriStateCheckBoxWithDefault(parent, EclipseLinkUiMessages.PersistenceXmlLoggingTab_timestampLabel, this.buildTimestampHolder(), this.buildTimestampStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_TIMESTAMP);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        timestampCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox threadCheckBox = this.addTriStateCheckBoxWithDefault(parent, EclipseLinkUiMessages.PersistenceXmlLoggingTab_threadLabel, this.buildThreadHolder(), this.buildThreadStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_THREAD);
        threadCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox sessionCheckBox = this.addTriStateCheckBoxWithDefault(parent, EclipseLinkUiMessages.PersistenceXmlLoggingTab_sessionLabel, this.buildSessionHolder(), this.buildSessionStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_SESSION);
        sessionCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox exceptionsCheckBox = this.addTriStateCheckBoxWithDefault(parent, EclipseLinkUiMessages.PersistenceXmlLoggingTab_exceptionsLabel, this.buildExceptionsHolder(), this.buildExceptionsStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_EXCEPTIONS);
        exceptionsCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    private EnumFormComboViewer<Logging, LoggingLevel> addLoggingLevelCombo(Composite container) {
        return new EnumFormComboViewer<Logging, LoggingLevel>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("level");
            }

            protected LoggingLevel[] getChoices() {
                return LoggingLevel.values();
            }

            protected boolean sortChoices() {
                return false;
            }

            protected LoggingLevel getDefaultValue() {
                return ((Logging)this.getSubject()).getDefaultLevel();
            }

            protected String displayString(LoggingLevel value) {
                switch (value) {
                    case all: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_all;
                    }
                    case config: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_config;
                    }
                    case fine: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_fine;
                    }
                    case finer: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_finer;
                    }
                    case finest: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_finest;
                    }
                    case info: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_info;
                    }
                    case off: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_off;
                    }
                    case severe: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_severe;
                    }
                    case warning: {
                        return EclipseLinkUiMessages.LoggingLevelComposite_warning;
                    }
                }
                throw new IllegalStateException();
            }

            protected LoggingLevel getValue() {
                return ((Logging)this.getSubject()).getLevel();
            }

            protected void setValue(LoggingLevel value) {
                ((Logging)this.getSubject()).setLevel(value);
            }

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_LEVEL;
            }
        };
    }

    private FileChooserComboPane<Logging> addLogFileLocationComposite(Composite parent) {
        return new FileChooserComboPane<Logging>((Pane)this, parent){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<Logging, String>(this.getSubjectHolder(), new String[]{"logFileLocation"}){

                    protected String buildValue_() {
                        String name = ((Logging)this.subject).getLogFileLocation();
                        if (name == null) {
                            name = this.defaultValue((Logging)this.subject);
                        }
                        return name;
                    }

                    protected void setValue_(String value) {
                        if (this.defaultValue((Logging)this.subject).equals(value)) {
                            value = null;
                        }
                        ((Logging)this.subject).setLogFileLocation(value);
                    }
                };
            }

            private String defaultValue(Logging subject) {
                String defaultValue = subject.getDefaultLogFileLocation();
                if (defaultValue != null) {
                    return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
                }
                return this.getDefaultString();
            }

            protected String getDefaultString() {
                return EclipseLinkUiMessages.PersistenceXmlLoggingTab_defaultStdout;
            }

            protected String getDialogTitle() {
                return EclipseLinkUiMessages.LoggingFileLocationComposite_dialogTitle;
            }

            protected String getProjectPath() {
                return ((Logging)this.getSubject()).getJpaProject().getProject().getLocation().toString();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildTimestampHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"timestamp"}){

            protected Boolean buildValue_() {
                return ((Logging)this.subject).getTimestamp();
            }

            protected void setValue_(Boolean value) {
                ((Logging)this.subject).setTimestamp(value);
            }
        };
    }

    private PropertyValueModel<String> buildTimestampStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultTimestampHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlLoggingTab_timestampLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlLoggingTab_timestampLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultTimestampHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"timestamp"}){

            protected Boolean buildValue_() {
                if (((Logging)this.subject).getTimestamp() != null) {
                    return null;
                }
                return ((Logging)this.subject).getDefaultTimestamp();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildThreadHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"thread"}){

            protected Boolean buildValue_() {
                return ((Logging)this.subject).getThread();
            }

            protected void setValue_(Boolean value) {
                ((Logging)this.subject).setThread(value);
            }
        };
    }

    private PropertyValueModel<String> buildThreadStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultThreadHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlLoggingTab_threadLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlLoggingTab_threadLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultThreadHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"thread"}){

            protected Boolean buildValue_() {
                if (((Logging)this.subject).getThread() != null) {
                    return null;
                }
                return ((Logging)this.subject).getDefaultThread();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildSessionHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"session"}){

            protected Boolean buildValue_() {
                return ((Logging)this.subject).getSession();
            }

            protected void setValue_(Boolean value) {
                ((Logging)this.subject).setSession(value);
            }
        };
    }

    private PropertyValueModel<String> buildSessionStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultSessionHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlLoggingTab_sessionLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlLoggingTab_sessionLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultSessionHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"session"}){

            protected Boolean buildValue_() {
                if (((Logging)this.subject).getSession() != null) {
                    return null;
                }
                return ((Logging)this.subject).getDefaultSession();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildExceptionsHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"exceptions"}){

            protected Boolean buildValue_() {
                return ((Logging)this.subject).getExceptions();
            }

            protected void setValue_(Boolean value) {
                ((Logging)this.subject).setExceptions(value);
            }
        };
    }

    private PropertyValueModel<String> buildExceptionsStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultExceptionsHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlLoggingTab_exceptionsLabelDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMessages.PersistenceXmlLoggingTab_exceptionsLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultExceptionsHolder() {
        return new PropertyAspectAdapter<Logging, Boolean>(this.getSubjectHolder(), new String[]{"exceptions"}){

            protected Boolean buildValue_() {
                if (((Logging)this.subject).getExceptions() != null) {
                    return null;
                }
                return ((Logging)this.subject).getDefaultExceptions();
            }
        };
    }
}

