/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.lwm2m.templates;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.mapping.IMapped;
import org.eclipse.vorto.codegen.lwm2m.generated.LWM2M;
import org.eclipse.vorto.codegen.lwm2m.templates.LWM2MConstants;
import org.eclipse.vorto.codegen.lwm2m.utils.ResourceIdComparator;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.Presence;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.impl.PrimitivePropertyTypeImpl;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Fault;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;

public class FunctionBlockXmlTemplate
extends LWM2MConstants
implements ITemplate<FunctionblockModel> {
    private static final String STR_ABORT_GENERATOR = " - abort Generator!";
    private final SortedSet<LWM2M.Object.Resources.Item> resourceIdSet = new TreeSet<LWM2M.Object.Resources.Item>(new ResourceIdComparator());

    public String getContent(FunctionblockModel model, InvocationContext context) {
        Status status;
        String name = model.getName();
        LWM2M lwm2m = new LWM2M();
        List<LWM2M.Object> lwm2mObjects = lwm2m.getObject();
        FunctionBlock functionblock = model.getFunctionblock();
        if (functionblock == null) {
            throw new RuntimeException("This model has no function block.");
        }
        LWM2M.Object lwm2mObject = new LWM2M.Object();
        lwm2mObject.setObjectType("MODefinition");
        lwm2mObject.setName(name);
        IMapped mappedFunctionblock = context.getMappedElement(model, "Object");
        lwm2mObject.setObjectID(Integer.parseInt(mappedFunctionblock.getAttributeValue("ObjectID", "0")));
        lwm2mObject.setObjectURN(mappedFunctionblock.getAttributeValue("ObjectURN", "TBD"));
        lwm2mObject.setMultipleInstances(mappedFunctionblock.getAttributeValue("Multiple", "Single"));
        lwm2mObject.setMandatory(mappedFunctionblock.getAttributeValue("Mandatory", "Optional"));
        lwm2mObject.setDescription1(model.getDescription());
        lwm2mObject.setDescription2(mappedFunctionblock.getAttributeValue("Description2", ""));
        Configuration configuration = functionblock.getConfiguration();
        if (configuration != null) {
            EList configProps = configuration.getProperties();
            this.handleProperties(lwm2mObject, (EList<Property>)configProps, "RW", context);
        }
        if ((status = functionblock.getStatus()) != null) {
            EList statusProps = status.getProperties();
            this.handleProperties(lwm2mObject, (EList<Property>)statusProps, "R", context);
        }
        this.handleOperations(functionblock, lwm2mObject, context);
        Fault fault = functionblock.getFault();
        if (fault != null) {
            throw new IllegalArgumentException("Unsupported element <fault> - abort Generator!");
        }
        EList events = functionblock.getEvents();
        if (!events.isEmpty()) {
            throw new IllegalArgumentException("Unsupported element <events> - abort Generator!");
        }
        this.addSortedResourceIds(name, lwm2mObject);
        lwm2mObjects.add(lwm2mObject);
        return this.handleMarshalling(lwm2m, name);
    }

    private void addSortedResourceIds(String functionBlockName, LWM2M.Object lwm2mObject) {
        LWM2M.Object.Resources lwm2mResources = new LWM2M.Object.Resources();
        List<LWM2M.Object.Resources.Item> resourceItems = lwm2mResources.getItem();
        if (this.resourceIdSet.isEmpty()) {
            String errMsg = "Empty Function Block <" + functionBlockName + "> (contains no resources)" + STR_ABORT_GENERATOR;
            throw new IllegalArgumentException(errMsg);
        }
        resourceItems.addAll(this.resourceIdSet);
        lwm2mObject.setResources(lwm2mResources);
    }

    private String handleMarshalling(LWM2M lwm2m, String functionBlockName) {
        String content = "";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LWM2M.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            jaxbMarshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)"http://openmobilealliance.org/tech/profiles/LWM2M.xsd");
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal((Object)lwm2m, (Writer)sw);
            content = sw.toString();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Marshal Exception for Function Block <" + functionBlockName + ">" + STR_ABORT_GENERATOR + "\n", ex);
        }
        return content;
    }

    private void handleOperations(FunctionBlock functionblock, LWM2M.Object lwm2mObject, InvocationContext context) {
        EList operations = functionblock.getOperations();
        for (Operation operation : operations) {
            LWM2M.Object.Resources.Item item = new LWM2M.Object.Resources.Item();
            this.handleMappingRulesForOperations(lwm2mObject, operation, item, context);
            String operName = operation.getName();
            item.setName(operName);
            item.setOperations("E");
            String operDescr = operation.getDescription();
            if (operDescr == null) {
                operDescr = "";
            }
            item.setDescription(operDescr);
            EList params = operation.getParams();
            if (!params.isEmpty()) {
                String errMsg = "Unsupported operation <" + operName + "> with parameter(s) - Generator only supports One-way operations without parameter(s)!";
                throw new IllegalArgumentException(errMsg);
            }
            ReturnType returnType = operation.getReturnType();
            if (returnType != null) {
                String errMsg = "Unsupported operation <" + operName + "> with return Type - Generator only supports One-way operations without parameter(s)!";
                throw new IllegalArgumentException(errMsg);
            }
            this.checkResourceIdConflictAndFillSet(item);
        }
    }

    private void handleMappingRulesForOperations(LWM2M.Object lwm2mObject, Operation operation, LWM2M.Object.Resources.Item item, InvocationContext context) {
        IMapped mappingRule = context.getMappedElement(operation, "Resources");
        item.setID(Short.parseShort(mappingRule.getAttributeValue("ID", "0")));
        item.setMultipleInstances(mappingRule.getAttributeValue("MultipleInstances", "Single"));
        item.setMandatory(mappingRule.getAttributeValue("Mandatory", "Mandatory"));
        item.setType(mappingRule.getAttributeValue("Type", "String"));
        item.setRangeEnumeration(mappingRule.getAttributeValue("RangeEnumeration", ""));
        item.setUnits(mappingRule.getAttributeValue("Units", ""));
    }

    private void checkResourceIdConflictAndFillSet(LWM2M.Object.Resources.Item item) {
        if (!this.resourceIdSet.isEmpty() && this.resourceIdSet.contains(item)) {
            String errMsg = "Resource ID <" + item.getID() + "> conflict for <" + item.getName() + ">" + STR_ABORT_GENERATOR;
            throw new IllegalArgumentException(errMsg);
        }
        this.resourceIdSet.add(item);
    }

    private void handleProperties(LWM2M.Object lwm2mObject, EList<Property> properties, String operation, InvocationContext context) {
        for (Property property : properties) {
            LWM2M.Object.Resources.Item item = new LWM2M.Object.Resources.Item();
            item.setOperations(operation);
            this.handleMappingRulesForProperties(lwm2mObject, property, item, context);
            Presence mandatory = property.getPresence();
            if (mandatory == null || !mandatory.isMandatory()) {
                item.setMandatory("Optional");
            } else {
                item.setMandatory("Mandatory");
            }
            boolean multiplicity = property.isMultiplicity();
            if (multiplicity) {
                item.setMultipleInstances("Multiple");
            } else {
                item.setMultipleInstances("Single");
            }
            String statusPropertyName = property.getName();
            item.setName(statusPropertyName);
            this.handleRangeEnumeration(lwm2mObject, property, item);
            PropertyType type = property.getType();
            if (!(type instanceof PrimitivePropertyTypeImpl)) {
                String errMsg = this.unsupportedValueForPropertyMsg("PropertyType (Enum/Entity)", property, lwm2mObject);
                throw new IllegalArgumentException(errMsg);
            }
            String primitiveTypeStr = ((PrimitivePropertyTypeImpl)type).getType().toString();
            String lwm2mTypeStr = this.propertyType2Lwm2mType(primitiveTypeStr);
            item.setType(lwm2mTypeStr);
            String statusPropDescr = property.getDescription();
            if (statusPropDescr == null) {
                statusPropDescr = "";
            }
            item.setDescription(statusPropDescr);
            this.checkResourceIdConflictAndFillSet(item);
        }
    }

    private void handleRangeEnumeration(LWM2M.Object lwm2mObject, Property property, LWM2M.Object.Resources.Item item) {
        if (property.getConstraintRule() != null) {
            EList constraints = property.getConstraintRule().getConstraints();
            StringBuilder rangeSb = new StringBuilder();
            for (Constraint constraint : constraints) {
                ConstraintIntervalType type = constraint.getType();
                String constraintValues = constraint.getConstraintValues();
                if (type == ConstraintIntervalType.MIN) {
                    rangeSb.append(constraintValues).append('-');
                    continue;
                }
                if (type == ConstraintIntervalType.MAX) {
                    rangeSb.append(constraintValues);
                    continue;
                }
                if (type == ConstraintIntervalType.STRLEN) {
                    rangeSb.append("0-").append(constraintValues).append(" bytes");
                    continue;
                }
                String errMsg = this.unsupportedValueForPropertyMsg("ConstraintIntervalType <" + type + ">", property, lwm2mObject);
                throw new IllegalArgumentException(errMsg);
            }
            item.setRangeEnumeration(rangeSb.toString());
        }
    }

    private void handleMappingRulesForProperties(LWM2M.Object lwm2mObject, Property property, LWM2M.Object.Resources.Item item, InvocationContext context) {
        IMapped propertyMapping = context.getMappedElement(property, "Resources");
        item.setID(Short.parseShort(propertyMapping.getAttributeValue("ID", Integer.toString(this.resourceIdSet.size()))));
        item.setUnits(propertyMapping.getAttributeValue("Units", ""));
        item.setOperations(propertyMapping.getAttributeValue("Operations", item.getOperations()));
    }

    private String unsupportedValueForPropertyMsg(String value, Property property, LWM2M.Object lwm2mObject) {
        return "Unsupported " + value + " for property <" + property.getName() + "> of <" + lwm2mObject.getName() + ">" + STR_ABORT_GENERATOR;
    }

    private String propertyType2Lwm2mType(String primitiveTypeStr) {
        String lwm2mTypeStr = "";
        switch (primitiveTypeStr) {
            case "boolean": {
                lwm2mTypeStr = "Boolean";
                break;
            }
            case "dateTime": {
                lwm2mTypeStr = "Time";
                break;
            }
            case "double": 
            case "float": {
                lwm2mTypeStr = "Float";
                break;
            }
            case "int": 
            case "byte": 
            case "long": 
            case "short": {
                lwm2mTypeStr = "Integer";
                break;
            }
            case "string": {
                lwm2mTypeStr = "String";
                break;
            }
            case "base64Binary": {
                lwm2mTypeStr = "Opaque";
                break;
            }
            default: {
                String errMsg = "Unknown PropertyType: " + primitiveTypeStr;
                throw new IllegalArgumentException(errMsg);
            }
        }
        return lwm2mTypeStr;
    }
}

