/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.functionblock.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.Fault;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockPackage;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelPackage;
import org.eclipse.vorto.editor.datatype.internal.validation.ConstraintValueValidator;
import org.eclipse.vorto.editor.datatype.validation.ConstraintValidatorFactory;
import org.eclipse.vorto.editor.datatype.validation.PropertyConstraintMappingValidation;
import org.eclipse.vorto.editor.datatype.validation.ValidatorUtils;
import org.eclipse.vorto.editor.functionblock.validation.AbstractFunctionblockValidator;
import org.eclipse.vorto.editor.functionblock.validation.FbValidatorUtils;
import org.eclipse.vorto.editor.functionblock.validation.TypeHelper;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class FunctionblockValidator
extends AbstractFunctionblockValidator {
    public final PropertyConstraintMappingValidation propertyValidator = new PropertyConstraintMappingValidation();
    @Inject
    private TypeHelper helper;

    @Check
    public void checkEntityandEnum(FunctionblockModel model) {
        List<Type> list = this.getAllTypeFromReferencedFile((EObject)model);
        HashSet<String> set = this.getNonDuplicateLowerCasedNameSet(list);
        EList entities = model.getEntities();
        EList enums = model.getEnums();
        for (Entity en : entities) {
            boolean _not;
            String _name = en.getName();
            String _lowerCase = _name.toLowerCase();
            boolean _add = set.add(_lowerCase);
            boolean bl = _not = !_add;
            if (!_not) continue;
            this.error("Enum or Entity name has been defined.", (EObject)en, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
        for (Enum en_1 : enums) {
            boolean _not_1;
            String _name_1 = en_1.getName();
            String _lowerCase_1 = _name_1.toLowerCase();
            boolean _add_1 = set.add(_lowerCase_1);
            boolean bl = _not_1 = !_add_1;
            if (!_not_1) continue;
            this.error("Enum or Entity name has been defined.", (EObject)en_1, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
    }

    public List<Type> getAllTypeFromReferencedFile(EObject eObject) {
        return this.helper.getAllTypeFromReferencedTypeFile(eObject);
    }

    public HashSet<String> getNonDuplicateLowerCasedNameSet(List<Type> list) {
        HashSet<String> set = new HashSet<String>();
        for (Type e : list) {
            String _name = e.getName();
            String _lowerCase = _name.toLowerCase();
            set.add(_lowerCase);
        }
        return set;
    }

    @Check
    public void checkFunctionBlockName(FunctionblockModel model) {
        String name = model.getName();
        boolean _isCamelCasedName = this.isCamelCasedName(name);
        if (_isCamelCasedName) {
            this.error("Function block name must begin with a capital letter", (EObject)model, (EStructuralFeature)ModelPackage.Literals.MODEL__NAME);
        }
    }

    @Check
    public void checkDuplicateParameter(Operation operation) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)operation.getParams(), Object.class)).length) {
            boolean _not;
            EList _params = operation.getParams();
            Param param = (Param)_params.get(i);
            String _name = param.getName();
            boolean _add = set.add(_name);
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Parameter name has been defined", (EObject)param, (EStructuralFeature)FunctionblockPackage.Literals.PARAM__NAME);
            }
            ++i;
        }
    }

    @Check
    public void checkDuplicateOperation(Operation op) {
        HashSet<String> set = new HashSet<String>();
        EObject _eContainer = op.eContainer();
        FunctionBlock fb = (FunctionBlock)_eContainer;
        EList ops = fb.getOperations();
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)ops, Object.class)).length) {
            boolean _not;
            Operation method = (Operation)ops.get(i);
            String _name = method.getName();
            boolean _add = set.add(_name);
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Method name has been defined", (EObject)method, (EStructuralFeature)FunctionblockPackage.Literals.OPERATION__NAME);
            }
            ++i;
        }
    }

    @Check
    public void checkOpNameAgainstEntityName(FunctionblockModel model) {
        List<Type> listEE = this.getAllTypeFromReferencedFile((EObject)model);
        EList _entities = model.getEntities();
        listEE.addAll((Collection<Type>)_entities);
        EList _enums = model.getEnums();
        listEE.addAll((Collection<Type>)_enums);
        HashSet<String> set = this.getNonDuplicateLowerCasedNameSet(listEE);
        FunctionBlock _functionblock = model.getFunctionblock();
        EList ops = _functionblock.getOperations();
        for (Operation op : ops) {
            String _name = op.getName();
            String _lowerCase = _name.toLowerCase();
            boolean _contains = set.contains(_lowerCase);
            if (!_contains) continue;
            this.error("Operation name cannot be same as custom type (Enum / Entity) name", (EObject)op, (EStructuralFeature)FunctionblockPackage.Literals.OPERATION__NAME);
        }
    }

    @Check
    public void checkVersionPattern(FunctionblockModel functionblock) {
        boolean _not;
        String _version = functionblock.getVersion();
        boolean _matches = _version.matches("\\d+\\.\\d+\\.\\d+(\\-.+)?");
        boolean bl = _not = !_matches;
        if (_not) {
            this.error("Version is not matching the following pattern: <MAJOR>.<MINOR>.<PATCH>-<QUALIFIER>", (EObject)functionblock, (EStructuralFeature)ModelPackage.Literals.MODEL__VERSION);
        }
    }

    @Check
    public void checkNamespacePattern(FunctionblockModel functionblock) {
        boolean _not;
        String _namespace = functionblock.getNamespace();
        boolean _matches = _namespace.matches("([a-z0-9]*\\.)*[a-z0-9]*");
        boolean bl = _not = !_matches;
        if (_not) {
            this.error("Namespace should have following pattern: <[a-z0-9]+(.[a-z0-9])*> E.g com.bosch, com.bosch.lightsystem", (EObject)functionblock, (EStructuralFeature)ModelPackage.Literals.MODEL__VERSION);
        }
    }

    @Check
    public void checkParametersConstraint(Operation op) {
        boolean _equals;
        EList parameters = op.getParams();
        EList _converted_parameters = parameters;
        int _length = ((Object[])Conversions.unwrapArray((Object)_converted_parameters, Object.class)).length;
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return;
        }
        for (Param parameter : parameters) {
            if (!(parameter instanceof PrimitiveParam)) continue;
            PrimitiveParam primitiveParam = (PrimitiveParam)parameter;
            PrimitiveType primitiveType = primitiveParam.getType();
            ConstraintRule _constraintRule = primitiveParam.getConstraintRule();
            EList constraintsList = _constraintRule.getConstraints();
            for (Constraint constraint : constraintsList) {
                PrimitiveType _type = primitiveParam.getType();
                String _name = _type.getName();
                boolean _isMultiplicity = ((PrimitiveParam)parameter).isMultiplicity();
                this.checkForConstraint(primitiveType, constraint, (EObject)parameter, _name, _isMultiplicity, (EStructuralFeature)FunctionblockPackage.Literals.PRIMITIVE_PARAM__CONSTRAINT_RULE);
            }
        }
    }

    @Check
    public void checkReturnTypeConstraint(Operation op) {
        ReturnType returnType = op.getReturnType();
        if (returnType instanceof ReturnPrimitiveType) {
            ReturnPrimitiveType returnPrimitiveType = (ReturnPrimitiveType)returnType;
            PrimitiveType _returnType = returnPrimitiveType.getReturnType();
            String parameterName = _returnType.getName();
            ConstraintRule _constraintRule = returnPrimitiveType.getConstraintRule();
            EList constraintsList = _constraintRule.getConstraints();
            for (Constraint constraint : constraintsList) {
                PrimitiveType _returnType_1 = returnPrimitiveType.getReturnType();
                boolean _isMultiplicity = returnPrimitiveType.isMultiplicity();
                this.checkForConstraint(_returnType_1, constraint, (EObject)returnPrimitiveType, parameterName, _isMultiplicity, (EStructuralFeature)FunctionblockPackage.Literals.RETURN_PRIMITIVE_TYPE__CONSTRAINT_RULE);
            }
        }
    }

    public void checkForConstraint(PrimitiveType primitiveType, Constraint constraint, EObject source, String parameterName, boolean isMultiplcity, EStructuralFeature feature) {
        boolean _not;
        boolean _isValidConstraintType = this.isValidConstraintType(primitiveType, constraint);
        boolean bl = _not = !_isValidConstraintType;
        if (_not) {
            String _errorMessage = this.propertyValidator.getErrorMessage();
            this.error(_errorMessage, source, feature);
        } else {
            boolean _not_1;
            ConstraintIntervalType _type = constraint.getType();
            ConstraintValueValidator validator = ConstraintValidatorFactory.getValueValidator((ConstraintIntervalType)_type);
            boolean _isValidConstraintValue = this.isValidConstraintValue(validator, primitiveType, constraint);
            boolean bl2 = _not_1 = !_isValidConstraintValue;
            if (_not_1) {
                String _errorMessage_1 = validator.getErrorMessage();
                this.error(_errorMessage_1, source, feature);
            }
        }
        boolean _isMimeConstraint = this.isMimeConstraint(parameterName, constraint);
        if (_isMimeConstraint && !isMultiplcity) {
            this.error("MIMEType only applies to byte array, have you forgotten to add 'multiple' ?", source, feature);
        }
    }

    @Check
    public void checkPropsIn(Configuration c) {
        EList _properties = c.getProperties();
        this.checkDuplicatedProperty((List)_properties);
    }

    @Check
    public void checkPropsIn(Status s) {
        EList _properties = s.getProperties();
        this.checkDuplicatedProperty((List)_properties);
    }

    @Check
    public void checkPropsIn(Fault f) {
        EList _properties = f.getProperties();
        this.checkDuplicatedProperty((List)_properties);
    }

    @Check
    public void checkPropsIn(Event e) {
        EList _properties = e.getProperties();
        this.checkDuplicatedProperty((List)_properties);
    }

    @Check
    public void checkPropsIn(Entity e) {
        EList _properties = e.getProperties();
        this.checkDuplicatedProperty((List)_properties);
    }

    @Check
    public void checkCircularRefInSuperType(FunctionblockModel functionblock) {
        boolean _notEquals;
        FunctionblockModel _superType = functionblock.getSuperType();
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            try {
                FunctionblockModel _superType_1 = functionblock.getSuperType();
                boolean _hasCircularReference = ValidatorUtils.hasCircularReference((Model)functionblock, (Model)_superType_1, (ValidatorUtils.ModelTypeBasedChildrenSupplier)FbValidatorUtils.modelToChildrenSupplierFunction);
                if (_hasCircularReference) {
                    this.error("Super type has circular reference", (EObject)functionblock, (EStructuralFeature)FunctionblockPackage.Literals.FUNCTIONBLOCK_MODEL__SUPER_TYPE);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check
    public void checkRefParamIsImported(RefParam refParam) {
        EList _references;
        Type _type;
        boolean _isTypeInReferences;
        boolean _not;
        boolean _notEquals;
        EObject _parentOfType = ValidatorUtils.getParentOfType((EObject)refParam, FunctionblockModel.class);
        FunctionblockModel topParent = (FunctionblockModel)_parentOfType;
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)topParent, null);
        _and = !_notEquals ? false : (_not = !(_isTypeInReferences = ValidatorUtils.isTypeInReferences((Model)(_type = refParam.getType()), (EList)(_references = topParent.getReferences()))));
        if (_and) {
            this.error("Reference parameter has not yet been imported.", (EObject)refParam, (EStructuralFeature)FunctionblockPackage.Literals.REF_PARAM__TYPE);
        }
    }

    @Check
    public void checkReturnTypeIsImported(ReturnObjectType returnType) {
        EList _references;
        Type _returnType;
        boolean _isTypeInReferences;
        boolean _not;
        boolean _notEquals;
        EObject _parentOfType = ValidatorUtils.getParentOfType((EObject)returnType, FunctionblockModel.class);
        FunctionblockModel topParent = (FunctionblockModel)_parentOfType;
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal((Object)topParent, null);
        _and = !_notEquals ? false : (_not = !(_isTypeInReferences = ValidatorUtils.isTypeInReferences((Model)(_returnType = returnType.getReturnType()), (EList)(_references = topParent.getReferences()))));
        if (_and) {
            this.error("Return type has not yet been imported.", (EObject)returnType, (EStructuralFeature)FunctionblockPackage.Literals.RETURN_OBJECT_TYPE__RETURN_TYPE);
        }
    }

    public TypeHelper setHelper(TypeHelper helper) {
        this.helper = helper;
        return this.helper;
    }

    public TypeHelper getHelper() {
        return this.helper;
    }
}

