/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.ui.model;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vorto.core.ui.parser.IModelParser;

public class ModelParserFactory {
    private static ModelParserFactory singleton = null;

    private ModelParserFactory() {
    }

    public static ModelParserFactory getInstance() {
        if (singleton == null) {
            singleton = new ModelParserFactory();
        }
        return singleton;
    }

    public IModelParser getModelParser() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.vorto.core.org_eclipse_vorto_core_ModelParser");
        IExtension[] modelParserExtensions = extensionPoint.getExtensions();
        if (modelParserExtensions.length == 0) {
            throw new RuntimeException("No Vorto Model Parser found!");
        }
        if (modelParserExtensions.length > 1) {
            throw new RuntimeException("More than 1 Vorto Model Parser found. Cannot decide which one to bind. ");
        }
        try {
            return (IModelParser)modelParserExtensions[0].getConfigurationElements()[0].createExecutableExtension("class");
        }
        catch (Exception e) {
            throw new RuntimeException("Problem binding Vorto Model Parser", e);
        }
    }
}

