/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingMarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeDirectCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public class XMLChoiceCollectionMappingMarshalNodeValue
extends NodeValue
implements ContainerValue {
    private XMLChoiceCollectionMapping xmlChoiceCollectionMapping;
    private Map<XMLField, NodeValue> fieldToNodeValues;
    private NodeValue choiceElementNodeValue;
    private XMLField xmlField;
    private boolean isMixedNodeValue;
    private int index = -1;

    public XMLChoiceCollectionMappingMarshalNodeValue(XMLChoiceCollectionMapping mapping, XMLField xmlField) {
        this.xmlChoiceCollectionMapping = mapping;
        this.xmlField = xmlField;
        this.initializeNodeValue();
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        if (this.isMixedNodeValue) {
            return xPathFragment.nameIsText();
        }
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void setFieldToNodeValues(Map<XMLField, NodeValue> fieldToNodeValues) {
        this.fieldToNodeValues = fieldToNodeValues;
    }

    private void initializeNodeValue() {
        XMLCollectionReferenceMapping refMapping;
        XMLMapping xmlMapping = this.xmlChoiceCollectionMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = xmlMapping instanceof XMLBinaryDataCollectionMapping ? new XMLBinaryDataCollectionMappingNodeValue((XMLBinaryDataCollectionMapping)xmlMapping) : (xmlMapping instanceof XMLCompositeDirectCollectionMapping ? new XMLCompositeDirectCollectionMappingNodeValue((XMLCompositeDirectCollectionMapping)xmlMapping) : (xmlMapping instanceof XMLCompositeCollectionMapping ? new XMLCompositeCollectionMappingNodeValue((XMLCompositeCollectionMapping)xmlMapping) : ((refMapping = (XMLCollectionReferenceMapping)xmlMapping).usesSingleNode() || refMapping.getFields().size() == 1 ? new XMLCollectionReferenceMappingNodeValue(refMapping, this.xmlField) : new XMLCollectionReferenceMappingMarshalNodeValue((XMLCollectionReferenceMapping)xmlMapping))));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        block18: {
            if (this.xmlChoiceCollectionMapping.isReadOnly()) {
                return false;
            }
            value = this.xmlChoiceCollectionMapping.getAttributeValueFromObject(object);
            if (value == null) {
                wrapperNP = this.xmlChoiceCollectionMapping.getWrapperNullPolicy();
                if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                    marshalRecord.nilSimple(namespaceResolver);
                    return true;
                }
                return false;
            }
            cp = this.getContainerPolicy();
            iterator = cp.iteratorFor(value);
            if (iterator != null && cp.hasNext(iterator)) {
                if (xPathFragment != null) {
                    groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
                    marshalRecord.closeStartGroupingElements(groupingFragment);
                }
            } else {
                return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlChoiceCollectionMapping.getWrapperNullPolicy() != null);
            }
            if (marshalRecord.getMarshaller().getMediaType() != MediaType.APPLICATION_JSON) ** GOTO lbl79
            nodeValues = new ArrayList<NodeValue>();
            values = new ArrayList<ArrayList<E>>();
            mixedNodeValue = null;
            mixedValues = null;
            while (cp.hasNext(iterator)) {
                nextValue = this.getConvertedValue(cp.next(iterator, session), marshalRecord, session);
                nodeValue = this.getNodeValueForValue(nextValue);
                if (nodeValue == null) continue;
                if (nodeValue == this) {
                    mixedNodeValue = this;
                    if (mixedValues == null) {
                        mixedValues = new ArrayList<Object>();
                    }
                    mixedValues.add(nextValue);
                    continue;
                }
                index = nodeValues.indexOf(nodeValue);
                if (index > -1) {
                    ((List)values.get(index)).add(nextValue);
                    continue;
                }
                nodeValues.add(nodeValue);
                valuesList = new ArrayList<Object>();
                valuesList.add(nextValue);
                values.add(valuesList);
            }
            if (mixedNodeValue != null) {
                nodeValues.add(mixedNodeValue);
                values.add(mixedValues);
            }
            i = 0;
            while (i < nodeValues.size()) {
                associatedNodeValue = (NodeValue)nodeValues.get(i);
                listValue = (List)values.get(i);
                frag = null;
                if (associatedNodeValue == this) {
                    frag = marshalRecord.getTextWrapperFragment();
                } else {
                    frag = associatedNodeValue.getXPathNode().getXPathFragment();
                    if (frag != null) {
                        frag = this.getOwningFragment(associatedNodeValue, frag);
                        associatedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementMarshalNodeValue();
                    }
                }
                if (frag != null) {
                    marshalRecord.startCollection();
                    j = 0;
                    while (j < listValue.size()) {
                        this.marshalSingleValueWithNodeValue(frag, marshalRecord, object, listValue.get(j), session, namespaceResolver, ObjectMarshalContext.getInstance(), associatedNodeValue);
                        ++j;
                    }
                    marshalRecord.endCollection();
                }
                ++i;
            }
            break block18;
lbl-1000:
            // 1 sources

            {
                nextValue = cp.next(iterator, session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, nextValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
lbl79:
                // 2 sources

                ** while (cp.hasNext((Object)iterator))
            }
        }
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        XPathFragment frag;
        if ((value = this.getConvertedValue(value, marshalRecord, session)) != null && value.getClass() == ClassConstants.STRING && this.xmlChoiceCollectionMapping.isMixedContent()) {
            this.marshalMixedContent(marshalRecord, (String)value);
            return true;
        }
        NodeValue associatedNodeValue = this.getNodeValueForValue(value);
        if (associatedNodeValue != null && (frag = associatedNodeValue.getXPathNode().getXPathFragment()) != null) {
            frag = this.getOwningFragment(associatedNodeValue, frag);
            NodeValue unwrappedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementMarshalNodeValue();
            return this.marshalSingleValueWithNodeValue(frag, marshalRecord, object, value, session, namespaceResolver, marshalContext, unwrappedNodeValue);
        }
        return true;
    }

    private boolean marshalSingleValueWithNodeValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext, NodeValue unwrappedNodeValue) {
        Object fieldValue = value;
        if (value instanceof XMLRoot) {
            fieldValue = ((XMLRoot)value).getObject();
        }
        if (unwrappedNodeValue != null) {
            unwrappedNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, fieldValue, session, namespaceResolver, marshalContext);
        }
        return true;
    }

    private Object getConvertedValue(Object originalValue, MarshalRecord marshalRecord, AbstractSession session) {
        Converter converter = this.xmlChoiceCollectionMapping.getConverter();
        if (converter != null) {
            if (converter instanceof XMLConverter) {
                return ((XMLConverter)converter).convertObjectValueToDataValue(originalValue, session, marshalRecord.getMarshaller());
            }
            return converter.convertObjectValueToDataValue(originalValue, session);
        }
        return originalValue;
    }

    /*
     * WARNING - void declaration
     */
    private NodeValue getNodeValueForValue(Object value) {
        if (value == null) {
            for (XMLChoiceCollectionMappingUnmarshalNodeValue xMLChoiceCollectionMappingUnmarshalNodeValue : this.fieldToNodeValues.values()) {
                DatabaseMapping nextMapping;
                NodeValue nextNodeValue = xMLChoiceCollectionMappingUnmarshalNodeValue.getChoiceElementMarshalNodeValue();
                if (!(nextNodeValue instanceof MappingNodeValue) || !((nextMapping = ((MappingNodeValue)nextNodeValue).getMapping()).isAbstractCompositeCollectionMapping() ? ((XMLCompositeCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil() : (nextMapping.isAbstractCompositeDirectCollectionMapping() ? ((XMLCompositeDirectCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil() : nextMapping instanceof XMLBinaryDataCollectionMapping && ((XMLBinaryDataCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil()))) continue;
                return xMLChoiceCollectionMappingUnmarshalNodeValue;
            }
            return null;
        }
        XMLField associatedField = null;
        if (value instanceof XMLRoot) {
            XMLRoot xMLRoot = (XMLRoot)value;
            String localName = xMLRoot.getLocalName();
            String namespaceUri = xMLRoot.getNamespaceURI();
            Object fieldValue = xMLRoot.getObject();
            associatedField = this.getFieldForName(localName, namespaceUri);
            if (associatedField == null) {
                Class<?> theClass = fieldValue.getClass();
                while (associatedField == null) {
                    associatedField = this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(theClass);
                    if (theClass.getSuperclass() != null) {
                        theClass = theClass.getSuperclass();
                        continue;
                    }
                    break;
                }
            }
        } else {
            Class<?> clazz = value.getClass();
            while (associatedField == null) {
                void var3_7;
                associatedField = this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(var3_7);
                if (var3_7.getSuperclass() != null) {
                    Class clazz2 = var3_7.getSuperclass();
                    continue;
                }
                break;
            }
        }
        if (associatedField == null) {
            void var3_11;
            Object var3_10 = null;
            Class<?> theClass = value.getClass();
            while (theClass != null) {
                List<XMLField> list = this.xmlChoiceCollectionMapping.getClassToSourceFieldsMappings().get(theClass);
                if (list != null) break;
                theClass = theClass.getSuperclass();
            }
            if (var3_11 != null) {
                associatedField = (XMLField)var3_11.get(0);
            }
        }
        if (associatedField != null) {
            return this.fieldToNodeValues.get(associatedField);
        }
        if (this.xmlChoiceCollectionMapping.isMixedContent() && value instanceof String) {
            return this;
        }
        return null;
    }

    private XPathFragment getOwningFragment(NodeValue nodeValue, XPathFragment frag) {
        while (frag != null) {
            if (nodeValue.isOwningNode(frag)) {
                return frag;
            }
            frag = frag.getNextFragment();
        }
        return null;
    }

    private void marshalMixedContent(MarshalRecord record, String value) {
        record.characters(value);
    }

    private XMLField getFieldForName(String localName, String namespaceUri) {
        for (XMLField nextField : this.fieldToNodeValues.keySet()) {
            XPathFragment fragment = nextField.getXPathFragment();
            while (fragment != null && !fragment.nameIsText()) {
                if ((fragment.getNextFragment() == null || fragment.getHasText()) && fragment.getLocalName().equals(localName)) {
                    String fragUri = fragment.getNamespaceURI();
                    if (namespaceUri == null && fragUri == null || namespaceUri != null && fragUri != null && namespaceUri.equals(fragUri)) {
                        return nextField;
                    }
                }
                fragment = fragment.getNextFragment();
            }
        }
        return null;
    }

    public Collection<NodeValue> getAllNodeValues() {
        return this.fieldToNodeValues.values();
    }

    @Override
    public boolean isMarshalNodeValue() {
        return true;
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlChoiceCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.xmlChoiceCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public XMLChoiceCollectionMapping getMapping() {
        return this.xmlChoiceCollectionMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public void setIsMixedNodeValue(boolean b) {
        this.isMixedNodeValue = b;
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return this.isMixedNodeValue;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

