/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.FunctionField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.DecoratedDatabaseTable;
import org.eclipse.persistence.internal.history.UniversalAsOfClause;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DB2MainframePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.SQLCall;

public class SQLSelectStatement
extends SQLStatement {
    protected ReadQuery query;
    protected boolean useUniqueFieldAliases = false;
    protected int fieldCounter = 0;
    protected Vector fields = NonSynchronizedVector.newInstance(2);
    protected List<Object> nonSelectFields;
    protected List<DatabaseTable> tables = new ArrayList<DatabaseTable>(4);
    protected short distinctState = 0;
    protected List<Expression> orderByExpressions;
    protected List<Expression> groupByExpressions;
    protected List<Expression> unionExpressions;
    protected Expression havingExpression;
    protected ForUpdateClause forUpdateClause;
    protected boolean isAggregateSelect = false;
    protected List<Expression> outerJoinedExpressions;
    protected List<Expression> outerJoinedMappingCriteria;
    protected List<Map<DatabaseTable, Expression>> outerJoinedAdditionalJoinCriteria;
    protected List descriptorsForMultitableInheritanceOnly;
    protected Expression startWithExpression;
    protected Expression connectByExpression;
    protected List<Expression> orderSiblingsByExpressions;
    protected boolean requiresAliases = false;
    protected Map<DatabaseTable, DatabaseTable> tableAliases;
    protected DatabaseTable lastTable;
    protected DatabaseTable currentAlias;
    protected int currentAliasNumber = 0;
    protected SQLSelectStatement parentStatement;

    public void addField(DatabaseField field) {
        this.getFields().addElement(field);
    }

    public void addField(Expression expression) {
        if (expression instanceof FunctionExpression && ((FunctionExpression)expression).getOperator().isAggregateOperator()) {
            this.setIsAggregateSelect(true);
        }
        this.getFields().add(expression);
    }

    protected void addOrderByExpressionToSelectForDistinct() {
        Iterator<Expression> iterator = this.getOrderByExpressions().iterator();
        while (iterator.hasNext()) {
            Expression orderExpression;
            Expression fieldExpression = orderExpression = iterator.next();
            while (fieldExpression.isFunctionExpression() && fieldExpression.getOperator().isOrderOperator()) {
                fieldExpression = ((FunctionExpression)fieldExpression).getBaseExpression();
            }
            if (!fieldExpression.selectIfOrderedBy() || this.fieldsContainField(this.getFields(), fieldExpression)) continue;
            this.addField(fieldExpression);
        }
    }

    public void addTable(DatabaseTable table) {
        if (!this.getTables().contains(table)) {
            this.getTables().add(table);
        }
    }

    public void appendFromClauseForInformixOuterJoin(ExpressionSQLPrinter printer, List<DatabaseTable> outerJoinedAliases) throws IOException {
        Writer writer = printer.getWriter();
        boolean firstTable = true;
        int index = 0;
        while (index < this.getOuterJoinExpressions().size()) {
            QueryKeyExpression outerExpression = (QueryKeyExpression)this.getOuterJoinExpressions().get(index);
            CompoundExpression relationExpression = (CompoundExpression)this.getOuterJoinedMappingCriteria().get(index);
            DatabaseTable targetTable = null;
            targetTable = outerExpression.getMapping().isDirectCollectionMapping() ? ((DirectCollectionMapping)outerExpression.getMapping()).getReferenceTable() : outerExpression.getMapping().getReferenceDescriptor().getTables().get(0);
            DatabaseTable sourceTable = outerExpression.getMapping().isObjectReferenceMapping() && ((ObjectReferenceMapping)outerExpression.getMapping()).isForeignKeyRelationship() ? outerExpression.getMapping().getFields().get(0).getTable() : ((ObjectExpression)outerExpression.getBaseExpression()).getDescriptor().getTables().get(0);
            DatabaseTable sourceAlias = outerExpression.getBaseExpression().aliasForTable(sourceTable);
            DatabaseTable targetAlias = outerExpression.aliasForTable(targetTable);
            if (!outerJoinedAliases.contains(sourceAlias) && !outerJoinedAliases.contains(targetAlias)) {
                DatabaseTable newAlias;
                DatabaseTable newTarget;
                if (!firstTable) {
                    writer.write(", ");
                }
                firstTable = false;
                writer.write(sourceTable.getQualifiedNameDelimited(printer.getPlatform()));
                outerJoinedAliases.add(sourceAlias);
                writer.write(" ");
                writer.write(sourceAlias.getQualifiedNameDelimited(printer.getPlatform()));
                if (outerExpression.getMapping().isManyToManyMapping()) {
                    newTarget = ((ManyToManyMapping)outerExpression.getMapping()).getRelationTable();
                    newAlias = relationExpression.aliasForTable(newTarget);
                    writer.write(", OUTER ");
                    writer.write(newTarget.getQualifiedNameDelimited(printer.getPlatform()));
                    writer.write(" ");
                    outerJoinedAliases.add(newAlias);
                    writer.write(newAlias.getQualifiedNameDelimited(printer.getPlatform()));
                } else if (outerExpression.getMapping().isDirectCollectionMapping()) {
                    newTarget = ((DirectCollectionMapping)outerExpression.getMapping()).getReferenceTable();
                    newAlias = relationExpression.aliasForTable(newTarget);
                    writer.write(", OUTER ");
                    writer.write(newTarget.getQualifiedNameDelimited(printer.getPlatform()));
                    writer.write(" ");
                    outerJoinedAliases.add(newAlias);
                    writer.write(newAlias.getQualifiedNameDelimited(printer.getPlatform()));
                } else {
                    Enumeration<DatabaseTable> target = outerExpression.getMapping().getReferenceDescriptor().getTables().elements();
                    while (target.hasMoreElements()) {
                        DatabaseTable newTarget2 = target.nextElement();
                        DatabaseTable newAlias2 = outerExpression.aliasForTable(newTarget2);
                        writer.write(", OUTER ");
                        writer.write(newTarget2.getQualifiedNameDelimited(printer.getPlatform()));
                        writer.write(" ");
                        outerJoinedAliases.add(newAlias2);
                        writer.write(newAlias2.getQualifiedNameDelimited(printer.getPlatform()));
                    }
                }
            }
            ++index;
        }
    }

    public void appendFromClauseForOuterJoin(ExpressionSQLPrinter printer, List<DatabaseTable> outerJoinedAliases, Collection aliasesOfTablesToBeLocked, boolean shouldPrintUpdateClauseForAllTables) throws IOException {
        Writer writer = printer.getWriter();
        AbstractSession session = printer.getSession();
        org.eclipse.persistence.platform.database.DatabasePlatform platform = session.getPlatform();
        boolean firstTable = true;
        boolean requiresEscape = false;
        boolean usesHistory = this.getBuilder() != null && this.getBuilder().hasAsOfClause();
        int nSize = this.getOuterJoinExpressions().size();
        ArrayList<OuterJoinExpressionHolder> outerJoinExpressionHolders = new ArrayList<OuterJoinExpressionHolder>(nSize);
        int index = 0;
        while (index < nSize) {
            outerJoinExpressionHolders.add(new OuterJoinExpressionHolder(index, usesHistory));
            ++index;
        }
        if (nSize > 1) {
            this.sortOuterJoinExpressionHolders(outerJoinExpressionHolders);
        }
        for (OuterJoinExpressionHolder holder : outerJoinExpressionHolders) {
            ObjectExpression outerExpression = holder.joinExpression;
            boolean isOuterJoin = outerExpression == null || outerExpression.shouldUseOuterJoin();
            int index2 = holder.index;
            DatabaseTable targetTable = holder.targetTable;
            DatabaseTable sourceTable = holder.sourceTable;
            DatabaseTable sourceAlias = holder.sourceAlias;
            DatabaseTable targetAlias = holder.targetAlias;
            if (outerJoinedAliases.contains(targetAlias)) continue;
            if (!outerJoinedAliases.contains(sourceAlias)) {
                if (requiresEscape && session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
                    writer.write("}");
                }
                if (!firstTable) {
                    writer.write(",");
                }
                if (platform.shouldUseJDBCOuterJoinSyntax()) {
                    writer.write(platform.getJDBCOuterJoinString());
                }
                requiresEscape = true;
                firstTable = false;
                sourceTable.printSQL(printer);
                outerJoinedAliases.add(sourceAlias);
                writer.write(" ");
                if (sourceAlias.isDecorated()) {
                    ((DecoratedDatabaseTable)sourceAlias).getAsOfClause().printSQL(printer);
                    writer.write(" ");
                }
                sourceAlias.printSQL(printer);
                this.printForUpdateClauseOnJoin(sourceAlias, printer, shouldPrintUpdateClauseForAllTables, aliasesOfTablesToBeLocked, platform);
            }
            if (outerExpression == null) {
                holder.printAdditionalJoins(printer, outerJoinedAliases, aliasesOfTablesToBeLocked, shouldPrintUpdateClauseForAllTables);
                continue;
            }
            DatabaseTable relationTable = outerExpression.getRelationTable();
            boolean hasAdditionalJoinExpressions = holder.hasAdditionalJoinExpressions();
            boolean isMapKeyObject = holder.hasMapKeyHolder();
            Expression additionalOnExpression = outerExpression.getOnClause();
            if (relationTable == null) {
                if (outerExpression.isDirectCollection()) {
                    Expression onExpression = this.getOuterJoinedMappingCriteria().get(index2);
                    DatabaseTable newAlias = onExpression.aliasForTable(targetTable);
                    if (isOuterJoin) {
                        writer.write(" LEFT OUTER JOIN ");
                    } else {
                        writer.write(" JOIN ");
                    }
                    targetTable.printSQL(printer);
                    writer.write(" ");
                    if (newAlias.isDecorated()) {
                        ((DecoratedDatabaseTable)newAlias).getAsOfClause().printSQL(printer);
                        writer.write(" ");
                    }
                    outerJoinedAliases.add(newAlias);
                    newAlias.printSQL(printer);
                    this.printForUpdateClauseOnJoin(newAlias, printer, shouldPrintUpdateClauseForAllTables, aliasesOfTablesToBeLocked, platform);
                    this.printOnClause(onExpression.and(additionalOnExpression), printer, platform);
                    continue;
                }
                if (isOuterJoin) {
                    writer.write(" LEFT OUTER JOIN ");
                } else {
                    writer.write(" JOIN ");
                }
                if (hasAdditionalJoinExpressions && platform.supportsNestingOuterJoins()) {
                    writer.write("(");
                }
                targetTable.printSQL(printer);
                writer.write(" ");
                if (targetAlias.isDecorated()) {
                    ((DecoratedDatabaseTable)targetAlias).getAsOfClause().printSQL(printer);
                    writer.write(" ");
                }
                outerJoinedAliases.add(targetAlias);
                targetAlias.printSQL(printer);
                this.printForUpdateClauseOnJoin(targetAlias, printer, shouldPrintUpdateClauseForAllTables, aliasesOfTablesToBeLocked, platform);
                if (hasAdditionalJoinExpressions && platform.supportsNestingOuterJoins()) {
                    holder.printAdditionalJoins(printer, outerJoinedAliases, aliasesOfTablesToBeLocked, shouldPrintUpdateClauseForAllTables);
                    writer.write(")");
                }
                Expression sourceToTargetJoin = this.getOuterJoinedMappingCriteria().get(index2);
                if (additionalOnExpression != null) {
                    sourceToTargetJoin = sourceToTargetJoin == null ? additionalOnExpression : sourceToTargetJoin.and(additionalOnExpression);
                }
                this.printOnClause(sourceToTargetJoin, printer, platform);
                if (!hasAdditionalJoinExpressions || platform.supportsNestingOuterJoins()) continue;
                holder.printAdditionalJoins(printer, outerJoinedAliases, aliasesOfTablesToBeLocked, shouldPrintUpdateClauseForAllTables);
                continue;
            }
            DatabaseTable relationAlias = this.getOuterJoinedMappingCriteria().get(index2).aliasForTable(relationTable);
            DatabaseTable mapKeyAlias = null;
            DatabaseTable mapKeyTable = null;
            ArrayList<DatabaseTable> tablesInOrder = new ArrayList<DatabaseTable>();
            tablesInOrder.add(sourceAlias);
            tablesInOrder.add(relationAlias);
            tablesInOrder.add(targetAlias);
            if (isMapKeyObject) {
                mapKeyAlias = holder.mapKeyHolder.targetAlias;
                mapKeyTable = holder.mapKeyHolder.targetTable;
                tablesInOrder.add(mapKeyAlias);
            }
            TreeMap indexToExpressionMap = new TreeMap();
            SQLSelectStatement.mapTableIndexToExpression(this.getOuterJoinedMappingCriteria().get(index2), indexToExpressionMap, tablesInOrder);
            Expression sourceToRelationJoin = (Expression)indexToExpressionMap.get(1);
            Expression relationToTargetJoin = (Expression)indexToExpressionMap.get(2);
            Expression relationToKeyJoin = null;
            if (isMapKeyObject) {
                relationToKeyJoin = (Expression)indexToExpressionMap.get(3);
            }
            if (outerExpression != null && outerExpression.shouldUseOuterJoin()) {
                writer.write(" LEFT OUTER JOIN ");
            } else {
                writer.write(" JOIN ");
            }
            if (platform.supportsNestingOuterJoins()) {
                writer.write("(");
            }
            relationTable.printSQL(printer);
            writer.write(" ");
            if (relationAlias.isDecorated()) {
                ((DecoratedDatabaseTable)relationAlias).getAsOfClause().printSQL(printer);
                writer.write(" ");
            }
            outerJoinedAliases.add(relationAlias);
            relationAlias.printSQL(printer);
            this.printForUpdateClauseOnJoin(relationAlias, printer, shouldPrintUpdateClauseForAllTables, aliasesOfTablesToBeLocked, platform);
            if (!platform.supportsNestingOuterJoins()) {
                this.printOnClause(sourceToRelationJoin.and(additionalOnExpression), printer, platform);
            }
            if (isMapKeyObject) {
                if (isOuterJoin && !session.getPlatform().supportsANSIInnerJoinSyntax()) {
                    writer.write(" LEFT OUTER");
                }
                writer.write(" JOIN ");
                mapKeyTable.printSQL(printer);
                writer.write(" ");
                if (mapKeyAlias.isDecorated()) {
                    ((DecoratedDatabaseTable)mapKeyAlias).getAsOfClause().printSQL(printer);
                    writer.write(" ");
                }
                outerJoinedAliases.add(mapKeyAlias);
                mapKeyAlias.printSQL(printer);
                this.printForUpdateClauseOnJoin(mapKeyAlias, printer, shouldPrintUpdateClauseForAllTables, aliasesOfTablesToBeLocked, platform);
                this.printOnClause(relationToKeyJoin.and(additionalOnExpression), printer, platform);
                if (holder.mapKeyHolder.hasAdditionalJoinExpressions()) {
                    holder.mapKeyHolder.printAdditionalJoins(printer, outerJoinedAliases, aliasesOfTablesToBeLocked, shouldPrintUpdateClauseForAllTables);
                }
            }
            if (isOuterJoin && !session.getPlatform().supportsANSIInnerJoinSyntax()) {
                writer.write(" LEFT OUTER");
            }
            writer.write(" JOIN ");
            targetTable.printSQL(printer);
            writer.write(" ");
            if (targetAlias.isDecorated()) {
                ((DecoratedDatabaseTable)targetAlias).getAsOfClause().printSQL(printer);
                writer.write(" ");
            }
            outerJoinedAliases.add(targetAlias);
            targetAlias.printSQL(printer);
            this.printForUpdateClauseOnJoin(targetAlias, printer, shouldPrintUpdateClauseForAllTables, aliasesOfTablesToBeLocked, platform);
            this.printOnClause(relationToTargetJoin, printer, platform);
            if (hasAdditionalJoinExpressions) {
                holder.printAdditionalJoins(printer, outerJoinedAliases, aliasesOfTablesToBeLocked, shouldPrintUpdateClauseForAllTables);
            }
            if (!platform.supportsNestingOuterJoins()) continue;
            writer.write(")");
            this.printOnClause(sourceToRelationJoin, printer, platform);
        }
        if (requiresEscape && session.getPlatform().shouldUseJDBCOuterJoinSyntax()) {
            writer.write("}");
        }
    }

    protected void printOnClause(Expression onClause, ExpressionSQLPrinter printer, DatabasePlatform platform) throws IOException {
        printer.getWriter().write(" ON ");
        if (!platform.supportsOuterJoinsWithBrackets()) {
            ((RelationExpression)onClause).printSQLNoParens(printer);
        } else {
            onClause.printSQL(printer);
        }
    }

    protected void printForUpdateClauseOnJoin(DatabaseTable alias, ExpressionSQLPrinter printer, boolean shouldPrintUpdateClauseForAllTables, Collection aliasesOfTablesToBeLocked, DatabasePlatform platform) {
        if (shouldPrintUpdateClauseForAllTables || aliasesOfTablesToBeLocked != null && aliasesOfTablesToBeLocked.remove(alias)) {
            this.getForUpdateClause().printSQL(printer, this);
        }
    }

    public void appendFromClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        Writer writer = printer.getWriter();
        AbstractSession session = printer.getSession();
        writer.write(" FROM ");
        boolean firstTable = true;
        ArrayList<DatabaseTable> outerJoinedAliases = new ArrayList<DatabaseTable>(4);
        boolean shouldPrintUpdateClause = !printer.getPlatform().shouldPrintLockingClauseAfterWhereClause() && this.getForUpdateClause() != null;
        Collection aliasesOfTablesToBeLocked = null;
        boolean shouldPrintUpdateClauseForAllTables = false;
        if (shouldPrintUpdateClause) {
            aliasesOfTablesToBeLocked = this.getForUpdateClause().getAliasesOfTablesToBeLocked(this);
            boolean bl = shouldPrintUpdateClauseForAllTables = aliasesOfTablesToBeLocked.size() == this.getTableAliases().size();
        }
        if (this.hasOuterJoinExpressions()) {
            if (session.getPlatform().isInformixOuterJoin()) {
                this.appendFromClauseForInformixOuterJoin(printer, outerJoinedAliases);
            } else if (!session.getPlatform().shouldPrintOuterJoinInWhereClause() || !session.getPlatform().shouldPrintInnerJoinInWhereClause()) {
                this.appendFromClauseForOuterJoin(printer, outerJoinedAliases, aliasesOfTablesToBeLocked, shouldPrintUpdateClauseForAllTables);
            }
            firstTable = false;
        }
        if (this.getTableAliases().isEmpty()) {
            throw QueryException.invalidBuilderInQuery(null);
        }
        for (DatabaseTable alias : this.getTableAliases().keySet()) {
            if (outerJoinedAliases.contains(alias)) continue;
            DatabaseTable table = this.getTableAliases().get(alias);
            if (this.requiresAliases()) {
                if (!firstTable) {
                    writer.write(", ");
                }
                firstTable = false;
                table.printSQL(printer);
                writer.write(" ");
                if (alias.isDecorated()) {
                    ((DecoratedDatabaseTable)alias).getAsOfClause().printSQL(printer);
                    writer.write(" ");
                }
                alias.printSQL(printer);
            } else {
                table.printSQL(printer);
                if (alias.isDecorated()) {
                    writer.write(" ");
                    ((DecoratedDatabaseTable)alias).getAsOfClause().printSQL(printer);
                }
            }
            if (!shouldPrintUpdateClause || !shouldPrintUpdateClauseForAllTables && !aliasesOfTablesToBeLocked.remove(alias)) continue;
            this.getForUpdateClause().printSQL(printer, this);
        }
    }

    public void appendGroupByClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        if (this.getGroupByExpressions().isEmpty()) {
            return;
        }
        printer.getWriter().write(" GROUP BY ");
        Vector newFields = new Vector();
        printer.setIsFirstElementPrinted(false);
        for (Expression expression : this.getGroupByExpressions()) {
            this.writeFieldsFromExpression(printer, expression, newFields);
        }
    }

    public void appendHierarchicalQueryClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        Expression startWith = this.getStartWithExpression();
        Expression connectBy = this.getConnectByExpression();
        List<Expression> orderSiblingsBy = this.getOrderSiblingsByExpressions();
        if (startWith != null) {
            printer.getWriter().write(" START WITH ");
            startWith.printSQL(printer);
        }
        if (connectBy != null) {
            if (!connectBy.isQueryKeyExpression()) {
                throw QueryException.illFormedExpression(connectBy);
            }
            printer.getWriter().write(" CONNECT BY ");
            DatabaseMapping mapping = ((QueryKeyExpression)connectBy).getMapping();
            ClassDescriptor descriptor = mapping.getDescriptor();
            Map<DatabaseField, DatabaseField> foreignKeys = null;
            if (mapping.isOneToManyMapping()) {
                OneToManyMapping otm = (OneToManyMapping)mapping;
                foreignKeys = otm.getTargetForeignKeyToSourceKeys();
            } else if (mapping.isOneToOneMapping()) {
                OneToOneMapping oto = (OneToOneMapping)mapping;
                foreignKeys = oto.getSourceToTargetKeyFields();
            } else if (mapping.isAggregateCollectionMapping()) {
                AggregateCollectionMapping acm = (AggregateCollectionMapping)mapping;
                foreignKeys = acm.getTargetForeignKeyToSourceKeys();
            } else {
                throw QueryException.invalidQueryKeyInExpression(connectBy);
            }
            DatabaseTable defaultTable = descriptor.getDefaultTable();
            String tableName = "";
            tableName = this.requiresAliases() ? this.getBuilder().aliasForTable(defaultTable).getName() : defaultTable.getNameDelimited(printer.getPlatform());
            if (foreignKeys != null && !foreignKeys.isEmpty()) {
                Iterator<DatabaseField> sourceKeys = foreignKeys.keySet().iterator();
                if (foreignKeys.size() > 1) {
                    printer.getWriter().write("((");
                }
                DatabaseField source = sourceKeys.next();
                DatabaseField target = foreignKeys.get(source);
                if (mapping.isOneToOneMapping()) {
                    printer.getWriter().write("PRIOR " + tableName + "." + source.getNameDelimited(printer.getPlatform()));
                    printer.getWriter().write(" = " + tableName + "." + target.getNameDelimited(printer.getPlatform()));
                } else {
                    printer.getWriter().write(String.valueOf(tableName) + "." + source.getNameDelimited(printer.getPlatform()));
                    printer.getWriter().write(" = PRIOR " + tableName + "." + target.getNameDelimited(printer.getPlatform()));
                }
                while (sourceKeys.hasNext()) {
                    printer.getWriter().write(") AND (");
                    source = sourceKeys.next();
                    target = foreignKeys.get(source);
                    if (mapping.isOneToOneMapping()) {
                        printer.getWriter().write("PRIOR " + tableName + "." + source.getNameDelimited(printer.getPlatform()));
                        printer.getWriter().write(" = " + tableName + "." + target.getNameDelimited(printer.getPlatform()));
                        continue;
                    }
                    printer.getWriter().write(String.valueOf(tableName) + "." + source.getNameDelimited(printer.getPlatform()));
                    printer.getWriter().write(" = PRIOR " + tableName + "." + target.getNameDelimited(printer.getPlatform()));
                }
                if (foreignKeys.size() > 1) {
                    printer.getWriter().write("))");
                }
            }
        }
        if (orderSiblingsBy != null) {
            printer.getWriter().write(" ORDER SIBLINGS BY ");
            Iterator<Expression> iterator = orderSiblingsBy.iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                expression.printSQL(printer);
                if (!iterator.hasNext()) continue;
                printer.getWriter().write(", ");
            }
        }
    }

    public void appendOrderClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        if (!this.hasOrderByExpressions()) {
            return;
        }
        printer.getWriter().write(" ORDER BY ");
        Iterator<Expression> expressionsEnum = this.getOrderByExpressions().iterator();
        while (expressionsEnum.hasNext()) {
            Expression expression = expressionsEnum.next();
            expression.printSQL(printer);
            if (!expressionsEnum.hasNext()) continue;
            printer.getWriter().write(", ");
        }
    }

    public void appendUnionClauseToWriter(ExpressionSQLPrinter printer) throws IOException {
        if (!this.hasUnionExpressions()) {
            return;
        }
        for (Expression expression : this.getUnionExpressions()) {
            printer.getWriter().write(" ");
            expression.printSQL(printer);
            printer.printString(")");
        }
    }

    public void assignAliases(Vector allExpressions) {
        this.currentAliasNumber = this.getCurrentAliasNumber();
        ExpressionIterator iterator = new ExpressionIterator(){

            @Override
            public void iterate(Expression each) {
                SQLSelectStatement.this.currentAliasNumber = each.assignTableAliasesStartingAt(SQLSelectStatement.this.currentAliasNumber);
            }
        };
        if (allExpressions.isEmpty()) {
            if (this.getBuilder() != null && this.requiresAliases()) {
                this.getBuilder().assignTableAliasesStartingAt(this.currentAliasNumber);
            }
        } else {
            Enumeration expressionEnum = allExpressions.elements();
            while (expressionEnum.hasMoreElements()) {
                Expression expression = (Expression)expressionEnum.nextElement();
                iterator.iterateOn(expression);
            }
        }
        this.setCurrentAliasNumber(this.currentAliasNumber);
    }

    public DatabaseCall buildCall(AbstractSession session, DatabaseQuery query) {
        SQLCall call = new SQLCall();
        call.setQuery(query);
        call.returnManyRows();
        CharArrayWriter writer = new CharArrayWriter(200);
        ExpressionSQLPrinter printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, this.requiresAliases(), this.getBuilder());
        printer.setWriter(writer);
        session.getPlatform().printSQLSelectStatement(call, printer, this);
        call.setSQLString(((Object)writer).toString());
        return call;
    }

    @Override
    public DatabaseCall buildCall(AbstractSession session) {
        return this.buildCall(session, null);
    }

    public void computeDistinct() {
        ExpressionIterator iterator = new ExpressionIterator(){

            @Override
            public void iterate(Expression expression) {
                if (expression.isQueryKeyExpression() && ((QueryKeyExpression)expression).shouldQueryToManyRelationship() && !SQLSelectStatement.this.isDistinctComputed()) {
                    SQLSelectStatement.this.useDistinct();
                }
            }
        };
        if (this.getWhereClause() != null) {
            iterator.iterateOn(this.getWhereClause());
        }
    }

    public boolean isSubSelect() {
        return this.getParentStatement() != null;
    }

    public void computeTables() {
        Expression expression;
        ExpressionIterator iterator = new ExpressionIterator(){

            @Override
            public void iterate(Expression each) {
                TableAliasLookup aliases = each.getTableAliases();
                if (aliases != null && !aliases.haveBeenAddedToStatement()) {
                    aliases.addToMap((Map)this.getResult());
                    aliases.setHaveBeenAddedToStatement(true);
                }
            }
        };
        iterator.setResult(new Hashtable(5));
        if (this.getWhereClause() != null) {
            iterator.iterateOn(this.getWhereClause());
        } else if (this.hasOuterJoinExpressions() && (expression = this.getOuterJoinedMappingCriteria().get(0)) != null) {
            iterator.iterateOn(expression);
        }
        for (Object e : this.getFields()) {
            if (!(e instanceof Expression)) continue;
            iterator.iterateOn((Expression)e);
        }
        if (this.hasNonSelectFields()) {
            for (Object object : this.getNonSelectFields()) {
                if (!(object instanceof Expression)) continue;
                iterator.iterateOn((Expression)object);
            }
        }
        iterator.iterateOn(this.getBuilder());
        Map map = (Map)iterator.getResult();
        this.setTableAliases(map);
        for (DatabaseTable table : map.values()) {
            this.addTable(table);
        }
    }

    public void computeTablesFromTables() {
        Hashtable<DatabaseTable, DatabaseTable> allTables = new Hashtable<DatabaseTable, DatabaseTable>();
        AsOfClause asOfClause = null;
        if (this.getBuilder().hasAsOfClause() && !this.getBuilder().getSession().getProject().hasGenericHistorySupport()) {
            asOfClause = this.getBuilder().getAsOfClause();
        }
        int index = 0;
        while (index < this.getTables().size()) {
            DatabaseTable next = this.getTables().get(index);
            DecoratedDatabaseTable alias = new DecoratedDatabaseTable("t" + index, asOfClause);
            allTables.put(alias, next);
            ++index;
        }
        this.setTableAliases(allTables);
    }

    public void dontUseDistinct() {
        this.setDistinctState((short)2);
    }

    protected boolean fieldsContainField(List fields, Expression expression) {
        if (!(expression instanceof DataExpression)) {
            return false;
        }
        DatabaseField orderByField = ((DataExpression)expression).getField();
        for (Object fieldOrExpression : fields) {
            if (fieldOrExpression instanceof DatabaseField) {
                DatabaseField field = (DatabaseField)fieldOrExpression;
                DataExpression exp = (DataExpression)expression;
                if (!field.equals(orderByField)) continue;
                while (((DataExpression)exp.getBaseExpression()).getMapping() instanceof AggregateObjectMapping) {
                    exp = (DataExpression)exp.getBaseExpression();
                }
                if (exp.getBaseExpression() != this.getBuilder()) continue;
                return true;
            }
            if (fieldOrExpression == null) continue;
            Expression exp = (Expression)fieldOrExpression;
            DatabaseTable table = orderByField.getTable();
            if (!exp.getFields().contains(orderByField) || !expression.aliasForTable(table).equals(exp.aliasForTable(table))) continue;
            return true;
        }
        return false;
    }

    public int getCurrentAliasNumber() {
        if (this.getParentStatement() != null) {
            return this.getParentStatement().getCurrentAliasNumber();
        }
        return this.currentAliasNumber;
    }

    public Vector getFields() {
        return this.fields;
    }

    protected ForUpdateClause getForUpdateClause() {
        return this.forUpdateClause;
    }

    public List<Expression> getGroupByExpressions() {
        if (this.groupByExpressions == null) {
            this.groupByExpressions = new ArrayList<Expression>();
        }
        return this.groupByExpressions;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    public Expression getStartWithExpression() {
        return this.startWithExpression;
    }

    public Expression getConnectByExpression() {
        return this.connectByExpression;
    }

    public List<Expression> getOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions;
    }

    public int getNextFieldCounterValue() {
        return ++this.fieldCounter;
    }

    public List<Object> getNonSelectFields() {
        return this.nonSelectFields;
    }

    public List<Expression> getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<Expression>(4);
        }
        return this.orderByExpressions;
    }

    public List<Expression> getUnionExpressions() {
        if (this.unionExpressions == null) {
            this.unionExpressions = new ArrayList<Expression>(4);
        }
        return this.unionExpressions;
    }

    public void setUnionExpressions(List<Expression> unionExpressions) {
        this.unionExpressions = unionExpressions;
    }

    public List<Map<DatabaseTable, Expression>> getOuterJoinedAdditionalJoinCriteria() {
        if (this.outerJoinedAdditionalJoinCriteria == null) {
            this.outerJoinedAdditionalJoinCriteria = new ArrayList<Map<DatabaseTable, Expression>>(4);
        }
        return this.outerJoinedAdditionalJoinCriteria;
    }

    public List<Expression> getOuterJoinedMappingCriteria() {
        if (this.outerJoinedMappingCriteria == null) {
            this.outerJoinedMappingCriteria = new ArrayList<Expression>(4);
        }
        return this.outerJoinedMappingCriteria;
    }

    public List<Expression> getOuterJoinExpressions() {
        if (this.outerJoinedExpressions == null) {
            this.outerJoinedExpressions = new ArrayList<Expression>(4);
        }
        return this.outerJoinedExpressions;
    }

    public List getDescriptorsForMultitableInheritanceOnly() {
        if (this.descriptorsForMultitableInheritanceOnly == null) {
            this.descriptorsForMultitableInheritanceOnly = new ArrayList(4);
        }
        return this.descriptorsForMultitableInheritanceOnly;
    }

    public SQLSelectStatement getParentStatement() {
        return this.parentStatement;
    }

    public Map<DatabaseTable, DatabaseTable> getTableAliases() {
        return this.tableAliases;
    }

    public List<DatabaseTable> getTables() {
        return this.tables;
    }

    public boolean getUseUniqueFieldAliases() {
        return this.useUniqueFieldAliases;
    }

    protected boolean hasAliasForTable(DatabaseTable table) {
        if (this.tableAliases != null) {
            return this.getTableAliases().containsKey(table);
        }
        return false;
    }

    public boolean hasGroupByExpressions() {
        return this.groupByExpressions != null && !this.groupByExpressions.isEmpty();
    }

    public boolean hasHavingExpression() {
        return this.havingExpression != null;
    }

    public boolean hasStartWithExpression() {
        return this.startWithExpression != null;
    }

    public boolean hasConnectByExpression() {
        return this.connectByExpression != null;
    }

    public boolean hasOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions != null && !this.orderSiblingsByExpressions.isEmpty();
    }

    public boolean hasHierarchicalQueryExpressions() {
        return this.startWithExpression != null || this.connectByExpression != null || this.orderSiblingsByExpressions != null && !this.orderSiblingsByExpressions.isEmpty();
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null && !this.orderByExpressions.isEmpty();
    }

    public boolean hasUnionExpressions() {
        return this.unionExpressions != null && !this.unionExpressions.isEmpty();
    }

    public boolean hasNonSelectFields() {
        return this.nonSelectFields != null && !this.nonSelectFields.isEmpty();
    }

    public boolean hasOuterJoinedAdditionalJoinCriteria() {
        return this.outerJoinedAdditionalJoinCriteria != null && !this.outerJoinedAdditionalJoinCriteria.isEmpty();
    }

    public boolean hasOuterJoinExpressions() {
        return this.outerJoinedExpressions != null && !this.outerJoinedExpressions.isEmpty();
    }

    public boolean isAggregateSelect() {
        return this.isAggregateSelect;
    }

    public boolean isDistinctComputed() {
        return this.distinctState != 0;
    }

    public final void normalize(AbstractSession session, ClassDescriptor descriptor) {
        this.normalize(session, descriptor, new IdentityHashMap());
    }

    public void normalize(AbstractSession session, ClassDescriptor descriptor, Map clonedExpressions) {
        Class queryClass;
        if (this.getBuilder() == null) {
            if (this.getWhereClause() == null) {
                this.setBuilder(new ExpressionBuilder());
            } else {
                this.setBuilder(this.getWhereClause().getBuilder());
            }
        }
        ExpressionBuilder builder = this.getBuilder();
        if (session.getAsOfClause() != null && !this.isSubSelect()) {
            this.getWhereClause().asOf(session.getAsOfClause());
        } else if (builder.hasAsOfClause() && builder.getAsOfClause().isUniversal()) {
            this.getWhereClause().asOf(((UniversalAsOfClause)builder.getAsOfClause()).getAsOfClause());
        }
        if (this.getWhereClause() == builder) {
            this.setWhereClause(null);
        }
        builder.setSession(session.getRootSession(null));
        if (!builder.doesNotRepresentAnObjectInTheQuery() && descriptor != null && ((queryClass = builder.getQueryClass()) == null || descriptor.isChildDescriptor())) {
            builder.setQueryClassAndDescriptor(descriptor.getJavaClass(), descriptor);
        }
        Vector<Expression> allExpressions = new Vector<Expression>();
        this.rebuildAndAddExpressions(this.getFields(), allExpressions, builder, clonedExpressions);
        if (this.hasNonSelectFields()) {
            this.rebuildAndAddExpressions(this.getNonSelectFields(), allExpressions, builder, clonedExpressions);
        }
        if (this.hasGroupByExpressions()) {
            this.rebuildAndAddExpressions(this.getGroupByExpressions(), allExpressions, builder, clonedExpressions);
        }
        if (this.hasUnionExpressions()) {
            this.rebuildAndAddExpressions(this.getUnionExpressions(), allExpressions, builder, clonedExpressions);
        }
        if (this.hasHavingExpression()) {
            Expression expression = this.getHavingExpression();
            ExpressionBuilder originalBuilder = expression.getBuilder();
            if (originalBuilder != builder) {
                expression = clonedExpressions.get(originalBuilder) != null ? expression.copiedVersionFrom(clonedExpressions) : expression.rebuildOn(builder);
                this.setHavingExpression(expression);
            }
            allExpressions.add(expression);
        }
        if (this.hasOrderByExpressions()) {
            this.normalizeOrderBy(builder, allExpressions, clonedExpressions, session);
        }
        if (this.hasOuterJoinExpressions()) {
            this.rebuildAndAddExpressions(this.getOuterJoinedMappingCriteria(), allExpressions, builder, clonedExpressions);
            Iterator<Map<DatabaseTable, Expression>> criterias = this.getOuterJoinedAdditionalJoinCriteria().iterator();
            while (criterias.hasNext()) {
                this.rebuildAndAddExpressions(criterias.next(), allExpressions, builder, clonedExpressions);
            }
        }
        if (this.hasStartWithExpression()) {
            this.startWithExpression = this.getStartWithExpression().rebuildOn(builder);
            allExpressions.add(this.startWithExpression);
        }
        if (this.hasConnectByExpression()) {
            this.connectByExpression = this.getConnectByExpression().rebuildOn(builder);
        }
        if (this.hasOrderSiblingsByExpressions()) {
            this.rebuildAndAddExpressions(this.getOrderSiblingsByExpressions(), allExpressions, builder, clonedExpressions);
        }
        Expression oldRoot = this.getWhereClause();
        ExpressionNormalizer normalizer = new ExpressionNormalizer(this);
        normalizer.setSession(session);
        normalizer.setClonedExpressions(clonedExpressions);
        Expression newRoot = null;
        if (oldRoot != null) {
            newRoot = oldRoot.normalize(normalizer);
        }
        if (descriptor != null) {
            builder.normalize(normalizer);
        }
        int index = 0;
        while (index < allExpressions.size()) {
            Expression expression = allExpressions.get(index);
            expression.getBuilder().setSession(session);
            expression.normalize(normalizer);
            ++index;
        }
        if (newRoot == null) {
            this.setNormalizedWhereClause(normalizer.getAdditionalExpression());
        } else {
            this.setNormalizedWhereClause(newRoot.and(normalizer.getAdditionalExpression()));
        }
        if (this.getWhereClause() != null) {
            allExpressions.add(this.getWhereClause());
        }
        if (descriptor != null) {
            allExpressions.add(builder);
        }
        if (this.hasOuterJoinExpressions()) {
            for (Expression expression : this.getOuterJoinedMappingCriteria()) {
                if (expression == null) continue;
                allExpressions.add(expression);
            }
            for (Map map : this.getOuterJoinedAdditionalJoinCriteria()) {
                if (map == null) continue;
                for (Expression criteria : map.values()) {
                    if (criteria == null) continue;
                    allExpressions.add(criteria);
                }
            }
        }
        this.assignAliases(allExpressions);
        if (descriptor == null) {
            this.computeTablesFromTables();
        } else {
            this.computeTables();
        }
        if (normalizer.encounteredSubSelectExpressions()) {
            normalizer.normalizeSubSelects(clonedExpressions);
        }
        if (this.hasOrderByExpressions()) {
            DatasourcePlatform datasourcePlatform;
            Class queryClass2 = null;
            if (descriptor != null) {
                queryClass2 = descriptor.getJavaClass();
            }
            if ((datasourcePlatform = (DatasourcePlatform)session.getPlatform(queryClass2)).shouldSelectIncludeOrderBy() || this.shouldDistinctBeUsed() && datasourcePlatform.shouldSelectDistinctIncludeOrderBy()) {
                this.addOrderByExpressionToSelectForDistinct();
            }
        }
    }

    public void normalizeForView(AbstractSession theSession, ClassDescriptor theDescriptor, Map clonedExpressions) {
        ExpressionBuilder builder;
        this.setRequiresAliases(true);
        if (this.getWhereClause() != null) {
            builder = this.getWhereClause().getBuilder();
        } else {
            builder = new ExpressionBuilder();
            this.setBuilder(builder);
        }
        builder.setViewTable(this.getTables().get(0));
        this.normalize(theSession, theDescriptor, clonedExpressions);
    }

    protected void normalizeOrderBy(Expression builder, List<Expression> allExpressions, Map<Expression, Expression> clonedExpressions, AbstractSession session) {
        ArrayList<Expression> newOrderBys = new ArrayList<Expression>(this.orderByExpressions.size());
        for (Expression orderBy : this.orderByExpressions) {
            Expression base = orderBy = this.rebuildExpression(orderBy, builder, clonedExpressions);
            Boolean asc = null;
            Boolean nullsFirst = null;
            if (orderBy.isFunctionExpression()) {
                if (base.getOperator().getSelector() == 139) {
                    nullsFirst = true;
                    base = (Expression)((FunctionExpression)base).getChildren().get(0);
                } else if (base.getOperator().getSelector() == 140) {
                    nullsFirst = false;
                    base = (Expression)((FunctionExpression)base).getChildren().get(0);
                }
                if (base.isFunctionExpression()) {
                    if (base.getOperator().getSelector() == 26) {
                        asc = true;
                        base = (Expression)((FunctionExpression)base).getChildren().get(0);
                    } else if (base.getOperator().getSelector() == 27) {
                        asc = false;
                        base = (Expression)((FunctionExpression)base).getChildren().get(0);
                    }
                }
            }
            if (base.isObjectExpression()) {
                ObjectExpression expression = (ObjectExpression)base;
                expression.getBuilder().setSession(session);
                List<Expression> orderBys = null;
                if (expression.getMapping() != null) {
                    orderBys = expression.getMapping().getOrderByNormalizedExpressions(expression);
                } else if (base.isExpressionBuilder()) {
                    orderBys = new ArrayList<Expression>(expression.getDescriptor().getPrimaryKeyFields().size());
                    for (DatabaseField field : expression.getDescriptor().getPrimaryKeyFields()) {
                        orderBys.add(expression.getField(field));
                    }
                }
                if (orderBys != null) {
                    for (Expression mappingOrderBy : orderBys) {
                        if (asc != null) {
                            mappingOrderBy = asc != false ? mappingOrderBy.ascending() : mappingOrderBy.descending();
                        }
                        if (nullsFirst != null) {
                            mappingOrderBy = nullsFirst != false ? mappingOrderBy.nullsFirst() : mappingOrderBy.nullsLast();
                        }
                        newOrderBys.add(mappingOrderBy);
                        allExpressions.add(mappingOrderBy);
                    }
                    continue;
                }
            }
            newOrderBys.add(orderBy);
            allExpressions.add(orderBy);
        }
        this.orderByExpressions = newOrderBys;
    }

    public Vector printSQL(ExpressionSQLPrinter printer) {
        try {
            Vector selectFields = null;
            printer.setRequiresDistinct(this.shouldDistinctBeUsed());
            if (this.hasUnionExpressions()) {
                int size = this.getUnionExpressions().size();
                int index = 0;
                while (index < size) {
                    printer.printString("(");
                    ++index;
                }
            }
            printer.printString("SELECT ");
            if (this.getHintString() != null) {
                printer.printString(this.getHintString());
                printer.printString(" ");
            }
            if (this.shouldDistinctBeUsed()) {
                printer.printString("DISTINCT ");
            }
            selectFields = this.writeFieldsIn(printer);
            this.setUseUniqueFieldAliases(false);
            this.appendFromClauseToWriter(printer);
            if (this.getWhereClause() != null) {
                printer.printString(" WHERE ");
                printer.printExpression(this.getWhereClause());
            }
            if (this.hasHierarchicalQueryExpressions()) {
                this.appendHierarchicalQueryClauseToWriter(printer);
            }
            if (this.hasGroupByExpressions()) {
                this.appendGroupByClauseToWriter(printer);
            }
            if (this.hasHavingExpression()) {
                printer.printString(" HAVING ");
                printer.printExpression(this.getHavingExpression());
            }
            if (this.hasOrderByExpressions()) {
                this.appendOrderClauseToWriter(printer);
            }
            if (printer.getPlatform().shouldPrintLockingClauseAfterWhereClause() && this.getForUpdateClause() != null) {
                this.getForUpdateClause().printSQL(printer, this);
            }
            if (this.hasUnionExpressions()) {
                this.appendUnionClauseToWriter(printer);
            }
            return selectFields;
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void rebuildAndAddExpressions(List expressions, List allExpressions, ExpressionBuilder primaryBuilder, Map clonedExpressions) {
        int index = 0;
        while (index < expressions.size()) {
            Object fieldOrExpression = expressions.get(index);
            if (fieldOrExpression instanceof FunctionField) {
                fieldOrExpression = ((FunctionField)fieldOrExpression).getExpression();
            }
            if (fieldOrExpression instanceof Expression) {
                Expression expression = this.rebuildExpression((Expression)fieldOrExpression, primaryBuilder, clonedExpressions);
                if (fieldOrExpression != expression) {
                    expressions.set(index, expression);
                }
                allExpressions.add(expression);
            }
            ++index;
        }
    }

    public Expression rebuildExpression(Expression expression, Expression primaryBuilder, Map<Expression, Expression> clonedExpressions) {
        ExpressionBuilder originalBuilder = expression.getBuilder();
        if (originalBuilder != primaryBuilder) {
            if (clonedExpressions.get(originalBuilder) != null) {
                expression = expression.copiedVersionFrom(clonedExpressions);
            }
            if (originalBuilder.wasQueryClassSetInternally()) {
                expression = expression.rebuildOn(primaryBuilder);
            }
        }
        return expression;
    }

    public void rebuildAndAddExpressions(Map expressions, Vector allExpressions, ExpressionBuilder primaryBuilder, Map clonedExpressions) {
        for (Map.Entry entry : expressions.entrySet()) {
            Object fieldOrExpression = entry.getValue();
            if (!(fieldOrExpression instanceof Expression)) continue;
            Expression expression = (Expression)fieldOrExpression;
            ExpressionBuilder originalBuilder = expression.getBuilder();
            if (originalBuilder != primaryBuilder) {
                if (clonedExpressions.get(originalBuilder) != null) {
                    expression = expression.copiedVersionFrom(clonedExpressions);
                }
                if (originalBuilder.wasQueryClassSetInternally()) {
                    expression = expression.rebuildOn(primaryBuilder);
                }
                entry.setValue(expression);
            }
            allExpressions.addElement(expression);
        }
    }

    public void removeField(DatabaseField field) {
        this.getFields().remove(field);
    }

    public void removeTable(DatabaseTable table) {
        this.getTables().remove(table);
    }

    public boolean requiresAliases() {
        if (this.requiresAliases || this.hasOuterJoinExpressions()) {
            return true;
        }
        if (this.tableAliases != null) {
            return this.getTableAliases().size() > 1;
        }
        return false;
    }

    public void resetDistinct() {
        this.setDistinctState((short)0);
    }

    @Override
    public void setBuilder(ExpressionBuilder builder) {
        this.builder = builder;
    }

    public void setCurrentAliasNumber(int currentAliasNumber) {
        if (this.getParentStatement() != null) {
            this.getParentStatement().setCurrentAliasNumber(currentAliasNumber);
        } else {
            this.currentAliasNumber = currentAliasNumber;
        }
    }

    public void setNonSelectFields(List nonSelectFields) {
        this.nonSelectFields = nonSelectFields;
    }

    public void setNormalizedWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
    }

    public void setDistinctState(short distinctState) {
        this.distinctState = distinctState;
    }

    public void setFields(Vector fields) {
        for (Object fieldOrExpression : fields) {
            if (!(fieldOrExpression instanceof FunctionExpression) || !((FunctionExpression)fieldOrExpression).getOperator().isAggregateOperator()) continue;
            this.setIsAggregateSelect(true);
            break;
        }
        this.fields = fields;
    }

    public void setGroupByExpressions(List<Expression> expressions) {
        this.groupByExpressions = expressions;
    }

    public void setHavingExpression(Expression expressions) {
        this.havingExpression = expressions;
    }

    public void setHierarchicalQueryExpressions(Expression startWith, Expression connectBy, List<Expression> orderSiblingsExpressions) {
        this.startWithExpression = startWith;
        this.connectByExpression = connectBy;
        this.orderSiblingsByExpressions = orderSiblingsExpressions;
    }

    public void setIsAggregateSelect(boolean isAggregateSelect) {
        this.isAggregateSelect = isAggregateSelect;
    }

    protected void setForUpdateClause(ForUpdateClause clause) {
        this.forUpdateClause = clause;
    }

    public void setLockingClause(ForUpdateClause lockingClause) {
        this.forUpdateClause = lockingClause;
    }

    public void setOrderByExpressions(List<Expression> orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
    }

    public void setOuterJoinedAdditionalJoinCriteria(List<Map<DatabaseTable, Expression>> outerJoinedAdditionalJoinCriteria) {
        this.outerJoinedAdditionalJoinCriteria = outerJoinedAdditionalJoinCriteria;
    }

    public void setOuterJoinedMappingCriteria(List<Expression> outerJoinedMappingCriteria) {
        this.outerJoinedMappingCriteria = outerJoinedMappingCriteria;
    }

    public void setOuterJoinExpressions(List<Expression> outerJoinedExpressions) {
        this.outerJoinedExpressions = outerJoinedExpressions;
    }

    public void setParentStatement(SQLSelectStatement parentStatement) {
        this.parentStatement = parentStatement;
    }

    public void setQuery(ReadQuery query) {
        this.query = query;
    }

    public void setRequiresAliases(boolean requiresAliases) {
        this.requiresAliases = requiresAliases;
    }

    protected void setTableAliases(Map<DatabaseTable, DatabaseTable> theTableAliases) {
        this.tableAliases = theTableAliases;
    }

    public void setTables(List<DatabaseTable> theTables) {
        this.tables = theTables;
    }

    public void setUseUniqueFieldAliases(boolean useUniqueFieldAliases) {
        this.useUniqueFieldAliases = useUniqueFieldAliases;
    }

    public boolean shouldDistinctBeUsed() {
        return this.distinctState == 1;
    }

    public void useDistinct() {
        this.setDistinctState((short)1);
    }

    protected void writeField(ExpressionSQLPrinter printer, DatabaseField field) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (printer.shouldPrintQualifiedNames()) {
            if (field.getTable() != this.lastTable) {
                this.lastTable = field.getTable();
                this.currentAlias = this.getBuilder().aliasForTable(this.lastTable);
                if (this.currentAlias == null) {
                    this.currentAlias = this.lastTable;
                }
            }
            printer.printString(this.currentAlias.getQualifiedNameDelimited(printer.getPlatform()));
            printer.printString(".");
            printer.printString(field.getNameDelimited(printer.getPlatform()));
        } else {
            printer.printString(field.getNameDelimited(printer.getPlatform()));
        }
        if (this.getUseUniqueFieldAliases()) {
            printer.printString(" AS " + this.generatedAlias(field.getNameDelimited(printer.getPlatform())));
        }
    }

    public String generatedAlias(String fieldName) {
        return "a" + String.valueOf(this.getNextFieldCounterValue());
    }

    protected void writeFieldsFromExpression(ExpressionSQLPrinter printer, Expression expression, Vector newFields) {
        expression.writeFields(printer, newFields, this);
    }

    protected Vector writeFieldsIn(ExpressionSQLPrinter printer) {
        this.lastTable = null;
        NonSynchronizedVector newFields = NonSynchronizedVector.newInstance();
        for (Object next : this.getFields()) {
            if (next == null) continue;
            if (next instanceof Expression) {
                this.writeFieldsFromExpression(printer, (Expression)next, newFields);
                continue;
            }
            this.writeField(printer, (DatabaseField)next);
            ((Vector)newFields).add(next);
        }
        return newFields;
    }

    public static SortedSet mapTableIndexToExpression(Expression expression, TreeMap map, List<DatabaseTable> tablesInOrder) {
        TreeSet<Integer> tables = new TreeSet<Integer>();
        if (expression instanceof DataExpression) {
            DataExpression de = (DataExpression)expression;
            if (de.getAliasedField() != null) {
                tables.add(tablesInOrder.indexOf(de.getAliasedField().getTable()));
            }
            return tables;
        }
        TreeMap originalMap = (TreeMap)map.clone();
        if (expression instanceof CompoundExpression) {
            CompoundExpression ce = (CompoundExpression)expression;
            tables.addAll(SQLSelectStatement.mapTableIndexToExpression(ce.getFirstChild(), map, tablesInOrder));
            tables.addAll(SQLSelectStatement.mapTableIndexToExpression(ce.getSecondChild(), map, tablesInOrder));
        } else if (expression instanceof FunctionExpression) {
            FunctionExpression fe = (FunctionExpression)expression;
            Iterator it = fe.getChildren().iterator();
            while (it.hasNext()) {
                tables.addAll(SQLSelectStatement.mapTableIndexToExpression((Expression)it.next(), map, tablesInOrder));
            }
        }
        if (tables.size() == 2) {
            Object last = tables.last();
            Expression cachedExpression = (Expression)originalMap.get(last);
            if (cachedExpression == null) {
                map.put(last, expression);
            } else {
                map.put(last, cachedExpression.and(expression));
            }
        }
        return tables;
    }

    public static Map mapTableToExpression(Expression expression, Vector tablesInOrder) {
        TreeMap indexToExpressionMap = new TreeMap();
        SQLSelectStatement.mapTableIndexToExpression(expression, indexToExpressionMap, tablesInOrder);
        HashMap map = new HashMap(indexToExpressionMap.size());
        for (Map.Entry entry : indexToExpressionMap.entrySet()) {
            int index = (Integer)entry.getKey();
            map.put(tablesInOrder.get(index), entry.getValue());
        }
        return map;
    }

    protected void sortOuterJoinExpressionHolders(List<OuterJoinExpressionHolder> holders) {
        HashMap<DatabaseTable, OuterJoinExpressionHolder> targetAliasToHolders = new HashMap<DatabaseTable, OuterJoinExpressionHolder>();
        HashSet<DatabaseTable> aliases = new HashSet<DatabaseTable>();
        HashMap<DatabaseTable, Integer> aliasToIndexes = new HashMap<DatabaseTable, Integer>(aliases.size());
        int i = 0;
        for (OuterJoinExpressionHolder holder : holders) {
            targetAliasToHolders.put(holder.targetAlias, holder);
            if (!aliases.contains(holder.sourceAlias)) {
                aliases.add(holder.sourceAlias);
                aliasToIndexes.put(holder.sourceAlias, i++);
            }
            if (!aliases.contains(holder.targetAlias)) {
                aliases.add(holder.targetAlias);
                aliasToIndexes.put(holder.targetAlias, i++);
            }
            if (holder.additionalTargetAliases == null) continue;
            for (DatabaseTable alias : holder.additionalTargetAliases) {
                if (!aliases.contains(alias)) {
                    aliases.add(alias);
                    aliasToIndexes.put(alias, i++);
                }
                targetAliasToHolders.put(alias, holder);
            }
        }
        for (OuterJoinExpressionHolder holder : holders) {
            holder.createIndexList(targetAliasToHolders, aliasToIndexes);
        }
        Collections.sort(holders);
    }

    class OuterJoinExpressionHolder
    implements Comparable {
        final ObjectExpression joinExpression;
        final int index;
        DatabaseTable targetTable;
        DatabaseTable sourceTable;
        final DatabaseTable targetAlias;
        final DatabaseTable sourceAlias;
        List<DatabaseTable> additionalTargetTables;
        List<DatabaseTable> additionalTargetAliases;
        List<Expression> additionalJoinOnExpression;
        List<Boolean> additionalTargetIsDescriptorTable;
        Boolean hasInheritance;
        List<Integer> indexList;
        OuterJoinExpressionHolder mapKeyHolder;
        boolean isMapKeyHolder;

        public OuterJoinExpressionHolder(int index, boolean usesHistory) {
            this(index, usesHistory, false);
        }

        protected OuterJoinExpressionHolder(int index, boolean usesHistory, boolean isMapKeyHolder) {
            Map<DatabaseTable, Expression> tablesJoinExpression;
            this.joinExpression = (ObjectExpression)SQLSelectStatement.this.getOuterJoinExpressions().get(index);
            this.index = index;
            this.isMapKeyHolder = isMapKeyHolder;
            ClassDescriptor descriptor = null;
            if (this.joinExpression instanceof QueryKeyExpression) {
                QueryKeyExpression expression = (QueryKeyExpression)this.joinExpression;
                if (isMapKeyHolder) {
                    descriptor = expression.getMapKeyDescriptor();
                    this.targetTable = descriptor.getTables().get(0);
                    this.targetAlias = SQLSelectStatement.this.getOuterJoinedMappingCriteria().get(index).aliasForTable(this.targetTable);
                } else {
                    if (expression.isMapKeyObjectRelationship()) {
                        this.mapKeyHolder = new OuterJoinExpressionHolder(index, usesHistory, true);
                    }
                    descriptor = expression.getDescriptor();
                    this.targetTable = expression.getReferenceTable();
                    this.targetAlias = expression.aliasForTable(this.targetTable);
                }
                this.sourceTable = expression.getSourceTable();
                this.sourceAlias = expression.getBaseExpression().aliasForTable(this.sourceTable);
            } else if (this.joinExpression != null) {
                this.sourceTable = ((ObjectExpression)this.joinExpression.getJoinSource()).getDescriptor().getTables().get(0);
                this.sourceAlias = this.joinExpression.getJoinSource().aliasForTable(this.sourceTable);
                this.targetTable = this.joinExpression.getDescriptor().getTables().get(0);
                this.targetAlias = this.joinExpression.aliasForTable(this.targetTable);
            } else {
                descriptor = (ClassDescriptor)SQLSelectStatement.this.getDescriptorsForMultitableInheritanceOnly().get(index);
                this.sourceTable = descriptor.getTables().get(0);
                this.targetTable = descriptor.getInheritancePolicy().getChildrenTables().get(0);
                Expression exp = SQLSelectStatement.this.getOuterJoinedAdditionalJoinCriteria().get(index).get(this.targetTable);
                this.sourceAlias = exp.aliasForTable(this.sourceTable);
                this.targetAlias = exp.aliasForTable(this.targetTable);
            }
            if (usesHistory) {
                this.sourceTable = SQLSelectStatement.this.getTableAliases().get(this.sourceAlias);
                this.targetTable = SQLSelectStatement.this.getTableAliases().get(this.targetAlias);
            }
            if ((tablesJoinExpression = SQLSelectStatement.this.getOuterJoinedAdditionalJoinCriteria().get(index)) != null && !tablesJoinExpression.isEmpty()) {
                if (descriptor == null) {
                    descriptor = this.joinExpression.getDescriptor();
                }
                Vector targetTables = descriptor.getTables();
                int nDescriptorTables = targetTables.size();
                this.hasInheritance = descriptor.hasInheritance();
                if (this.hasInheritance.booleanValue()) {
                    targetTables = descriptor.getInheritancePolicy().getAllTables();
                }
                int tablesSize = targetTables.size();
                int i = 1;
                while (i < tablesSize) {
                    DatabaseTable table = (DatabaseTable)targetTables.get(i);
                    Expression onExpression = tablesJoinExpression.get(table);
                    if (onExpression != null) {
                        DatabaseTable alias = onExpression.aliasForTable(table);
                        if (usesHistory) {
                            table = SQLSelectStatement.this.getTableAliases().get(alias);
                        }
                        if (this.additionalTargetAliases == null) {
                            this.additionalTargetAliases = new ArrayList<DatabaseTable>();
                            this.additionalTargetTables = new ArrayList<DatabaseTable>();
                            this.additionalJoinOnExpression = new ArrayList<Expression>();
                            this.additionalTargetIsDescriptorTable = new ArrayList<Boolean>();
                        }
                        this.additionalTargetAliases.add(alias);
                        this.additionalTargetTables.add(table);
                        this.additionalJoinOnExpression.add(onExpression);
                        this.additionalTargetIsDescriptorTable.add(i < nDescriptorTables);
                    }
                    ++i;
                }
            }
        }

        public boolean hasAdditionalJoinExpressions() {
            return this.additionalTargetTables != null;
        }

        public boolean hasMapKeyHolder() {
            return this.mapKeyHolder != null;
        }

        public void createIndexList(Map<DatabaseTable, OuterJoinExpressionHolder> targetAliasToHolders, Map<DatabaseTable, Integer> aliasToIndexes) {
            if (this.indexList != null) {
                return;
            }
            this.indexList = new ArrayList<Integer>();
            OuterJoinExpressionHolder baseHolder = targetAliasToHolders.get(this.sourceAlias);
            if (baseHolder != null) {
                baseHolder.createIndexList(targetAliasToHolders, aliasToIndexes);
                this.indexList.addAll(baseHolder.indexList);
            } else {
                this.indexList.add(aliasToIndexes.get(this.sourceAlias));
            }
            this.indexList.add(aliasToIndexes.get(this.targetAlias));
        }

        public int compareTo(Object other) {
            if (other == this) {
                return 0;
            }
            List<Integer> otherIndexList = ((OuterJoinExpressionHolder)other).indexList;
            int nMinSize = this.indexList.size();
            int nCompare = -1;
            int nOtherSize = otherIndexList.size();
            if (nMinSize > nOtherSize) {
                nMinSize = nOtherSize;
                nCompare = 1;
            } else if (nMinSize == nOtherSize) {
                nCompare = 0;
            }
            int i = 0;
            while (i < nMinSize) {
                int otherIndex;
                int index = this.indexList.get(i);
                if (index < (otherIndex = otherIndexList.get(i).intValue())) {
                    return -1;
                }
                if (index > otherIndex) {
                    return 1;
                }
                ++i;
            }
            return nCompare;
        }

        void printAdditionalJoins(ExpressionSQLPrinter printer, List<DatabaseTable> outerJoinedAliases, Collection aliasesOfTablesToBeLocked, boolean shouldPrintUpdateClauseForAllTables) throws IOException {
            Writer writer = printer.getWriter();
            AbstractSession session = printer.getSession();
            int size = this.additionalTargetAliases.size();
            int i = 0;
            while (i < size) {
                DatabaseTable table = this.additionalTargetTables.get(i);
                if (this.additionalTargetIsDescriptorTable.get(i).booleanValue()) {
                    if (!session.getPlatform().supportsANSIInnerJoinSyntax()) {
                        if (this.hasInheritance.booleanValue()) {
                            writer.write(" RIGHT OUTER");
                        } else {
                            writer.write(" LEFT OUTER");
                        }
                    }
                    writer.write(" JOIN ");
                } else {
                    writer.write(" LEFT OUTER JOIN ");
                }
                DatabaseTable alias = this.additionalTargetAliases.get(i);
                table.printSQL(printer);
                writer.write(" ");
                if (alias.isDecorated()) {
                    ((DecoratedDatabaseTable)alias).getAsOfClause().printSQL(printer);
                    writer.write(" ");
                }
                outerJoinedAliases.add(alias);
                alias.printSQL(printer);
                if (shouldPrintUpdateClauseForAllTables || aliasesOfTablesToBeLocked != null && aliasesOfTablesToBeLocked.remove(alias)) {
                    SQLSelectStatement.this.getForUpdateClause().printSQL(printer, SQLSelectStatement.this);
                }
                writer.write(" ON ");
                if (session.getPlatform() instanceof DB2MainframePlatform) {
                    ((RelationExpression)this.additionalJoinOnExpression.get(i)).printSQLNoParens(printer);
                } else {
                    this.additionalJoinOnExpression.get(i).printSQL(printer);
                }
                ++i;
            }
        }
    }
}

