/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.SharedUtils;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationCase {
    private final String fromViewId;
    private final String fromAction;
    private final String fromOutcome;
    private final String condition;
    private final String toViewId;
    private final Map<String, List<String>> parameters;
    private final boolean redirect;
    private final boolean includeViewParams;
    private ValueExpression toViewIdExpr;
    private ValueExpression conditionExpr;
    private String toString;
    private int hashCode;

    public NavigationCase(String fromViewId, String fromAction, String fromOutcome, String condition, String toViewId, Map<String, List<String>> parameters, boolean redirect, boolean includeViewParams) {
        this.fromViewId = fromViewId;
        this.fromAction = fromAction;
        this.fromOutcome = fromOutcome;
        this.condition = condition;
        this.toViewId = toViewId;
        this.parameters = parameters;
        this.redirect = redirect;
        this.includeViewParams = includeViewParams;
    }

    public URL getActionURL(FacesContext context) throws MalformedURLException {
        ExternalContext extContext = context.getExternalContext();
        return new URL(extContext.getRequestScheme(), extContext.getRequestServerName(), extContext.getRequestServerPort(), context.getApplication().getViewHandler().getActionURL(context, this.getToViewId(context)));
    }

    public URL getResourceURL(FacesContext context) throws MalformedURLException {
        ExternalContext extContext = context.getExternalContext();
        return new URL(extContext.getRequestScheme(), extContext.getRequestServerName(), extContext.getRequestServerPort(), context.getApplication().getViewHandler().getResourceURL(context, this.getToViewId(context)));
    }

    public URL getRedirectURL(FacesContext context) throws MalformedURLException {
        ExternalContext extContext = context.getExternalContext();
        return new URL(extContext.getRequestScheme(), extContext.getRequestServerName(), extContext.getRequestServerPort(), context.getApplication().getViewHandler().getRedirectURL(context, this.getToViewId(context), SharedUtils.evaluateExpressions(context, this.getParameters()), this.isIncludeViewParams()));
    }

    public URL getBookmarkableURL(FacesContext context) throws MalformedURLException {
        ExternalContext extContext = context.getExternalContext();
        return new URL(extContext.getRequestScheme(), extContext.getRequestServerName(), extContext.getRequestServerPort(), context.getApplication().getViewHandler().getBookmarkableURL(context, this.getToViewId(context), this.getParameters(), this.isIncludeViewParams()));
    }

    public String getFromViewId() {
        return this.fromViewId;
    }

    public String getFromAction() {
        return this.fromAction;
    }

    public String getFromOutcome() {
        return this.fromOutcome;
    }

    public String getToViewId(FacesContext context) {
        String toViewId;
        if (this.toViewIdExpr == null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this.toViewIdExpr = factory.createValueExpression(context.getELContext(), this.toViewId, String.class);
        }
        if ((toViewId = (String)this.toViewIdExpr.getValue(context.getELContext())).charAt(0) != '/') {
            toViewId = '/' + toViewId;
        }
        return toViewId;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public Boolean getCondition(FacesContext context) {
        if (this.conditionExpr == null && this.condition != null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this.conditionExpr = factory.createValueExpression(context.getELContext(), this.condition, Boolean.class);
        }
        return this.conditionExpr != null ? (Boolean)this.conditionExpr.getValue(context.getELContext()) : null;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean isIncludeViewParams() {
        return this.includeViewParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavigationCase that = (NavigationCase)o;
        return !(this.redirect != that.redirect || (this.fromAction == null ? that.fromAction != null : !this.fromAction.equals(that.fromAction)) || (this.fromOutcome == null ? that.fromOutcome != null : !this.fromOutcome.equals(that.fromOutcome)) || (this.condition == null ? that.condition != null : !this.condition.equals(that.condition)) || (this.fromViewId == null ? that.fromViewId != null : !this.fromViewId.equals(that.fromViewId)) || (this.toViewId == null ? that.toViewId != null : !this.toViewId.equals(that.toViewId)) || (this.parameters == null ? that.parameters != null : !((Object)this.parameters).equals(that.parameters)));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.fromViewId != null ? this.fromViewId.hashCode() : 0;
            result = 31 * result + (this.fromAction != null ? this.fromAction.hashCode() : 0);
            result = 31 * result + (this.fromOutcome != null ? this.fromOutcome.hashCode() : 0);
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            result = 31 * result + (this.toViewId != null ? this.toViewId.hashCode() : 0);
            result = 31 * result + (this.redirect ? 1 : 0);
            this.hashCode = result = 31 * result + (this.parameters != null ? ((Object)this.parameters).hashCode() : 0);
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("NavigationCase{");
            sb.append("fromViewId='").append(this.fromViewId).append('\'');
            sb.append(", fromAction='").append(this.fromAction).append('\'');
            sb.append(", fromOutcome='").append(this.fromOutcome).append('\'');
            sb.append(", if='").append(this.condition).append('\'');
            sb.append(", toViewId='").append(this.toViewId).append('\'');
            sb.append(", faces-redirect=").append(this.redirect);
            sb.append(", includeViewParams=").append(this.includeViewParams).append('\'');
            sb.append(", parameters=").append(this.parameters != null ? this.parameters.toString() : "");
            sb.append('}');
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

