/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.xbean.asm.ClassReader;
import org.apache.xbean.asm.ClassVisitor;
import org.apache.xbean.asm.Label;
import org.apache.xbean.asm.MethodVisitor;
import org.apache.xbean.asm.Type;
import org.apache.xbean.asm.commons.EmptyVisitor;
import org.apache.xbean.recipe.ParameterNameLoader;
import org.apache.xbean.recipe.ReflectionUtil;

public class AsmParameterNameLoader
implements ParameterNameLoader {
    private final WeakHashMap<Constructor, List<String>> constructorCache = new WeakHashMap();
    private final WeakHashMap<Method, List<String>> methodCache = new WeakHashMap();

    public static void install() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Field field = ReflectionUtil.class.getDeclaredField("parameterNamesLoader");
                    field.setAccessible(true);
                    field.set(null, new AsmParameterNameLoader());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public List<String> get(Method method) {
        if (this.methodCache.containsKey(method)) {
            return this.methodCache.get(method);
        }
        Map<Method, List<String>> allMethodParameters = this.getAllMethodParameters(method.getDeclaringClass(), method.getName());
        return allMethodParameters.get(method);
    }

    public List<String> get(Constructor constructor) {
        if (this.constructorCache.containsKey(constructor)) {
            return this.constructorCache.get(constructor);
        }
        Map<Constructor, List<String>> allConstructorParameters = this.getAllConstructorParameters(constructor.getDeclaringClass());
        return allConstructorParameters.get(constructor);
    }

    public Map<Constructor, List<String>> getAllConstructorParameters(Class clazz) {
        ArrayList constructors = new ArrayList(Arrays.asList(clazz.getConstructors()));
        constructors.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
        if (constructors.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.constructorCache.containsKey(constructors.get(0))) {
            HashMap<Constructor, List<String>> constructorParameters = new HashMap<Constructor, List<String>>();
            for (Constructor constructor : constructors) {
                constructorParameters.put(constructor, this.constructorCache.get(constructor));
            }
            return constructorParameters;
        }
        Map<Constructor, List<String>> constructorParameters = new HashMap<Constructor, List<String>>();
        try {
            ClassReader reader = AsmParameterNameLoader.createClassReader(clazz);
            AllParameterNamesDiscoveringVisitor allParameterNamesDiscoveringVisitor = new AllParameterNamesDiscoveringVisitor(clazz);
            reader.accept((ClassVisitor)allParameterNamesDiscoveringVisitor, 0);
            Map<String, Exception> exceptions = allParameterNamesDiscoveringVisitor.getExceptions();
            if (exceptions.size() == 1) {
                throw new RuntimeException(exceptions.values().iterator().next());
            }
            if (!exceptions.isEmpty()) {
                throw new RuntimeException(exceptions.toString());
            }
            constructorParameters = allParameterNamesDiscoveringVisitor.getConstructorParameters();
        }
        catch (IOException ex) {
            // empty catch block
        }
        for (Constructor constructor : constructors) {
            this.constructorCache.put(constructor, (List<String>)constructorParameters.get(constructor));
        }
        return constructorParameters;
    }

    public Map<Method, List<String>> getAllMethodParameters(Class clazz, String methodName) {
        Method[] methods = this.getMethods(clazz, methodName);
        if (methods.length == 0) {
            return Collections.emptyMap();
        }
        if (this.methodCache.containsKey(methods[0])) {
            HashMap<Method, List<String>> methodParameters = new HashMap<Method, List<String>>();
            for (Method method : methods) {
                methodParameters.put(method, this.methodCache.get(method));
            }
            return methodParameters;
        }
        Map<Method, List<String>> methodParameters = new HashMap<Method, List<String>>();
        try {
            ClassReader reader = AsmParameterNameLoader.createClassReader(clazz);
            AllParameterNamesDiscoveringVisitor visitor = new AllParameterNamesDiscoveringVisitor(clazz, methodName);
            reader.accept((ClassVisitor)visitor, 0);
            Map<String, Exception> exceptions = visitor.getExceptions();
            if (exceptions.size() == 1) {
                throw new RuntimeException(exceptions.values().iterator().next());
            }
            if (!exceptions.isEmpty()) {
                throw new RuntimeException(exceptions.toString());
            }
            methodParameters = visitor.getMethodParameters();
        }
        catch (IOException ex) {
            // empty catch block
        }
        for (Method method : methods) {
            this.methodCache.put(method, (List<String>)methodParameters.get(method));
        }
        return methodParameters;
    }

    private Method[] getMethods(Class clazz, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clazz.getMethods()));
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        ArrayList<Method> matchingMethod = new ArrayList<Method>(methods.size());
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            matchingMethod.add(method);
        }
        return matchingMethod.toArray(new Method[matchingMethod.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassReader createClassReader(Class declaringClass) throws IOException {
        InputStream in = null;
        try {
            ClassReader reader;
            ClassLoader classLoader = declaringClass.getClassLoader();
            in = classLoader.getResourceAsStream(declaringClass.getName().replace('.', '/') + ".class");
            ClassReader classReader = reader = new ClassReader(in);
            return classReader;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static class AllParameterNamesDiscoveringVisitor
    extends EmptyVisitor {
        private final Map<Constructor, List<String>> constructorParameters = new HashMap<Constructor, List<String>>();
        private final Map<Method, List<String>> methodParameters = new HashMap<Method, List<String>>();
        private final Map<String, Exception> exceptions = new HashMap<String, Exception>();
        private final String methodName;
        private final Map<String, Method> methodMap = new HashMap<String, Method>();
        private final Map<String, Constructor> constructorMap = new HashMap<String, Constructor>();

        public AllParameterNamesDiscoveringVisitor(Class type, String methodName) {
            this.methodName = methodName;
            ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(type.getMethods()));
            methods.addAll(Arrays.asList(type.getDeclaredMethods()));
            for (Method method : methods) {
                if (!method.getName().equals(methodName)) continue;
                this.methodMap.put(Type.getMethodDescriptor((Method)method), method);
            }
        }

        public AllParameterNamesDiscoveringVisitor(Class type) {
            this.methodName = "<init>";
            ArrayList constructors = new ArrayList(Arrays.asList(type.getConstructors()));
            constructors.addAll(Arrays.asList(type.getDeclaredConstructors()));
            for (Constructor constructor : constructors) {
                Type[] types = new Type[constructor.getParameterTypes().length];
                for (int j = 0; j < types.length; ++j) {
                    types[j] = Type.getType(constructor.getParameterTypes()[j]);
                }
                this.constructorMap.put(Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])types), constructor);
            }
        }

        public Map<Constructor, List<String>> getConstructorParameters() {
            return this.constructorParameters;
        }

        public Map<Method, List<String>> getMethodParameters() {
            return this.methodParameters;
        }

        public Map<String, Exception> getExceptions() {
            return this.exceptions;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!name.equals(this.methodName)) {
                return null;
            }
            try {
                boolean isStaticMethod;
                ArrayList<Object> parameterNames;
                if (this.methodName.equals("<init>")) {
                    Constructor constructor = this.constructorMap.get(desc);
                    if (constructor == null) {
                        return null;
                    }
                    parameterNames = new ArrayList<Object>(constructor.getParameterTypes().length);
                    parameterNames.addAll(Collections.nCopies(constructor.getParameterTypes().length, null));
                    this.constructorParameters.put(constructor, parameterNames);
                    isStaticMethod = false;
                } else {
                    Method method = this.methodMap.get(desc);
                    if (method == null) {
                        return null;
                    }
                    parameterNames = new ArrayList(method.getParameterTypes().length);
                    parameterNames.addAll(Collections.nCopies(method.getParameterTypes().length, null));
                    this.methodParameters.put(method, parameterNames);
                    isStaticMethod = Modifier.isStatic(method.getModifiers());
                }
                return new EmptyVisitor(){

                    public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
                        if (isStaticMethod) {
                            if (index < parameterNames.size()) {
                                parameterNames.set(index, name);
                            }
                        } else if (index > 0 && --index < parameterNames.size()) {
                            parameterNames.set(index, name);
                        }
                    }
                };
            }
            catch (Exception e) {
                this.exceptions.put(signature, e);
                return null;
            }
        }
    }
}

