/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.services.accessor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppBundleClassLoaderDelegateHook
implements ClassLoaderDelegateHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAppBundleClassLoaderDelegateHook.class);
    private static final int MAX_API_SEARCH_DEPTH = 1;
    private static final int MAX_IMPL_SEARCH_DEPTH = 2;
    private static final int MAX_RESOURCE_SEARCH_DEPTH = 1;
    private final ThreadLocal<AtomicInteger> delegationInProgress = new ThreadLocal();
    private final Set<Bundle> apiBundles = new CopyOnWriteArraySet<Bundle>();
    private final Set<Bundle> implBundles = new CopyOnWriteArraySet<Bundle>();
    private final Map<Bundle, ClassLoader> implBundlesClassloaders = new ConcurrentHashMap<Bundle, ClassLoader>();
    private final Map<Bundle, Set<String>> webAppBundles = new ConcurrentHashMap<Bundle, Set<String>>();

    WebAppBundleClassLoaderDelegateHook() {
    }

    /*
     * Exception decompiling
     */
    public Class<?> postFindClass(String name, BundleClassLoader bcl, BundleData bd) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String postFindLibrary(String name, BundleClassLoader bcl, BundleData bd) {
        return null;
    }

    public URL postFindResource(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        if (this.shouldEnter(1)) {
            try {
                ClassLoader tccl;
                this.enter();
                Bundle bundle = bd.getBundle();
                if (this.webAppBundles.containsKey(bundle)) {
                    URL uRL = this.doFindApiResource(name);
                    return uRL;
                }
                if (this.implBundles.contains(bundle) && (tccl = Thread.currentThread().getContextClassLoader()) != null) {
                    URL uRL = tccl.getResource(name);
                    return uRL;
                }
            }
            finally {
                this.exit();
            }
        }
        return null;
    }

    private boolean shouldEnter(int maxDepth) {
        if (this.delegationInProgress.get() == null) {
            return true;
        }
        return this.delegationInProgress.get().get() < maxDepth;
    }

    private void enter() {
        if (this.delegationInProgress.get() == null) {
            this.delegationInProgress.set(new AtomicInteger(0));
        }
        this.delegationInProgress.get().incrementAndGet();
    }

    private void exit() {
        if (this.delegationInProgress.get() != null && this.delegationInProgress.get().get() > 0) {
            this.delegationInProgress.get().decrementAndGet();
        }
    }

    public Enumeration<URL> postFindResources(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        block10: {
            if (this.shouldEnter(1)) {
                try {
                    ClassLoader tccl;
                    this.enter();
                    Bundle bundle = bd.getBundle();
                    if (this.webAppBundles.containsKey(bundle)) {
                        Enumeration<URL> enumeration = this.doFindApiResources(name);
                        return enumeration;
                    }
                    if (!this.implBundles.contains(bundle) || (tccl = Thread.currentThread().getContextClassLoader()) == null) break block10;
                    try {
                        Enumeration<URL> enumeration = tccl.getResources(name);
                        return enumeration;
                    }
                    catch (IOException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Exception occurred while trying to find resources [" + name + "]. Exception message: " + e.getMessage());
                        }
                    }
                }
                finally {
                    this.exit();
                }
            }
        }
        return null;
    }

    public Class<?> preFindClass(String name, BundleClassLoader bcl, BundleData bd) throws ClassNotFoundException {
        block9: {
            if (this.shouldEnter(1)) {
                try {
                    block10: {
                        this.enter();
                        Bundle bundle = bd.getBundle();
                        if (!this.webAppBundles.containsKey(bundle)) break block9;
                        try {
                            if (!this.checkPackageInImport(name, this.webAppBundles.get(bundle))) break block10;
                            return null;
                        }
                        catch (ClassNotFoundException e) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Exception occurred while trying to find class [" + name + "]. Exception message: " + e.getMessage());
                            }
                            break block9;
                        }
                    }
                    Class<?> clazz = this.doFindApiClass(name);
                    return clazz;
                }
                finally {
                    this.exit();
                }
            }
        }
        return null;
    }

    private boolean checkPackageInImport(String className, Set<String> importedPackages) {
        int index = className.lastIndexOf(46);
        String packageName = className;
        if (index > -1) {
            packageName = className.substring(0, index);
        }
        return importedPackages.contains(packageName);
    }

    public String preFindLibrary(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        return null;
    }

    public URL preFindResource(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        return null;
    }

    public Enumeration<URL> preFindResources(String name, BundleClassLoader bcl, BundleData bd) throws FileNotFoundException {
        return null;
    }

    void addApiBundle(Bundle bundle) {
        this.apiBundles.add(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was added to API bundles.");
        }
    }

    void addImplBundle(Bundle bundle) {
        ClassLoader cl;
        this.implBundles.add(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was added to Impl bundles.");
        }
        if ((cl = this.getBundleClassloader(bundle)) != null) {
            this.implBundlesClassloaders.put(bundle, cl);
        }
    }

    void removeApiBundle(Bundle bundle) {
        this.apiBundles.remove(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was removed from API bundles.");
        }
    }

    void removeImplBundle(Bundle bundle) {
        this.implBundlesClassloaders.remove(bundle);
        this.implBundles.remove(bundle);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(bundle + "was removed from Impl bundles.");
        }
    }

    void addWebAppBundle(Bundle bundle) {
        this.webAppBundles.put(bundle, this.cacheRequiredCapabilities(bundle));
    }

    void removeWebAppBundle(Bundle bundle) {
        this.webAppBundles.remove(bundle);
    }

    private Set<String> cacheRequiredCapabilities(Bundle bundle) {
        HashSet<String> importedPackages = new HashSet<String>();
        BundleWiring bundleWiring = ((BundleRevision)bundle.adapt(BundleRevision.class)).getWiring();
        importedPackages.addAll(this.getImportedPackages(bundleWiring));
        importedPackages.addAll(this.getImportedPackagesFromRequiredBundles(bundleWiring));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deploying web bundle " + bundle.getSymbolicName() + " with import packages " + importedPackages);
        }
        return importedPackages;
    }

    private Set<String> getImportedPackagesFromRequiredBundles(BundleWiring bundleWiring) {
        HashSet<String> importedPackages = new HashSet<String>();
        List requiredWires = bundleWiring.getRequiredWires("osgi.wiring.bundle");
        for (BundleWire requiredWire : requiredWires) {
            List capabilities = requiredWire.getProviderWiring().getCapabilities("osgi.wiring.package");
            for (BundleCapability capability : capabilities) {
                importedPackages.add((String)capability.getAttributes().get("osgi.wiring.package"));
            }
        }
        return importedPackages;
    }

    private Set<String> getImportedPackages(BundleWiring bundleWiring) {
        HashSet<String> importedPackages = new HashSet<String>();
        List requiredWires = bundleWiring.getRequiredWires("osgi.wiring.package");
        for (BundleWire requiredWire : requiredWires) {
            importedPackages.add((String)requiredWire.getCapability().getAttributes().get("osgi.wiring.package"));
        }
        return importedPackages;
    }

    ClassLoader[] getImplBundlesClassloaders() {
        return this.implBundlesClassloaders.values().toArray(new ClassLoader[this.implBundlesClassloaders.size()]);
    }

    private Class<?> doFindApiClass(String name) throws ClassNotFoundException {
        for (Bundle bundle : this.apiBundles) {
            try {
                return bundle.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Exception occurred while trying to find class [" + name + "]. Exception message: " + e.getMessage());
            }
        }
        throw new ClassNotFoundException(name);
    }

    private URL doFindApiResource(String name) {
        for (Bundle bundle : this.apiBundles) {
            URL resource = bundle.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private Enumeration<URL> doFindApiResources(String name) {
        for (Bundle bundle : this.apiBundles) {
            try {
                Enumeration resources = bundle.getResources(name);
                if (resources == null) continue;
                return resources;
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Exception occurred while trying to find resources [" + name + "]. Exception message: " + e.getMessage());
            }
        }
        return null;
    }

    private ClassLoader getBundleClassloader(Bundle bundle) {
        if (bundle instanceof BundleHost) {
            return ((BundleHost)bundle).getClassLoader();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot obtain classloader for bundle " + bundle);
        }
        return null;
    }

    Set<Bundle> getApiBundles() {
        return this.apiBundles;
    }

    Set<Bundle> getImplBundles() {
        return this.implBundles;
    }
}

