/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.io.Serializable;
import javax.validation.Path;

public final class NodeImpl
implements Path.Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String INDEX_OPEN = "[";
    private static final String INDEX_CLOSE = "]";
    private final String name;
    private boolean inIterable;
    private Integer index;
    private Object key;

    public NodeImpl(String name) {
        this.name = name;
    }

    NodeImpl(Path.Node node) {
        this.name = node.getName();
        this.inIterable = node.isInIterable();
        this.index = node.getIndex();
        this.key = node.getKey();
    }

    public String getName() {
        return this.name;
    }

    public boolean isInIterable() {
        return this.inIterable;
    }

    public void setInIterable(boolean inIterable) {
        this.inIterable = inIterable;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.inIterable = true;
        this.index = index;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.inIterable = true;
        this.key = key;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name == null ? "" : this.name);
        if (this.inIterable) {
            builder.append(INDEX_OPEN);
            if (this.getIndex() != null) {
                builder.append(this.getIndex());
            } else if (this.getKey() != null) {
                builder.append(this.getKey());
            }
            builder.append(INDEX_CLOSE);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeImpl node = (NodeImpl)o;
        if (this.inIterable != node.inIterable) {
            return false;
        }
        if (this.index != null ? !this.index.equals(node.index) : node.index != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(node.key) : node.key != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(node.name) : node.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.inIterable ? 1 : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }
}

